/*
 * Decompiled with CFR 0.152.
 */
package mrthomas20121.thermalconstruct.datagen;

import java.util.Objects;
import mrthomas20121.thermalconstruct.init.ThermalConstructItems;
import mrthomas20121.thermalconstruct.item.MetalItem;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.ForgeRegistries;
import slimeknights.mantle.registration.object.ItemObject;

public class ThermalConstructItemModelProvider
extends ItemModelProvider {
    public ThermalConstructItemModelProvider(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "thermalconstruct", existingFileHelper);
    }

    protected void registerModels() {
        this.basicItem((Item)ThermalConstructItems.BASALZ_BONE.get());
        this.basicItem((Item)ThermalConstructItems.BLITZ_BONE.get());
        this.basicItem((Item)ThermalConstructItems.BLIZZ_BONE.get());
        for (ThermalConstructItems.ThermalCast cast : ThermalConstructItems.ThermalCast.VALUES) {
            ResourceLocation name = Objects.requireNonNull(ForgeRegistries.ITEMS.getKey((Object)((Item)ThermalConstructItems.CASTS.get((Enum)cast))));
            this.basicItem(name, "cast/" + cast.getName());
        }
        this.metalModel(ThermalConstructItems.COBALT);
        this.metalModel(ThermalConstructItems.SLIMESTEEL);
        this.metalModel(ThermalConstructItems.CINDERSLIME);
        this.metalModel(ThermalConstructItems.QUEENS_SLIME);
        this.metalModel(ThermalConstructItems.MANYULLYN);
        this.metalModel(ThermalConstructItems.AMETHYST_BRONZE);
        this.metalModel(ThermalConstructItems.HEPATIZON);
    }

    public ItemModelBuilder basicItem(ResourceLocation item, String texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString())).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(item.m_135827_(), "item/" + texture));
    }

    public ItemModelBuilder basicItem(Item item, String texture) {
        ResourceLocation loc = ForgeRegistries.ITEMS.getKey((Object)item);
        return this.basicItem(loc, texture);
    }

    public <T extends Item> ItemModelBuilder basicItem(ItemObject<T> item, String texture) {
        return this.basicItem(item.m_5456_(), texture);
    }

    public ItemModelBuilder basicItem(ResourceLocation item, String extra, String texture) {
        return (ItemModelBuilder)((ItemModelBuilder)((ItemModelBuilder)this.getBuilder(item.toString() + extra)).parent((ModelFile)new ModelFile.UncheckedModelFile("item/generated"))).texture("layer0", new ResourceLocation(item.m_135827_(), "item/" + texture));
    }

    public ItemModelBuilder basicItem(Item item, String extra, String texture) {
        ResourceLocation loc = ForgeRegistries.ITEMS.getKey((Object)item);
        return this.basicItem(loc, extra, texture);
    }

    public <T extends Item> ItemModelBuilder basicItem(ItemObject<T> item, String extra, String texture) {
        return this.basicItem(item.m_5456_(), extra, texture);
    }

    public void metalModel(MetalItem metalItem) {
        this.basicItem(metalItem.getDust(), "material/" + metalItem.getName() + "_dust");
        this.basicItem(metalItem.getGear(), "material/" + metalItem.getName() + "_gear");
        ItemModelBuilder coin = this.basicItem(metalItem.getCoin(), "material/" + metalItem.getName() + "_coin_0");
        coin.override().model((ModelFile)this.basicItem(metalItem.getCoin(), "_0", "material/" + metalItem.getName() + "_coin_0")).predicate(new ResourceLocation("count"), 0.0f).end().override().model((ModelFile)this.basicItem(metalItem.getCoin(), "_1", "material/" + metalItem.getName() + "_coin_1")).predicate(new ResourceLocation("count"), 0.03125f).end().override().model((ModelFile)this.basicItem(metalItem.getCoin(), "_2", "material/" + metalItem.getName() + "_coin_2")).predicate(new ResourceLocation("count"), 0.25f).end().override().model((ModelFile)this.basicItem(metalItem.getCoin(), "_3", "material/" + metalItem.getName() + "_coin_3")).predicate(new ResourceLocation("count"), 0.5f).end().override().model((ModelFile)this.basicItem(metalItem.getCoin(), "_4", "material/" + metalItem.getName() + "_coin_4")).predicate(new ResourceLocation("count"), 1.0f).end();
        ItemModelBuilder plate = this.basicItem(metalItem.getPlate(), "material/" + metalItem.getName() + "_plate_0");
        plate.override().model((ModelFile)this.basicItem(metalItem.getPlate(), "_0", "material/" + metalItem.getName() + "_plate_0")).predicate(new ResourceLocation("count"), 0.0f).end().override().model((ModelFile)this.basicItem(metalItem.getPlate(), "_1", "material/" + metalItem.getName() + "_plate_1")).predicate(new ResourceLocation("count"), 0.25f).end().override().model((ModelFile)this.basicItem(metalItem.getPlate(), "_2", "material/" + metalItem.getName() + "_plate_2")).predicate(new ResourceLocation("count"), 0.5f).end().override().model((ModelFile)this.basicItem(metalItem.getPlate(), "_3", "material/" + metalItem.getName() + "_plate_3")).predicate(new ResourceLocation("count"), 1.0f).end();
    }
}

