/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular.particles.splashes;

import com.leclowndu93150.particular.Particles;
import com.leclowndu93150.particular.mixin.AccessorBillboardParticle;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.NoRenderParticle;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.particle.ParticleProvider;
import net.minecraft.client.particle.SpriteSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.particles.SimpleParticleType;
import net.minecraft.tags.FluidTags;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class WaterSplashEmitterParticle
extends NoRenderParticle {
    private final float speed;
    private final float width;
    private final float height;

    WaterSplashEmitterParticle(ClientLevel clientWorld, double x, double y, double z, float width, float speed) {
        super(clientWorld, x, y, z);
        speed = Math.min(2.0f, speed);
        this.f_107226_ = 0.0f;
        this.f_107225_ = 24;
        this.speed = speed;
        this.width = width;
        this.height = speed / 2.0f + width / 3.0f;
        clientWorld.m_7106_((ParticleOptions)Particles.WATER_SPLASH.get(), x, y, z, (double)width, (double)this.height, 0.0);
        clientWorld.m_7106_((ParticleOptions)Particles.WATER_SPLASH_FOAM.get(), x, y, z, (double)width, (double)this.height, 0.0);
        clientWorld.m_7106_((ParticleOptions)Particles.WATER_SPLASH_RING.get(), x, y, z, (double)width, 0.0, 0.0);
        if ((double)speed > 0.5) {
            this.splash(width, 0.1875f + speed * 1.0f / 8.0f + width / 6.0f, 0.15f);
        } else {
            this.m_107274_();
        }
    }

    public void m_5989_() {
        super.m_5989_();
        if (this.f_107224_ == 8) {
            this.f_107208_.m_7106_((ParticleOptions)Particles.WATER_SPLASH.get(), this.f_107212_, this.f_107213_, this.f_107214_, (double)(this.width * 0.66f), (double)(this.height * 2.0f), 0.0);
            this.f_107208_.m_7106_((ParticleOptions)Particles.WATER_SPLASH_FOAM.get(), this.f_107212_, this.f_107213_, this.f_107214_, (double)(this.width * 0.66f), (double)(this.height * 2.0f), 0.0);
            this.f_107208_.m_7106_((ParticleOptions)Particles.WATER_SPLASH_RING.get(), this.f_107212_, this.f_107213_, this.f_107214_, (double)(this.width * 0.66f), 0.0, 0.0);
            this.splash(this.width * 0.66f, 0.375f + this.speed * 1.0f / 8.0f + this.width / 6.0f, 0.05f);
        }
        if (!this.f_107208_.m_6425_(BlockPos.m_274561_((double)this.f_107212_, (double)this.f_107213_, (double)this.f_107214_)).m_205070_(FluidTags.f_13131_)) {
            this.m_107274_();
        }
    }

    private void splash(float width, float speed, float spread) {
        int i = 0;
        while ((float)i < width * 20.0f) {
            Particle droplet = Minecraft.m_91087_().f_91061_.m_107370_((ParticleOptions)ParticleTypes.f_123804_, this.f_107212_, this.f_107213_ + 0.0625, this.f_107214_, 0.0, 0.0, 0.0);
            if (droplet != null) {
                double xVel = this.f_107223_.m_216328_(0.0, (double)spread);
                double yVel = (double)speed * this.f_107223_.m_216328_(1.0, 0.25);
                double zVel = this.f_107223_.m_216328_(0.0, (double)spread);
                droplet.m_107264_(this.f_107212_ + xVel / (double)spread * (double)width, this.f_107213_ + 0.0625, this.f_107214_ + zVel / (double)spread * (double)width);
                droplet.m_172260_(xVel, yVel, zVel);
                droplet.m_107253_(1.0f, 1.0f, 1.0f);
                ((AccessorBillboardParticle)droplet).setQuadSize(0.125f);
            }
            ++i;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class Factory
    implements ParticleProvider<SimpleParticleType> {
        public Factory(SpriteSet provider) {
        }

        @Nullable
        public Particle createParticle(SimpleParticleType SimpleParticleType2, ClientLevel clientWorld, double x, double y, double z, double g, double h, double i) {
            return new WaterSplashEmitterParticle(clientWorld, x, y, z, (float)g, (float)h);
        }
    }
}

