/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.particular;

import java.util.Arrays;
import java.util.List;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import org.apache.commons.lang3.tuple.Pair;

public class ParticularConfig {
    public static final CommonConfig COMMON;
    public static final ForgeConfigSpec COMMON_SPEC;

    public static boolean waterSplash() {
        return (Boolean)ParticularConfig.COMMON.waterSplash.get();
    }

    public static boolean cascades() {
        return (Boolean)ParticularConfig.COMMON.cascades.get();
    }

    public static boolean waterfallSpray() {
        return (Boolean)ParticularConfig.COMMON.waterfallSpray.get();
    }

    public static boolean fireflies() {
        return (Boolean)ParticularConfig.COMMON.fireflies.get();
    }

    public static boolean fallingLeaves() {
        return (Boolean)ParticularConfig.COMMON.fallingLeaves.get();
    }

    public static boolean caveDust() {
        return (Boolean)ParticularConfig.COMMON.caveDust.get();
    }

    public static boolean chestBubbles() {
        return (Boolean)ParticularConfig.COMMON.chestBubbles.get();
    }

    public static boolean soulSandBubbles() {
        return (Boolean)ParticularConfig.COMMON.soulSandBubbles.get();
    }

    public static boolean barrelBubbles() {
        return (Boolean)ParticularConfig.COMMON.barrelBubbles.get();
    }

    public static boolean poppingBubbles() {
        return (Boolean)ParticularConfig.COMMON.poppingBubbles.get();
    }

    public static boolean rainRipples() {
        return (Boolean)ParticularConfig.COMMON.rainRipples.get();
    }

    public static boolean waterDripRipples() {
        return (Boolean)ParticularConfig.COMMON.waterDripRipples.get();
    }

    public static boolean cakeEatingParticles() {
        return (Boolean)ParticularConfig.COMMON.cakeEatingParticles.get();
    }

    public static boolean emissiveLavaDrips() {
        return (Boolean)ParticularConfig.COMMON.emissiveLavaDrips.get();
    }

    public static List<ResourceLocation> getCaveDustExcludeBiomes() {
        return ((List)ParticularConfig.COMMON.caveDustExcludeBiomes.get()).stream().map(ResourceLocation::m_135820_).toList();
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(CommonConfig::new);
        COMMON = (CommonConfig)specPair.getLeft();
        COMMON_SPEC = (ForgeConfigSpec)specPair.getRight();
    }

    public static class CommonConfig {
        public final ForgeConfigSpec.BooleanValue waterSplash;
        public final ForgeConfigSpec.BooleanValue cascades;
        public final ForgeConfigSpec.BooleanValue waterfallSpray;
        public final ForgeConfigSpec.BooleanValue fireflies;
        public final ForgeConfigSpec.BooleanValue fallingLeaves;
        public final ForgeConfigSpec.BooleanValue caveDust;
        public final ForgeConfigSpec.BooleanValue chestBubbles;
        public final ForgeConfigSpec.BooleanValue soulSandBubbles;
        public final ForgeConfigSpec.BooleanValue barrelBubbles;
        public final ForgeConfigSpec.BooleanValue poppingBubbles;
        public final ForgeConfigSpec.BooleanValue rainRipples;
        public final ForgeConfigSpec.BooleanValue waterDripRipples;
        public final ForgeConfigSpec.BooleanValue cakeEatingParticles;
        public final ForgeConfigSpec.BooleanValue emissiveLavaDrips;
        public final ForgeConfigSpec.IntValue fireflyStartTime;
        public final ForgeConfigSpec.IntValue fireflyEndTime;
        public final ForgeConfigSpec.DoubleValue fireflyMinTemp;
        public final ForgeConfigSpec.DoubleValue fireflyMaxTemp;
        public final ForgeConfigSpec.BooleanValue fireflyCanSpawnInRain;
        public final ForgeConfigSpec.ConfigValue<List<? extends Double>> fireflyDailyRandom;
        public final ForgeConfigSpec.DoubleValue fireflyGrassFrequency;
        public final ForgeConfigSpec.DoubleValue fireflyTallGrassFrequency;
        public final ForgeConfigSpec.DoubleValue fireflyFlowersFrequency;
        public final ForgeConfigSpec.DoubleValue fireflyTallFlowersFrequency;
        public final ForgeConfigSpec.IntValue fallingLeavesSpawnChance;
        public final ForgeConfigSpec.BooleanValue fallingLeavesSpawnRipples;
        public final ForgeConfigSpec.BooleanValue fallingLeavesLayFlatOnGround;
        public final ForgeConfigSpec.BooleanValue fallingLeavesLayFlatRightAngles;
        public final ForgeConfigSpec.IntValue caveDustSpawnChance;
        public final ForgeConfigSpec.IntValue caveDustBaseMaxAge;
        public final ForgeConfigSpec.IntValue caveDustColor;
        public final ForgeConfigSpec.IntValue caveDustFadeDuration;
        public final ForgeConfigSpec.DoubleValue caveDustMaxAcceleration;
        public final ForgeConfigSpec.IntValue caveDustAccelChangeChance;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> caveDustExcludeBiomes;

        CommonConfig(ForgeConfigSpec.Builder builder) {
            builder.comment("Particular Mod Configuration").push("general");
            builder.comment("Enable/Disable Effects").push("enabledEffects");
            this.waterSplash = builder.comment("Enable water splash particles").define("waterSplash", true);
            this.cascades = builder.comment("Enable cascade particles").define("cascades", true);
            this.waterfallSpray = builder.comment("Enable waterfall spray particles").define("waterfallSpray", true);
            this.fireflies = builder.comment("Enable firefly particles").define("fireflies", true);
            this.fallingLeaves = builder.comment("Enable falling leaves particles").define("fallingLeaves", true);
            this.caveDust = builder.comment("Enable cave dust particles").define("caveDust", true);
            this.chestBubbles = builder.comment("Enable chest bubbles").define("chestBubbles", true);
            this.soulSandBubbles = builder.comment("Enable soul sand bubbles").define("soulSandBubbles", true);
            this.barrelBubbles = builder.comment("Enable barrel bubbles").define("barrelBubbles", true);
            this.poppingBubbles = builder.comment("Enable popping bubbles").define("poppingBubbles", true);
            this.rainRipples = builder.comment("Enable rain ripples").define("rainRipples", true);
            this.waterDripRipples = builder.comment("Enable water drip ripples").define("waterDripRipples", true);
            this.cakeEatingParticles = builder.comment("Enable cake eating particles").define("cakeEatingParticles", true);
            this.emissiveLavaDrips = builder.comment("Enable emissive lava drips").define("emissiveLavaDrips", true);
            builder.pop();
            builder.comment("Advanced Particle Settings").push("advancedSettings");
            builder.push("fireflySettings");
            this.fireflyStartTime = builder.comment("Time when fireflies start spawning").defineInRange("startTime", 12000, 0, 23999);
            this.fireflyEndTime = builder.comment("Time when fireflies stop spawning").defineInRange("endTime", 23000, 0, 23999);
            this.fireflyMinTemp = builder.comment("Minimum temperature for fireflies to spawn").defineInRange("minTemp", 0.5, 0.0, 2.0);
            this.fireflyMaxTemp = builder.comment("Maximum temperature for fireflies to spawn").defineInRange("maxTemp", (double)0.99f, 0.0, 2.0);
            this.fireflyCanSpawnInRain = builder.comment("Whether fireflies can spawn in rain").define("canSpawnInRain", false);
            builder.push("frequencyModifiers");
            this.fireflyDailyRandom = builder.comment("Daily random factors for firefly spawning").defineList("dailyRandom", Arrays.asList(0.0, 0.0, 0.0, 0.33, 0.66, 1.0), entry -> entry instanceof Double);
            this.fireflyGrassFrequency = builder.comment("Frequency modifier for grass").defineInRange("grass", 0.16666666666666666, 0.0, 1.0);
            this.fireflyTallGrassFrequency = builder.comment("Frequency modifier for tall grass").defineInRange("tallGrass", 0.08333333333333333, 0.0, 1.0);
            this.fireflyFlowersFrequency = builder.comment("Frequency modifier for flowers").defineInRange("flowers", 1.0, 0.0, 1.0);
            this.fireflyTallFlowersFrequency = builder.comment("Frequency modifier for tall flowers").defineInRange("tallFlowers", 0.5, 0.0, 1.0);
            builder.pop();
            builder.pop();
            builder.push("fallingLeavesSettings");
            this.fallingLeavesSpawnChance = builder.comment("Chance of spawning falling leaves (higher = less frequent)").defineInRange("spawnChance", 60, 1, Integer.MAX_VALUE);
            this.fallingLeavesSpawnRipples = builder.comment("Whether falling leaves create ripples when landing on water").define("spawnRipples", true);
            this.fallingLeavesLayFlatOnGround = builder.comment("Whether falling leaves lay flat on the ground").define("layFlatOnGround", true);
            this.fallingLeavesLayFlatRightAngles = builder.comment("Whether falling leaves lay at right angles").define("layFlatRightAngles", false);
            builder.pop();
            builder.push("caveDustSettings");
            this.caveDustSpawnChance = builder.comment("Chance of spawning cave dust (higher = less frequent)").defineInRange("spawnChance", 700, 1, Integer.MAX_VALUE);
            this.caveDustBaseMaxAge = builder.comment("Base maximum age of cave dust particles").defineInRange("baseMaxAge", 200, 1, Integer.MAX_VALUE);
            this.caveDustColor = builder.comment("OwOColor of cave dust particles (RGB hex)").defineInRange("color", 0x808080, 0, 0xFFFFFF);
            this.caveDustFadeDuration = builder.comment("Duration of fade effect for cave dust particles").defineInRange("fadeDuration", 20, 0, Integer.MAX_VALUE);
            this.caveDustMaxAcceleration = builder.comment("Maximum acceleration of cave dust particles").defineInRange("maxAcceleration", (double)0.03f, 0.0, 1.0);
            this.caveDustAccelChangeChance = builder.comment("Chance of changing acceleration for cave dust particles").defineInRange("accelChangeChance", 180, 1, Integer.MAX_VALUE);
            this.caveDustExcludeBiomes = builder.comment("Biomes where cave dust won't spawn").defineList("excludeBiomes", Arrays.asList("minecraft:lush_caves", "minecraft:dripstone_caves", "minecraft:deep_dark"), entry -> entry instanceof String);
            builder.pop();
            builder.pop();
            builder.pop();
        }
    }
}

