/*
 * Decompiled with CFR 0.152.
 */
package com.leclowndu93150.configurable_spawners.mixin;

import com.leclowndu93150.configurable_spawners.SpawnerConfig;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.BaseSpawner;
import net.minecraft.world.level.ServerLevelAccessor;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={BaseSpawner.class})
public class BaseSpawnerMixin {
    @Shadow
    private int f_45447_;
    @Shadow
    private int f_45448_;
    @Shadow
    private int f_45449_;
    @Shadow
    private int f_45451_;
    @Shadow
    private int f_45452_;
    @Shadow
    private int f_45453_;

    @Inject(method={"load"}, at={@At(value="RETURN")})
    private void onLoad(CallbackInfo ci) {
        this.updateConfigValues();
    }

    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void onInit(CallbackInfo ci) {
        this.updateConfigValues();
    }

    @Redirect(method={"serverTick"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/entity/SpawnPlacements;checkSpawnRules(Lnet/minecraft/world/entity/EntityType;Lnet/minecraft/world/level/ServerLevelAccessor;Lnet/minecraft/world/entity/MobSpawnType;Lnet/minecraft/core/BlockPos;Lnet/minecraft/util/RandomSource;)Z"))
    private boolean forceSpawnRules(EntityType<?> p_217075_, ServerLevelAccessor p_217076_, MobSpawnType p_217077_, BlockPos p_217078_, RandomSource p_217079_) {
        return true;
    }

    @Inject(method={"save"}, at={@At(value="HEAD")})
    private void onSave(CompoundTag tag, CallbackInfoReturnable<CompoundTag> cir) {
        tag.m_128376_("MinSpawnDelay", (short)this.f_45447_);
        tag.m_128376_("MaxSpawnDelay", (short)this.f_45448_);
        tag.m_128376_("SpawnCount", (short)this.f_45449_);
        tag.m_128376_("MaxNearbyEntities", (short)this.f_45451_);
        tag.m_128376_("RequiredPlayerRange", (short)this.f_45452_);
        tag.m_128376_("SpawnRange", (short)this.f_45453_);
    }

    @Unique
    private void updateConfigValues() {
        CompoundTag tag = ((BaseSpawner)this).m_186381_(new CompoundTag());
        if (tag.m_128471_("ConfigurableSpawnerModified")) {
            this.applyConfigSettings();
        } else if (this.hasDefaultValues()) {
            this.applyConfigSettings();
            tag.m_128379_("ConfigurableSpawnerModified", true);
        }
    }

    @Unique
    private boolean hasDefaultValues() {
        return this.f_45447_ == 200 && this.f_45448_ == 800 && this.f_45449_ == 4 && this.f_45451_ == 6 && this.f_45452_ == 16 && this.f_45453_ == 4;
    }

    @Unique
    private void applyConfigSettings() {
        this.f_45447_ = (Integer)SpawnerConfig.minSpawnDelay.get();
        this.f_45448_ = (Integer)SpawnerConfig.maxSpawnDelay.get();
        this.f_45449_ = (Integer)SpawnerConfig.spawnCount.get();
        this.f_45451_ = (Integer)SpawnerConfig.maxNearbyEntities.get();
        this.f_45452_ = (Integer)SpawnerConfig.requiredPlayerRange.get();
        this.f_45453_ = (Integer)SpawnerConfig.spawnRange.get();
    }
}

