/*
 * Decompiled with CFR 0.152.
 */
package io.redspace.ironsspellbooks.api.util;

import io.redspace.ironsspellbooks.api.util.CameraShakeData;
import io.redspace.ironsspellbooks.network.SyncAllCameraShakesPacket;
import io.redspace.ironsspellbooks.network.SyncCameraShakePacket;
import io.redspace.ironsspellbooks.setup.PacketDistributor;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ViewportEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class CameraShakeManager {
    public static final ArrayList<CameraShakeData> cameraShakeData = new ArrayList();
    public static ArrayList<CameraShakeData> clientCameraShakeData = new ArrayList();
    private static int nextId = 0;
    private static final int fadeoutDuration = 20;
    private static final float fadeoutMultiplier = 0.05f;

    public static int getNextId() {
        return nextId++;
    }

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent event) {
        if (cameraShakeData.isEmpty() || event.phase == TickEvent.Phase.START) {
            return;
        }
        ArrayList<CameraShakeData> completed = new ArrayList<CameraShakeData>();
        for (CameraShakeData data : cameraShakeData) {
            ++data.tickCount;
            if (data.tickCount < data.duration) continue;
            completed.add(data);
        }
        if (!completed.isEmpty()) {
            completed.forEach(CameraShakeManager::removeCameraShake);
        }
    }

    public static void addCameraShake(CameraShakeData data) {
        cameraShakeData.add(data);
        PacketDistributor.sendToAllPlayers(new SyncCameraShakePacket(data, false));
    }

    public static void removeCameraShake(CameraShakeData data) {
        if (cameraShakeData.removeIf(instance -> instance.id == data.id)) {
            PacketDistributor.sendToAllPlayers(new SyncCameraShakePacket(data, true));
        }
    }

    public static void addClientCameraShake(CameraShakeData data) {
        clientCameraShakeData.add(data);
    }

    public static void removeClientCameraShake(CameraShakeData data) {
        clientCameraShakeData.removeIf(instance -> instance.id == data.id);
    }

    public static void doSync(ServerPlayer serverPlayer) {
        PacketDistributor.sendToPlayer(serverPlayer, new SyncAllCameraShakesPacket(cameraShakeData));
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handleCameraShake(ViewportEvent.ComputeCameraAngles event) {
        if (clientCameraShakeData.isEmpty()) {
            return;
        }
        Entity player = event.getCamera().m_90592_();
        List<CameraShakeData> sortedActiveCameraShakes = clientCameraShakeData.stream().filter(data -> data.dimension.equals((Object)player.f_19853_.m_46472_())).sorted(Comparator.comparingDouble(o -> o.origin.m_82557_(player.m_20182_()))).toList();
        if (sortedActiveCameraShakes.isEmpty()) {
            return;
        }
        CameraShakeData cameraShake = sortedActiveCameraShakes.get(0);
        Vec3 closestPos = cameraShake.origin;
        float distanceMultiplier = 1.0f / (cameraShake.radius * cameraShake.radius);
        float fadeout = cameraShake.duration - cameraShake.tickCount >= 20 ? 1.0f : (float)(cameraShake.duration - cameraShake.tickCount) * 0.05f;
        fadeout = Mth.m_14036_((float)fadeout, (float)0.0f, (float)1.0f);
        float intensity = (float)Mth.m_14085_((double)1.0, (double)0.0, (double)(closestPos.m_82557_(player.m_20182_()) * (double)distanceMultiplier)) * fadeout;
        float f = (float)((double)player.f_19797_ + event.getPartialTick());
        float yaw = Mth.m_14089_((float)(f * 1.5f)) * intensity * 0.5f;
        float pitch = Mth.m_14089_((float)(f * 2.0f)) * intensity * 0.5f;
        float roll = Mth.m_14031_((float)(f * 2.2f)) * intensity * 0.5f;
        event.setYaw(event.getYaw() + yaw);
        event.setRoll(event.getRoll() + roll);
        event.setPitch(event.getPitch() + pitch);
    }

    @SubscribeEvent
    @OnlyIn(value=Dist.CLIENT)
    public static void handleCameraShake(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START || Minecraft.m_91087_().m_257720_() && Minecraft.m_91087_().m_91104_()) {
            return;
        }
        ArrayList<CameraShakeData> toRemove = new ArrayList<CameraShakeData>();
        for (CameraShakeData data : clientCameraShakeData) {
            ++data.tickCount;
            if (data.tickCount <= data.duration + 5) continue;
            toRemove.add(data);
        }
        clientCameraShakeData.removeAll(toRemove);
    }
}

