/*
 * Decompiled with CFR 0.152.
 */
package com.cak.trading_floor.forge.content.depot;

import com.cak.trading_floor.content.trading_depot.CommonTradingDepotBlock;
import com.cak.trading_floor.content.trading_depot.CommonTradingDepotBlockEntity;
import com.cak.trading_floor.forge.content.depot.TradingDepotBlockEntity;
import com.cak.trading_floor.forge.content.depot.behavior.TradingDepotBehaviour;
import com.cak.trading_floor.foundation.advancement.TFAdvancementBehaviour;
import com.cak.trading_floor.registry.TFRegistry;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.content.kinetics.belt.behaviour.DirectBeltInputBehaviour;
import com.simibubi.create.content.kinetics.belt.transport.TransportedItemStack;
import com.simibubi.create.foundation.block.IBE;
import com.simibubi.create.foundation.blockEntity.behaviour.BehaviourType;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class TradingDepotBlock
extends CommonTradingDepotBlock
implements IBE<CommonTradingDepotBlockEntity>,
IWrenchable {
    public static final VoxelShape SHAPE = Shapes.m_83110_((VoxelShape)Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)8.0, (double)16.0), (VoxelShape)Block.m_49796_((double)1.0, (double)8.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0));

    public TradingDepotBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{f_54117_});
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_());
    }

    protected static TradingDepotBehaviour get(BlockGetter worldIn, BlockPos pos) {
        return (TradingDepotBehaviour)BlockEntityBehaviour.get((BlockGetter)worldIn, (BlockPos)pos, TradingDepotBehaviour.TYPE);
    }

    public InteractionResult m_6227_(BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        if (ray.m_82434_() == ((Direction)state.m_61143_((Property)f_54117_)).m_122424_()) {
            return InteractionResult.PASS;
        }
        if (world.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        TradingDepotBehaviour behaviour = TradingDepotBlock.get((BlockGetter)world, pos);
        if (behaviour == null) {
            return InteractionResult.PASS;
        }
        ItemStack heldItem = player.m_21120_(hand);
        boolean wasEmptyHanded = heldItem.m_41619_();
        boolean skipItemPlacement = AllBlocks.MECHANICAL_ARM.isIn(heldItem);
        if (wasEmptyHanded) {
            if (!behaviour.getResults().isEmpty()) {
                for (ItemStack stack : behaviour.getResults()) {
                    player.m_150109_().m_150079_(stack);
                }
                behaviour.getResults().clear();
            } else if (!behaviour.getOfferStack().m_41619_()) {
                player.m_150109_().m_150079_(behaviour.getOfferStack());
                behaviour.setOfferStack(ItemStack.f_41583_);
            }
        } else if (!skipItemPlacement) {
            TransportedItemStack transported = new TransportedItemStack(heldItem);
            transported.insertedFrom = player.m_6350_();
            transported.prevBeltPosition = 0.25f;
            transported.beltPosition = 0.25f;
            if (!behaviour.getOfferStack().m_41619_()) {
                player.m_150109_().m_150079_(behaviour.getOfferStack());
                behaviour.setOfferStack(ItemStack.f_41583_);
            }
            behaviour.setOfferStack(transported);
            player.m_21008_(hand, ItemStack.f_41583_);
            AllSoundEvents.DEPOT_SLIDE.playOnServer(world, (Vec3i)pos);
        }
        behaviour.blockEntity.notifyUpdate();
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        IBE.onRemove((BlockState)state, (Level)level, (BlockPos)pos, (BlockState)newState);
    }

    public VoxelShape m_5909_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return Shapes.m_83040_();
    }

    public boolean m_7420_(BlockState state, BlockGetter level, BlockPos pos) {
        return true;
    }

    public Class<CommonTradingDepotBlockEntity> getBlockEntityClass() {
        return CommonTradingDepotBlockEntity.class;
    }

    public BlockEntityType<? extends CommonTradingDepotBlockEntity> getBlockEntityType() {
        return (BlockEntityType)TFRegistry.TRADING_DEPOT_BLOCK_ENTITY.get();
    }

    public void m_5548_(BlockGetter worldIn, Entity entityIn) {
        super.m_5548_(worldIn, entityIn);
        if (!(entityIn instanceof ItemEntity)) {
            return;
        }
        if (!entityIn.m_6084_()) {
            return;
        }
        if (entityIn.m_9236_().f_46443_) {
            return;
        }
        ItemEntity itemEntity = (ItemEntity)entityIn;
        DirectBeltInputBehaviour inputBehaviour = (DirectBeltInputBehaviour)BlockEntityBehaviour.get((BlockGetter)worldIn, (BlockPos)BlockPos.m_274446_((Position)entityIn.m_20182_().m_82492_(0.0, 0.1, 0.0)), (BehaviourType)DirectBeltInputBehaviour.TYPE);
        if (inputBehaviour == null) {
            return;
        }
        ItemStack remainder = inputBehaviour.handleInsertion(itemEntity.m_32055_(), Direction.DOWN, false);
        itemEntity.m_32045_(remainder);
        if (remainder.m_41619_()) {
            itemEntity.m_146870_();
        }
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, LivingEntity pPlacer, ItemStack pStack) {
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        TFAdvancementBehaviour.setPlacedBy(pLevel, pPos, pPlacer);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pos, BlockState state) {
        return new TradingDepotBlockEntity((BlockEntityType)TFRegistry.TRADING_DEPOT_BLOCK_ENTITY.get(), pos, state);
    }
}

