/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.impl.recipe;

import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.Widget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.nolij.toomanyrecipeviewers.TooManyRecipeViewers;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.builder.TMRVIngredientCollector;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.ingredient.TMRVSlotWidget;
import java.util.List;
import mezz.jei.api.gui.builder.IIngredientAcceptor;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.common.util.ImmutableRect2i;
import mezz.jei.library.focus.FocusGroup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.SmithingRecipe;
import org.jetbrains.annotations.Nullable;

public class ExtendedSmithingRecipe<R extends SmithingRecipe>
implements EmiRecipe {
    private final TooManyRecipeViewers runtime;
    private final R backingRecipe;
    private final ISmithingCategoryExtension<R> extension;
    private final ResourceLocation id;

    public ExtendedSmithingRecipe(TooManyRecipeViewers runtime, R backingRecipe, ISmithingCategoryExtension<R> extension, ResourceLocation id) {
        this.runtime = runtime;
        this.backingRecipe = backingRecipe;
        this.extension = extension;
        this.id = id;
    }

    public EmiRecipeCategory getCategory() {
        return VanillaEmiRecipeCategories.SMITHING;
    }

    @Nullable
    public ResourceLocation getId() {
        return this.id;
    }

    public List<EmiIngredient> getInputs() {
        return List.of(this.collect(this.extension::setTemplate).getEMIIngredient(), this.collect(this.extension::setBase).getEMIIngredient(), this.collect(this.extension::setAddition).getEMIIngredient());
    }

    public List<EmiStack> getOutputs() {
        return this.collect(this.extension::setOutput).getEMIStacks();
    }

    public int getDisplayWidth() {
        return 112;
    }

    public int getDisplayHeight() {
        return 18;
    }

    private TMRVIngredientCollector collect(SetMethod<R> setMethod) {
        TMRVIngredientCollector collector = new TMRVIngredientCollector(this.runtime.ingredientManager);
        setMethod.set(this.backingRecipe, collector);
        return collector;
    }

    private TMRVSlotWidget addSlot(WidgetHolder widgets, SetMethod<R> setMethod, ImmutableRect2i rect, RecipeIngredientRole role) {
        TMRVSlotWidget slot = new TMRVSlotWidget(this.runtime.ingredientManager, role, rect);
        setMethod.set(this.backingRecipe, slot.getIngredientCollector());
        return (TMRVSlotWidget)widgets.add((Widget)slot);
    }

    public void addWidgets(WidgetHolder widgets) {
        widgets.addTexture(EmiTexture.EMPTY_ARROW, 62, 1);
        ImmutableRect2i origin = new ImmutableRect2i(1, 1, 16, 16);
        TMRVSlotWidget templateSlot = this.addSlot(widgets, this.extension::setTemplate, origin, RecipeIngredientRole.INPUT);
        TMRVSlotWidget baseSlot = this.addSlot(widgets, this.extension::setBase, origin.addOffset(18, 0), RecipeIngredientRole.INPUT);
        TMRVSlotWidget additionSlot = this.addSlot(widgets, this.extension::setAddition, origin.addOffset(36, 0), RecipeIngredientRole.INPUT);
        TMRVSlotWidget outputSlot = this.addSlot(widgets, this.extension::setOutput, origin.addOffset(94, 0), RecipeIngredientRole.OUTPUT);
        outputSlot.recipeContext(this);
        this.extension.onDisplayedIngredientsUpdate(this.backingRecipe, templateSlot, baseSlot, additionSlot, outputSlot, FocusGroup.EMPTY);
    }

    @FunctionalInterface
    private static interface SetMethod<R extends SmithingRecipe> {
        public <T extends IIngredientAcceptor<T>> void set(R var1, T var2);
    }
}

