/*
 * Decompiled with CFR 0.152.
 */
package dev.nolij.toomanyrecipeviewers.impl.jei.api.recipe;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.EmiApi;
import dev.emi.emi.api.EmiRegistry;
import dev.emi.emi.api.recipe.EmiCraftingRecipe;
import dev.emi.emi.api.recipe.EmiInfoRecipe;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.recipe.EmiRecipe;
import dev.emi.emi.api.recipe.EmiRecipeCategory;
import dev.emi.emi.api.recipe.VanillaEmiRecipeCategories;
import dev.emi.emi.api.render.EmiTexture;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.SlotWidget;
import dev.emi.emi.api.widget.WidgetHolder;
import dev.emi.emi.jemi.JemiCategory;
import dev.emi.emi.recipe.EmiBrewingRecipe;
import dev.emi.emi.recipe.EmiCompostingRecipe;
import dev.emi.emi.recipe.EmiCookingRecipe;
import dev.emi.emi.recipe.EmiFuelRecipe;
import dev.emi.emi.recipe.EmiShapedRecipe;
import dev.emi.emi.recipe.EmiShapelessRecipe;
import dev.emi.emi.recipe.EmiSmithingRecipe;
import dev.emi.emi.recipe.EmiStonecuttingRecipe;
import dev.emi.emi.registry.EmiRecipes;
import dev.emi.emi.runtime.EmiReloadManager;
import dev.nolij.toomanyrecipeviewers.TooManyRecipeViewers;
import dev.nolij.toomanyrecipeviewers.TooManyRecipeViewersMod;
import dev.nolij.toomanyrecipeviewers.impl.ingredient.ErrorEmiStack;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.gui.builder.RecipeLayoutBuilder;
import dev.nolij.toomanyrecipeviewers.impl.jei.api.runtime.IngredientManager;
import dev.nolij.toomanyrecipeviewers.impl.recipe.ExtendedSmithingRecipe;
import dev.nolij.toomanyrecipeviewers.impl.recipe.TMRVRecipe;
import dev.nolij.toomanyrecipeviewers.mixin.SmithingRecipeCategoryAccessor;
import dev.nolij.toomanyrecipeviewers.util.ResourceLocationHolderComparator;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Stream;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.gui.IRecipeLayoutDrawable;
import mezz.jei.api.gui.drawable.IScalableDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotDrawable;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.ingredients.ITypedIngredient;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.IRecipeCatalystLookup;
import mezz.jei.api.recipe.IRecipeCategoriesLookup;
import mezz.jei.api.recipe.IRecipeLookup;
import mezz.jei.api.recipe.IRecipeManager;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.advanced.IRecipeManagerPlugin;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.recipe.category.extensions.IRecipeCategoryDecorator;
import mezz.jei.api.recipe.category.extensions.vanilla.smithing.ISmithingCategoryExtension;
import mezz.jei.api.recipe.vanilla.IJeiAnvilRecipe;
import mezz.jei.api.recipe.vanilla.IJeiBrewingRecipe;
import mezz.jei.api.recipe.vanilla.IJeiCompostingRecipe;
import mezz.jei.api.recipe.vanilla.IJeiFuelingRecipe;
import mezz.jei.api.recipe.vanilla.IJeiIngredientInfoRecipe;
import mezz.jei.api.runtime.IIngredientVisibility;
import mezz.jei.common.util.ErrorUtil;
import mezz.jei.core.util.Pair;
import mezz.jei.library.focus.FocusGroup;
import mezz.jei.library.gui.ingredients.CycleTimer;
import mezz.jei.library.gui.ingredients.ICycler;
import mezz.jei.library.gui.recipes.RecipeLayout;
import mezz.jei.library.gui.recipes.layout.builder.RecipeSlotBuilder;
import mezz.jei.library.util.RecipeErrorUtil;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.Style;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.BlastingRecipe;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.CraftingRecipe;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.minecraft.world.item.crafting.SmeltingRecipe;
import net.minecraft.world.item.crafting.SmithingRecipe;
import net.minecraft.world.item.crafting.SmokingRecipe;
import net.minecraft.world.item.crafting.StonecutterRecipe;
import org.apache.logging.log4j.Level;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;
import toomanyrecipeviewers.xyz.wagyourtail.jvmdg.j21.stub.java_base.J_U_List;

public class RecipeManager
implements IRecipeManager,
TooManyRecipeViewers.ILockable {
    public static final Map<RecipeType<?>, EmiRecipeCategory> vanillaJEITypeEMICategoryMap = ImmutableMap.builder().put(RecipeTypes.CRAFTING, (Object)VanillaEmiRecipeCategories.CRAFTING).put(RecipeTypes.SMELTING, (Object)VanillaEmiRecipeCategories.SMELTING).put(RecipeTypes.BLASTING, (Object)VanillaEmiRecipeCategories.BLASTING).put(RecipeTypes.SMOKING, (Object)VanillaEmiRecipeCategories.SMOKING).put(RecipeTypes.CAMPFIRE_COOKING, (Object)VanillaEmiRecipeCategories.CAMPFIRE_COOKING).put(RecipeTypes.STONECUTTING, (Object)VanillaEmiRecipeCategories.STONECUTTING).put(RecipeTypes.SMITHING, (Object)VanillaEmiRecipeCategories.SMITHING).put(RecipeTypes.ANVIL, (Object)VanillaEmiRecipeCategories.ANVIL_REPAIRING).put(RecipeTypes.BREWING, (Object)VanillaEmiRecipeCategories.BREWING).put(RecipeTypes.FUELING, (Object)VanillaEmiRecipeCategories.FUEL).put(RecipeTypes.COMPOSTING, (Object)VanillaEmiRecipeCategories.COMPOSTING).put(RecipeTypes.INFORMATION, (Object)VanillaEmiRecipeCategories.INFO).build();
    public static final Map<EmiRecipeCategory, RecipeType<?>> vanillaEMICategoryJEIRecipeTypeMap;
    private final TooManyRecipeViewers runtime;
    private final EmiRegistry registry;
    private final @Unmodifiable List<IRecipeCategory<?>> jeiRecipeCategories;
    private final IngredientManager ingredientManager;
    private final IIngredientVisibility ingredientVisibility;
    private ImmutableListMultimap<RecipeType<?>, IRecipeCategoryDecorator<?>> recipeCategoryDecorators;
    private volatile boolean locked = false;
    private final Set<ResourceLocation> hiddenRecipeIDs = Collections.synchronizedSet(new HashSet());
    private final Set<EmiRecipeCategory> hiddenCategories = Collections.synchronizedSet(new HashSet());
    private final Set<ResourceLocation> replacedRecipeIDs = Collections.synchronizedSet(new HashSet());
    private final Set<EmiRecipe> replacementRecipes = Collections.synchronizedSet(new HashSet());
    private final Map<RecipeType<?>, Category<?>> jeiRecipeTypeMap = Collections.synchronizedMap(new HashMap());
    private final Map<EmiRecipeCategory, Category<?>> emiCategoryMap = Collections.synchronizedMap(new HashMap());

    public RecipeManager(TooManyRecipeViewers runtime) {
        runtime.lockAfterRegistration(this);
        this.runtime = runtime;
        this.registry = runtime.emiRegistry;
        this.jeiRecipeCategories = runtime.recipeCategories;
        this.ingredientManager = runtime.ingredientManager;
        this.ingredientVisibility = runtime.ingredientVisibility;
        for (IRecipeCategory<?> jeiCategory : this.jeiRecipeCategories) {
            RecipeType<?> jeiRecipeType = jeiCategory.getRecipeType();
            ImmutableList jeiCatalysts = runtime.recipeCatalysts.get(jeiRecipeType);
            List<EmiStack> emiCatalysts = jeiCatalysts.stream().map(this.ingredientManager::getEMIStack).toList();
            Category<?> category = this.category(jeiCategory);
            EmiRecipeCategory emiCategory = category.getEMICategory();
            if (emiCategory instanceof JemiCategory) {
                this.registry.addCategory(emiCategory);
            }
            for (EmiStack emiCatalyst : emiCatalysts) {
                if (emiCatalyst.isEmpty()) continue;
                this.registry.addWorkstation(emiCategory, (EmiIngredient)emiCatalyst);
            }
        }
    }

    @Override
    public <R> IRecipeLookup<R> createRecipeLookup(final RecipeType<R> recipeType) {
        return new IRecipeLookup<R>(){
            private boolean includeHidden = false;
            private IFocusGroup focusGroup = FocusGroup.EMPTY;

            @Override
            public IRecipeLookup<R> limitFocus(Collection<? extends IFocus<?>> focuses) {
                this.focusGroup = FocusGroup.create(focuses, RecipeManager.this.ingredientManager);
                return this;
            }

            @Override
            public IRecipeLookup<R> includeHidden() {
                this.includeHidden = true;
                return this;
            }

            @Override
            public Stream<R> get() {
                return RecipeManager.this.getRecipesStream(recipeType, this.focusGroup, this.includeHidden);
            }
        };
    }

    @Override
    public IRecipeCategoriesLookup createRecipeCategoryLookup() {
        return new IRecipeCategoriesLookup(){
            private boolean includeHidden = false;
            private Collection<RecipeType<?>> recipeTypes = List.of();
            private IFocusGroup focusGroup = FocusGroup.EMPTY;

            @Override
            public IRecipeCategoriesLookup limitTypes(Collection<RecipeType<?>> recipeTypes) {
                ErrorUtil.checkNotNull(recipeTypes, "recipeTypes");
                this.recipeTypes = recipeTypes;
                return this;
            }

            @Override
            public IRecipeCategoriesLookup limitFocus(Collection<? extends IFocus<?>> focuses) {
                ErrorUtil.checkNotNull(focuses, "focuses");
                this.focusGroup = FocusGroup.create(focuses, RecipeManager.this.ingredientManager);
                return this;
            }

            @Override
            public IRecipeCategoriesLookup includeHidden() {
                this.includeHidden = true;
                return this;
            }

            @Override
            public Stream<IRecipeCategory<?>> get() {
                return RecipeManager.this.getRecipeCategoriesForTypes(this.recipeTypes, this.focusGroup, this.includeHidden);
            }
        };
    }

    @Override
    public <T> IRecipeCategory<T> getRecipeCategory(RecipeType<T> recipeType) {
        return this.category(recipeType).getJEICategory();
    }

    @Override
    public IRecipeCatalystLookup createRecipeCatalystLookup(final RecipeType<?> recipeType) {
        return new IRecipeCatalystLookup(){
            private boolean includeHidden;

            @Override
            public IRecipeCatalystLookup includeHidden() {
                this.includeHidden = true;
                return this;
            }

            @Override
            public Stream<ITypedIngredient<?>> get() {
                return RecipeManager.this.getRecipeCatalystStream(recipeType, this.includeHidden);
            }

            public <V> Stream<V> get(IIngredientType<V> ingredientType) {
                return this.get().map(i -> i.getIngredient(ingredientType)).flatMap(Optional::stream);
            }
        };
    }

    @Override
    public <T> void addRecipes(RecipeType<T> jeiRecipeType, List<T> jeiRecipes) {
        if (this.locked) {
            throw new IllegalStateException("Tried to add recipes after registry is locked");
        }
        Category<T> category = this.category(jeiRecipeType);
        for (T jeiRecipe : jeiRecipes) {
            this.addRecipe(category, jeiRecipe);
        }
    }

    private <T> void collectRecipes(RecipeType<T> recipeType, Collection<T> jeiRecipes, Consumer<ResourceLocation> idConsumer) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        Category<T> category = this.category(recipeType);
        List<Category.Recipe> recipes = jeiRecipes.stream().map(category::recipe).toList();
        recipes.stream().map(Category.Recipe::getID).filter(Objects::nonNull).forEach(idConsumer);
    }

    @Override
    public <T> void hideRecipes(RecipeType<T> recipeType, Collection<T> jeiRecipes) {
        this.collectRecipes(recipeType, jeiRecipes, this.hiddenRecipeIDs::add);
    }

    @Override
    public <T> void unhideRecipes(RecipeType<T> recipeType, Collection<T> jeiRecipes) {
        this.collectRecipes(recipeType, jeiRecipes, this.hiddenRecipeIDs::remove);
    }

    @Override
    public void hideRecipeCategory(RecipeType<?> recipeType) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.hiddenCategories.add(this.category(recipeType).getEMICategory());
    }

    @Override
    public void unhideRecipeCategory(RecipeType<?> recipeType) {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.hiddenCategories.remove(this.category(recipeType).getEMICategory());
    }

    @Override
    public <T> Optional<IRecipeLayoutDrawable<T>> createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipe, IFocusGroup focusGroup) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(focusGroup, "focusGroup");
        RecipeType<T> recipeType = recipeCategory.getRecipeType();
        List<IRecipeCategoryDecorator<T>> decorators = this.getRecipeCategoryDecorators(recipeType);
        return RecipeLayout.create(recipeCategory, decorators, recipe, focusGroup, this.ingredientManager);
    }

    @Override
    public <T> Optional<IRecipeLayoutDrawable<T>> createRecipeLayoutDrawable(IRecipeCategory<T> recipeCategory, T recipe, IFocusGroup focusGroup, IScalableDrawable background, int borderSize) {
        ErrorUtil.checkNotNull(recipeCategory, "recipeCategory");
        ErrorUtil.checkNotNull(recipe, "recipe");
        ErrorUtil.checkNotNull(focusGroup, "focusGroup");
        ErrorUtil.checkNotNull(background, "background");
        RecipeType<T> recipeType = recipeCategory.getRecipeType();
        List<IRecipeCategoryDecorator<T>> decorators = this.getRecipeCategoryDecorators(recipeType);
        return RecipeLayout.create(recipeCategory, decorators, recipe, focusGroup, this.ingredientManager, background, borderSize);
    }

    @Override
    public IRecipeSlotDrawable createRecipeSlotDrawable(RecipeIngredientRole role, List<Optional<ITypedIngredient<?>>> ingredients, Set<Integer> focusedIngredients, int ingredientCycleOffset) {
        RecipeSlotBuilder builder = new RecipeSlotBuilder(this.ingredientManager, 0, role);
        builder.addOptionalTypedIngredients((List)ingredients);
        CycleTimer cycleTimer = CycleTimer.create(ingredientCycleOffset);
        Pair<Integer, IRecipeSlotDrawable> result = builder.build(focusedIngredients, (ICycler)cycleTimer);
        return result.second();
    }

    @Override
    public <T> Optional<RecipeType<T>> getRecipeType(ResourceLocation recipeUid, Class<? extends T> recipeClass) {
        Optional<RecipeType<?>> recipeType = this.getRecipeType(recipeUid);
        if (recipeType.isEmpty() || recipeType.get().getRecipeClass() != recipeClass) {
            return Optional.empty();
        }
        return Optional.of(recipeType.get());
    }

    @Override
    public Optional<RecipeType<?>> getRecipeType(ResourceLocation recipeUid) {
        EmiRecipe emiRecipe = EmiApi.getRecipeManager().getRecipe(recipeUid);
        if (emiRecipe == null) {
            return Optional.empty();
        }
        EmiRecipeCategory emiCategory = emiRecipe.getCategory();
        Category category = this.category(emiCategory);
        return Optional.ofNullable(category.getJEIRecipeType());
    }

    private <T> void addRecipe(Category<T> category, T jeiRecipe) {
        if (this.runtime.ignoredRecipes.contains(jeiRecipe)) {
            return;
        }
        IRecipeCategory<T> jeiCategory = category.getJEICategory();
        RecipeType<T> jeiRecipeType = Objects.requireNonNull(jeiCategory).getRecipeType();
        if (!jeiCategory.isHandled(jeiRecipe)) {
            if (TooManyRecipeViewersMod.LOGGER.isDebugEnabled()) {
                String recipeInfo = RecipeErrorUtil.getInfoFromRecipe(jeiRecipe, jeiCategory, this.ingredientManager);
                TooManyRecipeViewersMod.LOGGER.debug("Recipe not added because the recipe category cannot handle it: {}", (Object)recipeInfo);
            }
            return;
        }
        try {
            Category.Recipe recipe = category.recipe(jeiRecipe);
            EmiRecipe emiRecipe = Objects.requireNonNull(recipe.getEMIRecipe());
            this.registry.addRecipe(emiRecipe);
            if (vanillaJEITypeEMICategoryMap.containsKey(jeiRecipeType) && recipe.getOriginalID() != null) {
                if (emiRecipe instanceof TMRVRecipe) {
                    TooManyRecipeViewersMod.LOGGER.warn("Recipe replacement for {} will not render properly!", (Object)recipe.getOriginalID());
                }
                this.replacementRecipes.add(emiRecipe);
                this.replacedRecipeIDs.add(recipe.getOriginalID());
            }
        }
        catch (LinkageError | RuntimeException e) {
            String recipeInfo = RecipeErrorUtil.getInfoFromRecipe(jeiRecipe, jeiCategory, this.ingredientManager);
            TooManyRecipeViewersMod.LOGGER.error("Found a broken recipe, failed to addRecipe: {}\n", (Object)recipeInfo, (Object)e);
        }
    }

    private <T> @Unmodifiable List<IRecipeCategoryDecorator<T>> getRecipeCategoryDecorators(RecipeType<T> recipeType) {
        ImmutableList decorators = this.recipeCategoryDecorators.get(recipeType);
        return (List)decorators;
    }

    private Stream<IRecipeCategory<?>> getRecipeCategoriesForTypes(Collection<RecipeType<?>> recipeTypes, IFocusGroup focuses, boolean includeHidden) {
        List<IRecipeCategory<?>> recipeCategories = recipeTypes.stream().map(this::category).map(Category::getJEICategory).filter(Objects::nonNull).map(x -> x).toList();
        return this.getRecipeCategoriesUncached(recipeCategories, focuses, includeHidden);
    }

    private Stream<IRecipeCategory<?>> getRecipeCategoriesUncached(Collection<IRecipeCategory<?>> recipeCategories, IFocusGroup focuses, boolean includeHidden) {
        Stream<Object> categoryStream;
        if (focuses.isEmpty()) {
            categoryStream = recipeCategories.isEmpty() ? this.jeiRecipeCategories.stream() : recipeCategories.stream().distinct();
        } else {
            categoryStream = this.getRecipeTypes(focuses).map(x -> this.category((RecipeType)x).getJEICategory()).filter(Objects::nonNull).map(x -> x);
            if (!recipeCategories.isEmpty()) {
                categoryStream = categoryStream.filter(recipeCategories::contains);
            }
        }
        return categoryStream.sorted(ResourceLocationHolderComparator.create(x -> x.getRecipeType().getUid()));
    }

    private <T> Stream<T> getRecipesStream(RecipeType<T> recipeType, IFocusGroup focuses, boolean includeHidden) {
        return this.getRecipes(this.category(recipeType), focuses);
    }

    private <T> Stream<ITypedIngredient<?>> getRecipeCatalystStream(RecipeType<T> recipeType, boolean includeHidden) {
        Category<T> category = this.category(recipeType);
        EmiRecipeCategory emiCategory = category.getEMICategory();
        List workstations = EmiApi.getRecipeManager().getWorkstations(emiCategory);
        Stream<ITypedIngredient<?>> catalysts = workstations.stream().map(x -> this.ingredientManager.getTypedIngredient((EmiStack)J_U_List.getFirst(x.getEmiStacks()))).filter(Optional::isPresent).map(Optional::get).map(x -> x);
        if (includeHidden) {
            return catalysts;
        }
        return catalysts.filter(this.ingredientVisibility::isIngredientVisible);
    }

    public boolean isRecipeCatalyst(RecipeType<?> recipeType, IFocus<?> focus) {
        Category<?> category = this.category(recipeType);
        EmiRecipeCategory emiCategory = category.getEMICategory();
        EmiStack emiStack = this.ingredientManager.getEMIStack(focus.getTypedValue());
        EmiStack normalizedEMIStack = (EmiStack)J_U_List.getFirst(emiStack.getEmiStacks());
        return EmiApi.getRecipeManager().getWorkstations(emiCategory).contains(normalizedEMIStack);
    }

    public void addPlugins(List<IRecipeManagerPlugin> plugins) {
        if (this.locked) {
            throw new IllegalStateException("Tried to add plugins after registry is locked");
        }
        for (IRecipeManagerPlugin plugin : plugins) {
            int recipeCount = 0;
            for (IRecipeCategory<?> jeiCategory : this.jeiRecipeCategories) {
                List<?> recipes = plugin.getRecipes(jeiCategory);
                recipeCount += recipes.size();
                this.addRecipes(jeiCategory.getRecipeType(), recipes);
            }
            TooManyRecipeViewersMod.LOGGER.log(recipeCount > 0 ? Level.WARN : Level.ERROR, "Registered {} recipe(s) from Recipe Manager Plugin {}. Do not report issues if there are bugs with this feature; it is not supported!", (Object)recipeCount, (Object)plugin.getClass().getName());
        }
    }

    public void addDecorators(ImmutableListMultimap<RecipeType<?>, IRecipeCategoryDecorator<?>> decorators) {
        if (this.locked) {
            throw new IllegalStateException("Tried to add plugins after registry is locked");
        }
        this.recipeCategoryDecorators = decorators;
    }

    private List<EmiRecipe> getRecipes(IFocus<?> focus) {
        ITypedIngredient<?> jeiIngredient = focus.getTypedValue();
        EmiStack emiIngredient = this.ingredientManager.getEMIStack(jeiIngredient);
        EmiStack normalizedEMIStack = (EmiStack)J_U_List.getFirst(emiIngredient.getEmiStacks());
        return switch (focus.getRole()) {
            case RecipeIngredientRole.INPUT -> EmiApi.getRecipeManager().getRecipesByInput(normalizedEMIStack);
            case RecipeIngredientRole.OUTPUT -> EmiApi.getRecipeManager().getRecipesByOutput(normalizedEMIStack);
            case RecipeIngredientRole.CATALYST -> EmiRecipes.byWorkstation.getOrDefault(normalizedEMIStack, List.of());
            default -> List.of();
        };
    }

    private <V> Stream<RecipeType<?>> getRecipeTypes(IFocus<V> focus) {
        return this.getRecipes(focus).stream().map(EmiRecipe::getCategory).distinct().map(this::category).map(Category::getJEIRecipeType).filter(Objects::nonNull).map(x -> x);
    }

    private Stream<RecipeType<?>> getRecipeTypes(IFocusGroup focusGroup) {
        return focusGroup.getAllFocuses().stream().flatMap(this::getRecipeTypes).distinct();
    }

    private <T, V> Stream<T> getRecipes(Category<T> category, IFocus<V> focus) {
        EmiRecipeCategory emiCategory = category.getEMICategory();
        return this.getRecipes(focus).stream().filter(x -> x.getCategory() == emiCategory).map(x -> category.recipe(x).getJEIRecipe()).filter(Objects::nonNull);
    }

    private <T> Stream<T> getRecipes(Category<T> category, IFocusGroup focusGroup) {
        return focusGroup.getAllFocuses().stream().flatMap(x -> this.getRecipes(category, (IFocus)x)).distinct();
    }

    public Stream<RecipeType<?>> getAllRecipeTypes() {
        return this.jeiRecipeCategories.stream().map(IRecipeCategory::getRecipeType);
    }

    @Override
    public synchronized void lock() throws IllegalStateException {
        if (this.locked) {
            throw new IllegalStateException();
        }
        this.locked = true;
        EmiReloadManager.step((Component)Component.m_237113_((String)"[TMRV] Locking JEI Recipe Registry..."), (long)100L);
        this.registry.removeRecipes(x -> this.replacedRecipeIDs.contains(x.getId()) && !this.replacementRecipes.contains(x) || this.hiddenRecipeIDs.contains(x.getId()) || this.hiddenCategories.contains(x.getCategory()));
        this.replacedRecipeIDs.clear();
        this.replacementRecipes.clear();
        this.hiddenRecipeIDs.clear();
        this.hiddenCategories.clear();
        this.runtime.ignoredRecipes.clear();
    }

    public <T> Category<T> category(@Nullable IRecipeCategory<T> jeiCategory, @Nullable RecipeType<T> jeiRecipeType, @Nullable EmiRecipeCategory emiCategory) {
        if (jeiCategory == null && jeiRecipeType == null && emiCategory == null) {
            throw new IllegalArgumentException();
        }
        if (jeiCategory != null && jeiRecipeType == null) {
            jeiRecipeType = jeiCategory.getRecipeType();
        }
        Category<Object> result = jeiRecipeType != null && this.jeiRecipeTypeMap.containsKey(jeiRecipeType) ? this.jeiRecipeTypeMap.get(jeiRecipeType) : (emiCategory != null && this.emiCategoryMap.containsKey(emiCategory) ? this.emiCategoryMap.get(emiCategory) : new Category());
        if (result.jeiCategory == null && jeiCategory != null) {
            result.jeiCategory = jeiCategory;
        }
        if (result.jeiRecipeType == null && jeiRecipeType != null) {
            result.jeiRecipeType = jeiRecipeType;
        }
        if (result.emiCategory == null && emiCategory != null) {
            result.emiCategory = emiCategory;
        }
        if (jeiRecipeType != null && !this.jeiRecipeTypeMap.containsKey(jeiRecipeType)) {
            this.jeiRecipeTypeMap.put(jeiRecipeType, result);
        }
        if (emiCategory != null && !this.emiCategoryMap.containsKey(emiCategory)) {
            this.emiCategoryMap.put(emiCategory, result);
        }
        return result;
    }

    public <T> Category<T> category(@NotNull IRecipeCategory<T> jeiCategory) {
        return this.category(jeiCategory, null, null);
    }

    public <T> Category<T> category(@NotNull RecipeType<T> jeiRecipeType) {
        return this.category(null, jeiRecipeType, null);
    }

    public <T> Category<T> category(@NotNull EmiRecipeCategory emiCategory) {
        return this.category(null, null, emiCategory);
    }

    static {
        ImmutableMap.Builder vanillaEMICategoryJEIRecipeClassMapBuilder = ImmutableMap.builder();
        vanillaJEITypeEMICategoryMap.forEach((k, v) -> vanillaEMICategoryJEIRecipeClassMapBuilder.put(v, k));
        vanillaEMICategoryJEIRecipeTypeMap = vanillaEMICategoryJEIRecipeClassMapBuilder.build();
    }

    public class Category<T> {
        @Nullable
        private IRecipeCategory<T> jeiCategory;
        @Nullable
        private RecipeType<T> jeiRecipeType;
        @Nullable
        private EmiRecipeCategory emiCategory;
        private final Map<T, Recipe> jeiRecipeMap = Collections.synchronizedMap(new HashMap());
        private final Map<EmiRecipe, Recipe> emiRecipeMap = Collections.synchronizedMap(new HashMap());

        private Category() {
        }

        @Nullable
        public synchronized IRecipeCategory<T> getJEICategory() {
            if (this.jeiCategory == null) {
                if (this.jeiRecipeType != null || this.emiCategory == null) {
                    throw new IllegalStateException();
                }
                return null;
            }
            return this.jeiCategory;
        }

        @Nullable
        public synchronized RecipeType<T> getJEIRecipeType() {
            if (this.jeiRecipeType == null) {
                if (this.jeiCategory != null) {
                    this.jeiRecipeType = this.jeiCategory.getRecipeType();
                    RecipeManager.this.jeiRecipeTypeMap.put(this.jeiRecipeType, this);
                } else {
                    if (this.emiCategory == null) {
                        throw new IllegalStateException();
                    }
                    return null;
                }
            }
            return this.jeiRecipeType;
        }

        @Nullable
        public synchronized EmiRecipeCategory getEMICategory() {
            if (this.emiCategory == null) {
                if (this.jeiCategory == null || this.jeiRecipeType == null) {
                    return null;
                }
                this.emiCategory = vanillaJEITypeEMICategoryMap.containsKey(this.jeiRecipeType) ? vanillaJEITypeEMICategoryMap.get(this.jeiRecipeType) : new JemiCategory(this.jeiCategory);
                RecipeManager.this.emiCategoryMap.put(this.emiCategory, this);
            }
            return Objects.requireNonNull(this.emiCategory);
        }

        public Recipe recipe(@Nullable T jeiRecipe, @Nullable EmiRecipe emiRecipe) {
            if (jeiRecipe == null && emiRecipe == null) {
                throw new IllegalArgumentException();
            }
            Recipe result = jeiRecipe != null && this.jeiRecipeMap.containsKey(jeiRecipe) ? this.jeiRecipeMap.get(jeiRecipe) : (emiRecipe != null && this.emiRecipeMap.containsKey(emiRecipe) ? this.emiRecipeMap.get(emiRecipe) : new Recipe());
            if (result.jeiRecipe == null && jeiRecipe != null) {
                result.jeiRecipe = jeiRecipe;
            }
            if (result.emiRecipe == null && emiRecipe != null) {
                result.emiRecipe = emiRecipe;
            }
            if (jeiRecipe != null) {
                this.jeiRecipeMap.put(jeiRecipe, result);
            }
            if (emiRecipe != null) {
                this.emiRecipeMap.put(emiRecipe, result);
            }
            return result;
        }

        public Recipe recipe(@Nullable Object recipe) {
            if (recipe instanceof EmiRecipe) {
                return this.recipe(null, (EmiRecipe)recipe);
            }
            return this.recipe(recipe, null);
        }

        public class Recipe {
            @Nullable
            private T jeiRecipe;
            @Nullable
            private EmiRecipe emiRecipe;
            @Nullable
            private ResourceLocation originalID = null;
            @Nullable
            private ResourceLocation id = null;

            private Recipe() {
            }

            private ExtractedRecipeData extractJEIRecipeData() {
                IRecipeCategory jeiCategory;
                if (this.jeiRecipe == null) {
                    throw new IllegalStateException();
                }
                Object t = this.jeiRecipe;
                if (t instanceof CraftingRecipe) {
                    CraftingRecipe craftingRecipe = (CraftingRecipe)t;
                    if (craftingRecipe instanceof ShapelessRecipe) {
                        ShapelessRecipe shapelessRecipe = (ShapelessRecipe)craftingRecipe;
                        return new ExtractedRecipeData(shapelessRecipe.m_7527_().stream().map(EmiIngredient::of).toList(), List.of(RecipeManager.this.runtime.ingredientManager.getEMIStack(EmiPort.getOutput((net.minecraft.world.item.crafting.Recipe)shapelessRecipe))), true);
                    }
                    if (craftingRecipe instanceof ShapedRecipe) {
                        ShapedRecipe shapedRecipe = (ShapedRecipe)craftingRecipe;
                        return new ExtractedRecipeData(shapedRecipe.m_7527_().stream().map(EmiIngredient::of).toList(), List.of(RecipeManager.this.runtime.ingredientManager.getEMIStack(EmiPort.getOutput((net.minecraft.world.item.crafting.Recipe)shapedRecipe))), false);
                    }
                }
                if ((jeiCategory = Category.this.getJEICategory()) == null) {
                    throw new IllegalStateException();
                }
                RecipeLayoutBuilder recipeLayoutBuilder = new RecipeLayoutBuilder(RecipeManager.this.ingredientManager);
                jeiCategory.setRecipe(recipeLayoutBuilder, this.jeiRecipe, RecipeManager.this.runtime.jeiHelpers.getFocusFactory().getEmptyFocusGroup());
                RecipeLayoutBuilder.ExtractedEMIRecipeData data = recipeLayoutBuilder.extractEMIRecipeData();
                return new ExtractedRecipeData(data.inputs(), data.outputs(), data.shapeless());
            }

            @Nullable
            public synchronized ResourceLocation getOriginalID() {
                if (this.originalID == null && this.jeiRecipe != null && Category.this.getJEICategory() != null) {
                    this.originalID = Category.this.getJEICategory().getRegistryName(this.jeiRecipe);
                }
                return this.originalID;
            }

            @Nullable
            public synchronized ResourceLocation getID() {
                if (this.id == null) {
                    if (this.emiRecipe != null) {
                        this.id = this.emiRecipe.getId();
                    }
                    if (this.id == null && this.getOriginalID() != null) {
                        this.id = ResourceLocation.fromNamespaceAndPath((String)"toomanyrecipeviewers", (String)("/" + EmiUtil.subId((ResourceLocation)this.getOriginalID())));
                    }
                }
                return this.id;
            }

            @Nullable
            public synchronized T getJEIRecipe() {
                if (this.jeiRecipe == null) {
                    if (this.emiRecipe == null) {
                        throw new IllegalStateException();
                    }
                    return null;
                }
                return this.jeiRecipe;
            }

            @Nullable
            public synchronized EmiRecipe getEMIRecipe() {
                if (this.emiRecipe == null) {
                    if (this.jeiRecipe == null) {
                        return null;
                    }
                    this.getOriginalID();
                    this.getID();
                    if (vanillaJEITypeEMICategoryMap.containsKey(Category.this.jeiRecipeType)) {
                        if (Category.this.emiCategory == VanillaEmiRecipeCategories.INFO) {
                            this.emiRecipe = this.convertEMIInfoRecipe();
                        } else if (Category.this.emiCategory == VanillaEmiRecipeCategories.CRAFTING) {
                            this.emiRecipe = this.convertEMICraftingRecipe();
                        } else if (Category.this.emiCategory == VanillaEmiRecipeCategories.SMELTING) {
                            this.emiRecipe = this.convertEMISmeltingRecipe();
                        } else if (Category.this.emiCategory == VanillaEmiRecipeCategories.BLASTING) {
                            this.emiRecipe = this.convertEMIBlastingRecipe();
                        } else if (Category.this.emiCategory == VanillaEmiRecipeCategories.SMOKING) {
                            this.emiRecipe = this.convertEMISmokingRecipe();
                        } else if (Category.this.emiCategory == VanillaEmiRecipeCategories.CAMPFIRE_COOKING) {
                            this.emiRecipe = this.convertEMICampfireRecipe();
                        } else if (Category.this.emiCategory == VanillaEmiRecipeCategories.STONECUTTING) {
                            this.emiRecipe = this.convertEMIStonecuttingRecipe();
                        } else if (Category.this.emiCategory == VanillaEmiRecipeCategories.SMITHING) {
                            this.emiRecipe = this.convertEMISmithingRecipe();
                        } else if (Category.this.emiCategory == VanillaEmiRecipeCategories.ANVIL_REPAIRING) {
                            this.emiRecipe = this.convertEMIAnvilRecipe();
                        } else if (Category.this.emiCategory == VanillaEmiRecipeCategories.BREWING) {
                            this.emiRecipe = this.convertEMIBrewingRecipe();
                        } else if (Category.this.emiCategory == VanillaEmiRecipeCategories.FUEL) {
                            this.emiRecipe = this.convertEMIFuelRecipe();
                        } else if (Category.this.emiCategory == VanillaEmiRecipeCategories.COMPOSTING) {
                            this.emiRecipe = this.convertEMICompostingRecipe();
                        }
                    }
                    if (this.emiRecipe == null) {
                        this.emiRecipe = new TMRVRecipe(RecipeManager.this.runtime, Category.this, this.jeiRecipe, this.getID());
                    }
                    Category.this.emiRecipeMap.put(this.emiRecipe, this);
                }
                return this.emiRecipe;
            }

            @NotNull
            private EmiInfoRecipe convertEMIInfoRecipe() {
                IJeiIngredientInfoRecipe jeiRecipe = (IJeiIngredientInfoRecipe)this.jeiRecipe;
                List<EmiIngredient> emiIngredients = jeiRecipe.getIngredients().stream().map(RecipeManager.this.ingredientManager::getEMIStack).map(EmiIngredient.class::cast).toList();
                List<Component> lines = jeiRecipe.getDescription().stream().map(formattedText -> {
                    if (formattedText instanceof Component) {
                        Component component = (Component)formattedText;
                        return component;
                    }
                    MutableComponent result = Component.m_237113_((String)"");
                    formattedText.m_7451_((style, string) -> {
                        result.m_7220_((Component)Component.m_237113_((String)string).m_130948_(style));
                        return Optional.empty();
                    }, Style.f_131099_);
                    return result;
                }).toList();
                return new EmiInfoRecipe(emiIngredients, lines, null);
            }

            @NotNull
            private EmiCraftingRecipe convertEMICraftingRecipe() {
                final ResourceLocation recipeID = this.getID();
                CraftingRecipe craftingRecipe = (CraftingRecipe)this.jeiRecipe;
                if (craftingRecipe.m_8004_(3, 3)) {
                    if (craftingRecipe instanceof ShapelessRecipe) {
                        ShapelessRecipe shapelessRecipe = (ShapelessRecipe)craftingRecipe;
                        return new EmiShapelessRecipe(this, shapelessRecipe){

                            public ResourceLocation getId() {
                                return recipeID;
                            }
                        };
                    }
                    if (craftingRecipe instanceof ShapedRecipe) {
                        ShapedRecipe shapedRecipe = (ShapedRecipe)craftingRecipe;
                        return new EmiShapedRecipe(this, shapedRecipe){

                            public ResourceLocation getId() {
                                return recipeID;
                            }
                        };
                    }
                }
                ExtractedRecipeData extractedRecipeData = this.extractJEIRecipeData();
                final List<EmiIngredient> emiInputs = extractedRecipeData.emiInputs;
                final List<EmiStack> emiOutputs = extractedRecipeData.emiOutputs;
                if (emiOutputs.size() == 1) {
                    return new EmiCraftingRecipe(emiInputs, J_U_List.getFirst(emiOutputs), recipeID, extractedRecipeData.shapeless);
                }
                return new EmiPatternCraftingRecipe(this, emiInputs, ErrorEmiStack.INSTANCE, recipeID, extractedRecipeData.shapeless){

                    public List<EmiStack> getOutputs() {
                        return emiOutputs;
                    }

                    public SlotWidget getInputWidget(int slot, int x, int y) {
                        return new SlotWidget((EmiIngredient)(slot <= emiInputs.size() ? (EmiIngredient)emiInputs.get(slot) : EmiStack.EMPTY), x, y);
                    }

                    public SlotWidget getOutputWidget(int x, int y) {
                        return new SlotWidget(EmiIngredient.of((List)emiOutputs), x, y);
                    }

                    public boolean supportsRecipeTree() {
                        return emiOutputs.size() == 1;
                    }
                };
            }

            @NotNull
            private EmiCookingRecipe convertEMISmeltingRecipe() {
                SmeltingRecipe recipe = (SmeltingRecipe)this.jeiRecipe;
                return new EMICookingRecipeWithCustomID((AbstractCookingRecipe)recipe, VanillaEmiRecipeCategories.SMELTING, 1, false, this.getID());
            }

            @NotNull
            private EmiCookingRecipe convertEMIBlastingRecipe() {
                BlastingRecipe recipe = (BlastingRecipe)this.jeiRecipe;
                return new EMICookingRecipeWithCustomID((AbstractCookingRecipe)recipe, VanillaEmiRecipeCategories.BLASTING, 2, false, this.getID());
            }

            @NotNull
            private EmiCookingRecipe convertEMISmokingRecipe() {
                SmokingRecipe recipe = (SmokingRecipe)this.jeiRecipe;
                return new EMICookingRecipeWithCustomID((AbstractCookingRecipe)recipe, VanillaEmiRecipeCategories.SMOKING, 2, false, this.getID());
            }

            @NotNull
            private EmiCookingRecipe convertEMICampfireRecipe() {
                CampfireCookingRecipe recipe = (CampfireCookingRecipe)this.jeiRecipe;
                return new EMICookingRecipeWithCustomID((AbstractCookingRecipe)recipe, VanillaEmiRecipeCategories.CAMPFIRE_COOKING, 1, true, this.getID());
            }

            @NotNull
            private EmiStonecuttingRecipe convertEMIStonecuttingRecipe() {
                StonecutterRecipe recipe = (StonecutterRecipe)this.jeiRecipe;
                return new EmiStonecuttingRecipe(recipe){

                    public ResourceLocation getId() {
                        return Recipe.this.getID();
                    }
                };
            }

            @NotNull
            private EmiRecipe convertEMISmithingRecipe() {
                SmithingRecipe recipe = (SmithingRecipe)this.jeiRecipe;
                ISmithingCategoryExtension extension = ((SmithingRecipeCategoryAccessor)((Object)RecipeManager.this.runtime.smithingCategory)).tmrv$getExtension(recipe);
                if (extension != null) {
                    return new ExtendedSmithingRecipe<SmithingRecipe>(RecipeManager.this.runtime, recipe, extension, this.getID());
                }
                ResourceLocation id = this.getID();
                TooManyRecipeViewersMod.LOGGER.warn("Using fallback smithing recipe extractor for recipe {}", (Object)id);
                ExtractedRecipeData extractedRecipeData = this.extractJEIRecipeData();
                List<EmiIngredient> emiInputs = extractedRecipeData.emiInputs;
                List<EmiStack> emiOutputs = extractedRecipeData.emiOutputs;
                return new EmiSmithingRecipe(emiInputs.get(0), emiInputs.get(1), emiInputs.get(2), J_U_List.getFirst(emiOutputs), this.getID());
            }

            @NotNull
            private EmiRecipe convertEMIAnvilRecipe() {
                IJeiAnvilRecipe jeiRecipe = (IJeiAnvilRecipe)this.jeiRecipe;
                final ResourceLocation id = this.getID();
                final List<EmiStack> leftInputs = jeiRecipe.getLeftInputs().stream().map(RecipeManager.this.ingredientManager::getEMIStack).toList();
                final List<EmiStack> rightInputs = jeiRecipe.getRightInputs().stream().map(RecipeManager.this.ingredientManager::getEMIStack).toList();
                final List<EmiStack> outputs = jeiRecipe.getOutputs().stream().map(RecipeManager.this.ingredientManager::getEMIStack).toList();
                return new EmiRecipe(){
                    private final int unique = EmiUtil.RANDOM.nextInt();

                    public EmiRecipeCategory getCategory() {
                        return VanillaEmiRecipeCategories.ANVIL_REPAIRING;
                    }

                    @Nullable
                    public ResourceLocation getId() {
                        return id;
                    }

                    public List<EmiIngredient> getInputs() {
                        return Stream.concat(leftInputs.stream().map(EmiIngredient.class::cast), rightInputs.stream()).toList();
                    }

                    public List<EmiStack> getOutputs() {
                        return outputs;
                    }

                    public boolean supportsRecipeTree() {
                        return false;
                    }

                    public int getDisplayWidth() {
                        return 125;
                    }

                    public int getDisplayHeight() {
                        return 18;
                    }

                    public void addWidgets(WidgetHolder widgets) {
                        widgets.addTexture(EmiTexture.PLUS, 27, 3);
                        widgets.addTexture(EmiTexture.EMPTY_ARROW, 75, 1);
                        widgets.addSlot(EmiIngredient.of((List)leftInputs), 0, 0);
                        widgets.addSlot(EmiIngredient.of((List)rightInputs), 49, 0);
                        widgets.addSlot(EmiIngredient.of((List)outputs), 107, 0).recipeContext((EmiRecipe)this);
                    }
                };
            }

            @NotNull
            private EmiBrewingRecipe convertEMIBrewingRecipe() {
                IJeiBrewingRecipe jeiRecipe = (IJeiBrewingRecipe)this.jeiRecipe;
                return new EmiBrewingRecipe(RecipeManager.this.ingredientManager.getEMIStack(J_U_List.getFirst(jeiRecipe.getPotionInputs())), RecipeManager.this.ingredientManager.getEMIIngredient(jeiRecipe.getIngredients().stream()), RecipeManager.this.ingredientManager.getEMIStack(jeiRecipe.getPotionOutput()), this.getID());
            }

            @NotNull
            private EmiFuelRecipe convertEMIFuelRecipe() {
                IJeiFuelingRecipe jeiRecipe = (IJeiFuelingRecipe)this.jeiRecipe;
                return new EmiFuelRecipe(RecipeManager.this.ingredientManager.getEMIIngredient(jeiRecipe.getInputs().stream()), jeiRecipe.getBurnTime(), this.getID());
            }

            @NotNull
            private EmiCompostingRecipe convertEMICompostingRecipe() {
                IJeiCompostingRecipe jeiRecipe = (IJeiCompostingRecipe)this.jeiRecipe;
                return new EmiCompostingRecipe(RecipeManager.this.ingredientManager.getEMIIngredient(jeiRecipe.getInputs().stream()), jeiRecipe.getChance(), this.getID());
            }

            private record ExtractedRecipeData(List<EmiIngredient> emiInputs, List<EmiStack> emiOutputs, boolean shapeless) {
            }

            private static class EMICookingRecipeWithCustomID
            extends EmiCookingRecipe {
                private final ResourceLocation id;

                public EMICookingRecipeWithCustomID(AbstractCookingRecipe recipe, EmiRecipeCategory category, int fuelMultiplier, boolean infiniBurn, ResourceLocation id) {
                    super(recipe, category, fuelMultiplier, infiniBurn);
                    this.id = id;
                }

                public ResourceLocation getId() {
                    return this.id;
                }
            }
        }
    }
}

