/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.network;

import java.util.List;
import javax.annotation.Nonnull;
import mcjty.lib.McJtyLib;
import mcjty.lib.blockcommands.CommandInfo;
import mcjty.lib.network.CustomPacketPayload;
import mcjty.lib.network.Networking;
import mcjty.lib.network.PacketSendResultToClient;
import mcjty.lib.network.PlayPayloadContext;
import mcjty.lib.network.TypedMapTools;
import mcjty.lib.tileentity.GenericTileEntity;
import mcjty.lib.typed.TypedMap;
import mcjty.lib.varia.LevelTools;
import mcjty.lib.varia.Logging;
import mcjty.lib.varia.SafeClientTools;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public record PacketGetListFromServer(ResourceKey<Level> dimension, BlockPos pos, String command, TypedMap params) implements CustomPacketPayload
{
    public static final ResourceLocation ID = new ResourceLocation("mcjtylib", "getlistfromserver");

    public static PacketGetListFromServer create(FriendlyByteBuf buf) {
        ResourceKey<Level> dimension = LevelTools.getId(buf.m_130281_());
        BlockPos pos = buf.m_130135_();
        String command = buf.m_130136_(Short.MAX_VALUE);
        TypedMap params = TypedMapTools.readArguments(buf);
        return new PacketGetListFromServer(dimension, pos, command, params);
    }

    @Override
    public void write(FriendlyByteBuf buf) {
        buf.m_130085_(this.dimension.m_135782_());
        buf.m_130064_(this.pos);
        buf.m_130070_(this.command);
        TypedMapTools.writeArguments(buf, this.params);
    }

    @Override
    public ResourceLocation id() {
        return ID;
    }

    public static PacketGetListFromServer create(BlockPos pos, String cmd, @Nonnull TypedMap params) {
        ResourceKey dimension = SafeClientTools.getWorld().m_46472_();
        return new PacketGetListFromServer((ResourceKey<Level>)dimension, pos, cmd, params);
    }

    public static PacketGetListFromServer create(BlockPos pos, String cmd) {
        ResourceKey dimension = SafeClientTools.getWorld().m_46472_();
        return new PacketGetListFromServer((ResourceKey<Level>)dimension, pos, cmd, TypedMap.EMPTY);
    }

    public void handle(PlayPayloadContext ctx) {
        ctx.workHandler().submitAsync(() -> ctx.player().ifPresent(player -> {
            ServerLevel world = LevelTools.getLevel(player.m_20193_(), this.dimension);
            if (world.m_46805_(this.pos)) {
                BlockEntity te = world.m_7702_(this.pos);
                if (te instanceof GenericTileEntity) {
                    GenericTileEntity generic = (GenericTileEntity)te;
                    CommandInfo info = McJtyLib.getCommandInfo(this.command);
                    if (info == null) {
                        throw new IllegalStateException("Command '" + this.command + "' is not registered!");
                    }
                    Class type = info.type();
                    List list = generic.executeServerCommandList(this.command, (Player)player, this.params, type);
                    Networking.sendToPlayer(new PacketSendResultToClient(this.pos, this.command, list), player);
                } else {
                    Logging.logError("Command '" + this.command + "' not handled!");
                }
            }
        }));
    }
}

