/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.client;

import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Math;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class HudRenderHelper {
    public static void renderHudItems(PoseStack matrixStack, MultiBufferSource buffer, List<Pair<ItemStack, String>> messages, HudPlacement hudPlacement, HudOrientation hudOrientation, Direction orientation, double x, double y, double z, float scale) {
        matrixStack.m_85836_();
        if (hudPlacement == HudPlacement.HUD_FRONT) {
            matrixStack.m_252880_((float)x + 0.5f, (float)y + 0.75f, (float)z + 0.5f);
        } else if (hudPlacement == HudPlacement.HUD_CENTER) {
            matrixStack.m_252880_((float)x + 0.5f, (float)y + 0.5f, (float)z + 0.5f);
        } else {
            matrixStack.m_252880_((float)x + 0.5f, (float)y + 1.75f, (float)z + 0.5f);
        }
        Quaternionf quaternion = Minecraft.m_91087_().m_91290_().m_253208_();
        switch (hudOrientation) {
            case HUD_SOUTH: {
                matrixStack.m_252781_(new Quaternionf().setAngleAxis(-HudRenderHelper.getHudAngle(orientation), 0.0f, 1.0f, 0.0f));
                break;
            }
            case HUD_TOPLAYER_HORIZ: {
                matrixStack.m_252781_(quaternion);
                matrixStack.m_252781_(HudRenderHelper.fromXYZ(0.0f, 3.14159f, 0.0f));
                break;
            }
            case HUD_TOPLAYER: {
                matrixStack.m_252781_(quaternion);
                matrixStack.m_252781_(HudRenderHelper.fromXYZ(0.0f, 3.14159f, 0.0f));
            }
        }
        if (hudPlacement == HudPlacement.HUD_FRONT || hudPlacement == HudPlacement.HUD_ABOVE_FRONT) {
            matrixStack.m_252880_(0.0f, -0.25f, 0.46249998f);
        } else if (hudPlacement != HudPlacement.HUD_CENTER) {
            matrixStack.m_252880_(0.0f, -0.25f, -0.037499994f);
        }
        HudRenderHelper.renderText(matrixStack, buffer, Minecraft.m_91087_().f_91062_, messages, 11, scale);
        matrixStack.m_85849_();
    }

    private static Quaternionf fromXYZ(float pX, float pY, float pZ) {
        Quaternionf quaternion = new Quaternionf(0.0f, 0.0f, 0.0f, 1.0f);
        quaternion.mul((Quaternionfc)new Quaternionf((float)Math.sin((double)(pX / 2.0f)), 0.0f, 0.0f, (float)Math.cos((double)(pX / 2.0f))));
        quaternion.mul((Quaternionfc)new Quaternionf(0.0f, (float)Math.sin((double)(pY / 2.0f)), 0.0f, (float)Math.cos((double)(pY / 2.0f))));
        quaternion.mul((Quaternionfc)new Quaternionf(0.0f, 0.0f, (float)Math.sin((double)(pZ / 2.0f)), (float)Math.cos((double)(pZ / 2.0f))));
        return quaternion;
    }

    public static void renderHud(PoseStack stack, MultiBufferSource buffer, List<String> messages, HudPlacement hudPlacement, HudOrientation hudOrientation, Direction orientation, double x, double y, double z, float scale) {
        HudRenderHelper.renderHudItems(stack, buffer, messages.stream().map(s -> Pair.of((Object)ItemStack.f_41583_, (Object)s)).collect(Collectors.toList()), hudPlacement, hudOrientation, orientation, x, y, z, scale);
    }

    private static float getHudAngle(Direction orientation) {
        float f3 = 0.0f;
        if (orientation != null) {
            f3 = switch (orientation) {
                case Direction.NORTH -> (float)java.lang.Math.PI;
                case Direction.WEST -> 1.5707964f;
                case Direction.EAST -> -1.5707964f;
                default -> 0.0f;
            };
        }
        return f3;
    }

    private static void renderText(PoseStack matrixStack, MultiBufferSource buffer, Font fontrenderer, List<Pair<ItemStack, String>> messages, int lines, float scale) {
        matrixStack.m_252880_(-0.5f, 0.5f, 0.07f);
        float f3 = 0.0075f;
        matrixStack.m_85841_(f3 * scale, -f3 * scale, f3);
        HudRenderHelper.renderLog(matrixStack, buffer, fontrenderer, messages, lines);
    }

    private static void renderLog(PoseStack matrixStack, MultiBufferSource buffer, Font fontrenderer, List<Pair<ItemStack, String>> messages, int lines) {
        int currenty = 7;
        int height = 10;
        int logsize = messages.size();
        int i = 0;
        for (Pair<ItemStack, String> pair : messages) {
            ItemStack stack = (ItemStack)pair.getLeft();
            String s = (String)pair.getRight();
            if (i >= logsize - lines && currenty + height <= 124) {
                String prefix = "";
                if (!stack.m_41619_()) {
                    matrixStack.m_85836_();
                    matrixStack.m_252880_(14.0f, (float)currenty + 4.0f, 0.0f);
                    matrixStack.m_85841_(10.0f, -10.0f, 16.0f);
                    ItemRenderer itemRender = Minecraft.m_91087_().m_91291_();
                    BakedModel ibakedmodel = itemRender.m_174264_(stack, (Level)Minecraft.m_91087_().f_91073_, null, 1);
                    itemRender.m_115143_(stack, ItemDisplayContext.GUI, false, matrixStack, buffer, 0xF000F0, OverlayTexture.f_118083_, ibakedmodel);
                    prefix = "    ";
                    matrixStack.m_85849_();
                }
                fontrenderer.m_271703_(fontrenderer.m_92834_(prefix + s, 115), 7.0f, (float)currenty, 0xFFFFFF, false, matrixStack.m_85850_().m_252922_(), buffer, Font.DisplayMode.NORMAL, 0, 0xF000F0);
                currenty += height;
            }
            ++i;
        }
    }

    public static enum HudPlacement {
        HUD_ABOVE,
        HUD_ABOVE_FRONT,
        HUD_FRONT,
        HUD_CENTER;

    }

    public static enum HudOrientation {
        HUD_SOUTH,
        HUD_TOPLAYER_HORIZ,
        HUD_TOPLAYER;

    }
}

