/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftoolsutility.modules.screen;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import mcjty.rftoolsbase.api.screens.IScreenModuleRegistry;
import mcjty.rftoolsbase.api.screens.data.IModuleDataFactory;
import mcjty.rftoolsutility.modules.screen.data.ModuleDataBoolean;
import mcjty.rftoolsutility.modules.screen.data.ModuleDataInteger;
import mcjty.rftoolsutility.modules.screen.data.ModuleDataString;
import mcjty.rftoolsutility.modules.screen.modules.ComputerScreenModule;
import mcjty.rftoolsutility.modules.screen.modules.ItemStackScreenModule;
import mcjty.rftoolsutility.modules.screen.modules.ScreenModuleHelper;

public class ScreenModuleRegistry
implements IScreenModuleRegistry {
    private Map<String, IModuleDataFactory<?>> dataFactoryMap = new HashMap();
    private Map<String, Integer> idToIntMap = null;
    private Map<Integer, String> inttoIdMap = null;

    public void registerBuiltins() {
        this.dataFactoryMap.put("rftoolsutility:bool", ModuleDataBoolean::new);
        this.dataFactoryMap.put("rftoolsutility:integer", ModuleDataInteger::new);
        this.dataFactoryMap.put("rftoolsutility:string", ModuleDataString::new);
        this.dataFactoryMap.put("rftoolsutility:contents", ScreenModuleHelper.ModuleDataContents::new);
        this.dataFactoryMap.put("rftoolsutility:itemStacks", ItemStackScreenModule.ModuleDataStacks::new);
        this.dataFactoryMap.put("rftoolsutility:computer", ComputerScreenModule.ModuleComputerInfo::new);
    }

    public void registerModuleDataFactory(String id, IModuleDataFactory<?> dataFactory) {
        this.dataFactoryMap.put(id, dataFactory);
    }

    public IModuleDataFactory<?> getModuleDataFactory(String id) {
        return this.dataFactoryMap.get(id);
    }

    public String getNormalId(int i) {
        this.createIdMap();
        return this.inttoIdMap.get(i);
    }

    public int getShortId(String id) {
        this.createIdMap();
        return this.idToIntMap.get(id);
    }

    private void createIdMap() {
        if (this.idToIntMap == null) {
            this.idToIntMap = new HashMap<String, Integer>();
            this.inttoIdMap = new HashMap<Integer, String>();
            ArrayList<String> strings = new ArrayList<String>(this.dataFactoryMap.keySet());
            strings.sort(Comparator.naturalOrder());
            int idx = 0;
            for (String s : strings) {
                this.idToIntMap.put(s, idx);
                this.inttoIdMap.put(idx, s);
                ++idx;
            }
        }
    }
}

