/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.inventory.container.ContainerCrafting;
import com.minecolonies.api.inventory.container.ContainerCraftingBrewingstand;
import com.minecolonies.api.inventory.container.ContainerCraftingFurnace;
import com.minecolonies.core.colony.buildings.modules.AbstractCraftingBuildingModule;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkHooks;
import org.jetbrains.annotations.NotNull;

public class OpenCraftingGUIMessage
extends AbstractBuildingServerMessage<IBuilding> {
    private int id;

    public OpenCraftingGUIMessage() {
    }

    public OpenCraftingGUIMessage(@NotNull AbstractBuildingView building, int id) {
        super(building);
        this.id = id;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.id = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeInt(this.id);
    }

    @Override
    protected void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, final IBuilding building) {
        ServerPlayer player = ctxIn.getSender();
        if (player == null) {
            return;
        }
        IBuildingModule iBuildingModule = building.getModule(this.id);
        if (iBuildingModule instanceof AbstractCraftingBuildingModule) {
            final AbstractCraftingBuildingModule module = (AbstractCraftingBuildingModule)iBuildingModule;
            if (module.canLearn((CraftingType)ModCraftingTypes.SMELTING.get())) {
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                    @NotNull
                    public Component m_5446_() {
                        return Component.m_237113_((String)"Furnace Crafting GUI");
                    }

                    @NotNull
                    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
                        return new ContainerCraftingFurnace(id, inv, building.getID(), module.getProducer().getRuntimeID());
                    }
                }, buffer -> new FriendlyByteBuf(buffer.m_130064_(building.getID()).writeInt(module.getProducer().getRuntimeID())));
            } else if (module.canLearn((CraftingType)ModCraftingTypes.BREWING.get())) {
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                    @NotNull
                    public Component m_5446_() {
                        return Component.m_237113_((String)"Brewing Crafting GUI");
                    }

                    @NotNull
                    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
                        return new ContainerCraftingBrewingstand(id, inv, building.getID(), module.getProducer().getRuntimeID());
                    }
                }, buffer -> new FriendlyByteBuf(buffer.m_130064_(building.getID()).writeInt(module.getProducer().getRuntimeID())));
            } else {
                NetworkHooks.openScreen((ServerPlayer)player, (MenuProvider)new MenuProvider(){

                    @NotNull
                    public Component m_5446_() {
                        return Component.m_237113_((String)"Crafting GUI");
                    }

                    @NotNull
                    public AbstractContainerMenu m_7208_(int id, @NotNull Inventory inv, @NotNull Player player) {
                        return new ContainerCrafting(id, inv, module.canLearn((CraftingType)ModCraftingTypes.LARGE_CRAFTING.get()), building.getID(), module.getProducer().getRuntimeID());
                    }
                }, buffer -> new FriendlyByteBuf(buffer.writeBoolean(module.canLearn((CraftingType)ModCraftingTypes.LARGE_CRAFTING.get()))).m_130064_(building.getID()).writeInt(module.getProducer().getRuntimeID()));
            }
        }
    }
}

