/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.server.colony.building;

import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.core.colony.buildings.AbstractBuilding;
import com.minecolonies.core.colony.buildings.modules.EntityListModule;
import com.minecolonies.core.network.messages.server.AbstractBuildingServerMessage;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;

public class AssignFilterableEntityMessage
extends AbstractBuildingServerMessage<AbstractBuilding> {
    private boolean assign;
    private ResourceLocation entity;
    private int id;

    public AssignFilterableEntityMessage() {
    }

    public AssignFilterableEntityMessage(IBuildingView building, int id, ResourceLocation entity, boolean assign) {
        super(building);
        this.assign = assign;
        this.entity = entity;
        this.id = id;
    }

    @Override
    public void fromBytesOverride(@NotNull FriendlyByteBuf buf) {
        this.assign = buf.readBoolean();
        this.entity = buf.m_130281_();
        this.id = buf.readInt();
    }

    @Override
    public void toBytesOverride(@NotNull FriendlyByteBuf buf) {
        buf.writeBoolean(this.assign);
        buf.m_130085_(this.entity);
        buf.writeInt(this.id);
    }

    @Override
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer, IColony colony, AbstractBuilding building) {
        IBuildingModule iBuildingModule = building.getModule(this.id);
        if (iBuildingModule instanceof EntityListModule) {
            EntityListModule module = (EntityListModule)iBuildingModule;
            if (this.assign) {
                module.addEntity(this.entity);
            } else {
                module.removeEntity(this.entity);
            }
        }
    }
}

