/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.network.messages.client.colony;

import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.network.IMessage;
import com.minecolonies.core.colony.Colony;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColonyViewMessage
implements IMessage {
    private int colonyId;
    private boolean isNewSubscription;
    private FriendlyByteBuf colonyBuffer;
    private ResourceKey<Level> dim;

    public ColonyViewMessage() {
    }

    public ColonyViewMessage(@NotNull Colony colony, FriendlyByteBuf buf, boolean newSubscription) {
        this.colonyId = colony.getID();
        this.dim = colony.getDimension();
        this.colonyBuffer = new FriendlyByteBuf(buf.copy());
        this.isNewSubscription = newSubscription;
    }

    @Override
    public void fromBytes(@NotNull FriendlyByteBuf buf) {
        FriendlyByteBuf newBuf = new FriendlyByteBuf(buf.retain());
        this.colonyId = newBuf.readInt();
        this.isNewSubscription = newBuf.readBoolean();
        this.dim = ResourceKey.m_135785_((ResourceKey)Registries.f_256858_, (ResourceLocation)new ResourceLocation(newBuf.m_130136_(Short.MAX_VALUE)));
        this.colonyBuffer = newBuf;
    }

    @Override
    public void toBytes(@NotNull FriendlyByteBuf buf) {
        this.colonyBuffer.resetReaderIndex();
        buf.writeInt(this.colonyId);
        buf.writeBoolean(this.isNewSubscription);
        buf.m_130070_(this.dim.m_135782_().toString());
        buf.writeBytes((ByteBuf)this.colonyBuffer);
    }

    @Override
    @Nullable
    public LogicalSide getExecutionSide() {
        return LogicalSide.CLIENT;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void onExecute(NetworkEvent.Context ctxIn, boolean isLogicalServer) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            IColonyManager.getInstance().handleColonyViewMessage(this.colonyId, this.colonyBuffer, (Level)Minecraft.m_91087_().f_91073_, this.isNewSubscription, this.dim);
        }
        this.colonyBuffer.release();
    }
}

