/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.other.cavalry;

import com.minecolonies.api.colony.IAnimalData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.IColonyView;
import com.minecolonies.api.colony.buildings.IBuilding;
import com.minecolonies.api.colony.managers.interfaces.IAnimalDataView;
import com.minecolonies.api.colony.managers.interfaces.IManagedAnimal;
import com.minecolonies.api.entity.ModEntities;
import com.minecolonies.api.util.CompatibilityUtils;
import com.minecolonies.api.util.DamageSourceKeys;
import com.minecolonies.api.util.Log;
import com.minecolonies.core.entity.citizen.EntityCitizen;
import com.minecolonies.core.entity.mobs.AnimalColonyHandler;
import com.minecolonies.core.entity.mobs.IAnimalColonyHandler;
import com.minecolonies.core.entity.pathfinding.navigation.AbstractAdvancedPathNavigate;
import com.minecolonies.core.entity.pathfinding.navigation.MinecoloniesAdvancedPathNavigate;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceKey;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.FollowParentGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.RandomStandGoal;
import net.minecraft.world.entity.ai.goal.WaterAvoidingRandomStrollGoal;
import net.minecraft.world.entity.ai.goal.WrappedGoal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.animal.horse.Donkey;
import net.minecraft.world.entity.animal.horse.Horse;
import net.minecraft.world.entity.animal.horse.Mule;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.entity.monster.Creeper;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;

public class CavalryHorseEntity
extends Horse
implements IManagedAnimal<CavalryHorseEntity> {
    public static final EntityDataAccessor<Integer> DATA_COLONY_ID = SynchedEntityData.m_135353_(CavalryHorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    public static final EntityDataAccessor<Integer> DATA_MANAGED_ANIMAL_ID = SynchedEntityData.m_135353_(CavalryHorseEntity.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final String RESERVE_KEY = "horse_reserved_for_cavalry";
    public static final float SLIM_W = 0.7f;
    public static final float BASE_H = 1.6f;
    private static final float SEATING_OFFSET = 0.4f;
    public static final int LOG_COOLDOWN_INTERVAL = 200;
    private int logCooldown = 0;
    public static final float COMBAT_READINESS_THRESHOLD = 0.66f;
    private IAnimalColonyHandler animalColonyHandler = null;
    IAnimalData animalData;
    private IAnimalDataView animalDataView;
    private static final int RESERVATION_EXPIRATION_LIMIT = 200;
    private int reservationExpiration = 0;
    private long lastHorizontalCollision = 0L;

    public CavalryHorseEntity(EntityType<? extends Horse> type, Level level) {
        super(type, level);
        this.m_274367_(1.1f);
        this.animalColonyHandler = new AnimalColonyHandler(this);
    }

    public void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(3, (Goal)new FollowParentGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(4, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(7, (Goal)new WaterAvoidingRandomStrollGoal((PathfinderMob)this, 0.7));
        this.f_21345_.m_25352_(8, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 6.0f));
        this.f_21345_.m_25352_(9, (Goal)new RandomLookAroundGoal((Mob)this));
        if (this.m_245259_()) {
            this.f_21345_.m_25352_(10, (Goal)new RandomStandGoal((AbstractHorse)this));
        }
    }

    public void m_7350_(EntityDataAccessor<?> dataAccessor) {
        super.m_7350_(dataAccessor);
        if (this.animalColonyHandler != null) {
            this.animalColonyHandler.onSyncedDataUpdated(dataAccessor);
        }
    }

    public void m_8107_() {
        super.m_8107_();
        int colonyId = this.getColonyId();
        if (colonyId == 0 && !CompatibilityUtils.getWorldFromEntity((Entity)this).f_46443_) {
            IColony colony = IColonyManager.getInstance().getClosestColony(this.f_19853_, this.m_20097_());
            if (colony == null) {
                return;
            }
            if (this.getAnimalData() == null) {
                this.animalData = colony.getAnimalManager().createAndRegisterAnimalData(this);
            }
            colonyId = colony.getID();
            this.setColonyId(colonyId);
        }
        if (CompatibilityUtils.getWorldFromEntity((Entity)this).f_46443_) {
            IColonyView colonyView;
            this.animalColonyHandler.updateColonyClient();
            if (this.animalColonyHandler.getColonyId() != 0 && this.getManagedAnimalId() != 0 && this.getOffsetTicks() % 20 == 0 && (colonyView = IColonyManager.getInstance().getColonyView(this.animalColonyHandler.getColonyId(), (ResourceKey<Level>)this.f_19853_.m_46472_())) != null) {
                this.animalDataView = colonyView.getAnimal(this.getManagedAnimalId());
            }
        } else {
            this.animalColonyHandler.registerWithColony(colonyId, this.getManagedAnimalId());
        }
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_COLONY_ID, (Object)0);
        this.f_19804_.m_135372_(DATA_MANAGED_ANIMAL_ID, (Object)0);
    }

    @Override
    public EntityDataAccessor<Integer> getColonyIdAccessor() {
        return DATA_COLONY_ID;
    }

    @Override
    public int getColonyId() {
        return (Integer)this.f_19804_.m_135370_(DATA_COLONY_ID);
    }

    @Override
    public void setColonyId(int colonyId) {
        this.f_19804_.m_135381_(DATA_COLONY_ID, (Object)colonyId);
        this.animalColonyHandler.setColonyId(colonyId);
    }

    @Override
    public EntityDataAccessor<Integer> getAnimalIdAccessor() {
        return DATA_MANAGED_ANIMAL_ID;
    }

    @Override
    public int getManagedAnimalId() {
        return (Integer)this.f_19804_.m_135370_(DATA_MANAGED_ANIMAL_ID);
    }

    @Override
    public void setManagedAnimalId(int managedAnimalId) {
        this.f_19804_.m_135381_(DATA_MANAGED_ANIMAL_ID, (Object)managedAnimalId);
    }

    public boolean hasCavalryRider() {
        EntityCitizen guard;
        if (this.m_20197_().isEmpty()) {
            return false;
        }
        Entity rider = this.m_146895_();
        if (!(rider instanceof EntityCitizen) || (guard = (EntityCitizen)rider).getCitizenJobHandler() == null) {
            return false;
        }
        return false;
    }

    public boolean hasTrainer() {
        Entity trainer = this.m_21524_();
        if (trainer == null) {
            return false;
        }
        return trainer instanceof EntityCitizen;
    }

    protected float m_6431_(@Nonnull Pose pose, @Nonnull EntityDimensions dims) {
        return super.m_6431_(pose, dims);
    }

    protected void m_20348_(@Nonnull Entity passenger) {
        EntityCitizen guard;
        AbstractAdvancedPathNavigate nav;
        super.m_20348_(passenger);
        this.m_21455_(true, false);
        if (passenger instanceof EntityCitizen && (nav = (guard = (EntityCitizen)passenger).getNavigation()) instanceof MinecoloniesAdvancedPathNavigate) {
            MinecoloniesAdvancedPathNavigate mcnav = (MinecoloniesAdvancedPathNavigate)nav;
            mcnav.getPathingOptions().setEnterDoors(false);
            mcnav.getPathingOptions().setCanOpenDoors(false);
        }
    }

    protected void m_20351_(@Nonnull Entity passenger) {
        EntityCitizen guard;
        AbstractAdvancedPathNavigate nav;
        super.m_20351_(passenger);
        if (passenger instanceof EntityCitizen && (nav = (guard = (EntityCitizen)passenger).getNavigation()) instanceof MinecoloniesAdvancedPathNavigate) {
            MinecoloniesAdvancedPathNavigate mcnav = (MinecoloniesAdvancedPathNavigate)nav;
            mcnav.getPathingOptions().setEnterDoors(true);
            mcnav.getPathingOptions().setCanOpenDoors(true);
        }
    }

    public void m_21463_(@Nonnull Entity entity, boolean sendPacket) {
        super.m_21463_(entity, sendPacket);
    }

    public void m_21455_(boolean broadcastPacket, boolean dropLeadItem) {
        super.m_21455_(broadcastPacket, dropLeadItem);
    }

    public double m_6048_() {
        double vanilla = super.m_6048_();
        double seatLowering = 0.4f;
        return vanilla - seatLowering;
    }

    protected PathNavigation m_6037_(@Nonnull Level level) {
        MinecoloniesAdvancedPathNavigate pathNavigation = new MinecoloniesAdvancedPathNavigate((Mob)this, level);
        pathNavigation.getPathingOptions().setEnterDoors(false);
        pathNavigation.getPathingOptions().setEnterGates(true);
        pathNavigation.getPathingOptions().setCanOpenDoors(false);
        pathNavigation.getPathingOptions().withDropCost(1.0);
        pathNavigation.getPathingOptions().withJumpCost(1.0);
        pathNavigation.getPathingOptions().setPassDanger(false);
        pathNavigation.getPathingOptions().setCanSwim(true);
        pathNavigation.m_7008_(true);
        return pathNavigation;
    }

    public boolean m_7848_(@Nonnull Animal other) {
        if (other == this) {
            return false;
        }
        if (!(other instanceof AbstractHorse)) {
            return false;
        }
        if (this.m_6162_() || other.m_6162_()) {
            return false;
        }
        if (other instanceof Mule) {
            return false;
        }
        return this instanceof Horse && (other instanceof Horse || other instanceof Donkey);
    }

    public void m_8119_() {
        super.m_8119_();
        if (!this.m_9236_().f_46443_) {
            LivingEntity rider;
            if (this.hasReservation()) {
                if (this.reservationExpiration > 200) {
                    this.clearReservation();
                    this.reservationExpiration = 0;
                } else {
                    ++this.reservationExpiration;
                }
            }
            if (!this.isReadyForCombat()) {
                this.m_20197_().forEach(Entity::m_8127_);
            }
            if ((rider = this.m_6688_()) instanceof EntityCitizen) {
                EntityCitizen cavunit = (EntityCitizen)rider;
                MinecoloniesAdvancedPathNavigate nav = (MinecoloniesAdvancedPathNavigate)this.m_21573_();
                if (nav.m_26570_() != null && !nav.m_26570_().m_77392_()) {
                    BlockPos next = nav.m_26570_().m_77400_();
                    cavunit.m_21563_().m_24950_((double)next.m_123341_() + 0.5, (double)next.m_123342_(), (double)next.m_123343_() + 0.5, 30.0f, 30.0f);
                }
            }
        }
    }

    public void logActiveGoals() {
        Goal goal;
        if (this.logCooldown > 0) {
            --this.logCooldown;
            return;
        }
        this.logCooldown = 200;
        for (WrappedGoal wrapped : this.f_21345_.m_148105_()) {
            goal = wrapped.m_26015_();
            if (!wrapped.m_7620_()) continue;
            Log.getLogger().info("Active Wrapped Goal for horse {}: {}", (Object)this.m_20148_(), (Object)goal.getClass().getSimpleName());
        }
        for (WrappedGoal wrapped : this.f_21346_.m_148105_()) {
            goal = wrapped.m_26015_();
            if (!wrapped.m_7620_()) continue;
            Log.getLogger().info("Active Target Goal for horse {}: {}", (Object)this.m_20148_(), (Object)goal.getClass().getSimpleName());
        }
    }

    public static CavalryHorseEntity createFromVanilla(IColony colony, Level level, AbstractHorse vanilla) {
        AttributeInstance cavJumpAttr;
        AttributeInstance cavSpeedAttr;
        if (level.f_46443_) {
            return null;
        }
        if (vanilla instanceof CavalryHorseEntity) {
            return (CavalryHorseEntity)vanilla;
        }
        if (vanilla == null || !vanilla.m_6084_() || vanilla.m_20160_()) {
            return null;
        }
        boolean wasTamed = vanilla.m_30614_();
        UUID owner = vanilla.m_21805_();
        int temper = vanilla.m_30624_();
        double health = vanilla.m_21223_();
        String customName = vanilla.m_8077_() ? vanilla.m_7755_().getString() : null;
        AttributeInstance healthAttr = vanilla.m_21051_(Attributes.f_22276_);
        AttributeInstance speedAttr = vanilla.m_21051_(Attributes.f_22279_);
        AttributeInstance jumpAttr = vanilla.m_21051_(Attributes.f_22288_);
        double maxHealth = healthAttr != null ? healthAttr.m_22115_() * 1.25 : 30.0;
        double moveSpeed = speedAttr != null ? speedAttr.m_22115_() * 1.25 : 0.25;
        double jumpStrength = jumpAttr != null ? 0.7 : 0.7;
        Variant variant = null;
        if (vanilla instanceof Horse) {
            Horse h = (Horse)vanilla;
            variant = h.m_28554_();
        }
        Entity leashHolder = vanilla.m_21524_();
        CavalryHorseEntity cav = (CavalryHorseEntity)vanilla.m_21406_(ModEntities.CAVALRY_HORSE, true);
        if (cav == null) {
            return null;
        }
        IAnimalData animalData = colony.getAnimalManager().createAndRegisterAnimalData(cav);
        cav.setAnimalData(animalData);
        cav.setColonyId(colony.getID());
        AttributeInstance cavHealthAttr = cav.m_21051_(Attributes.f_22276_);
        if (cavHealthAttr != null) {
            cavHealthAttr.m_22100_(maxHealth);
        }
        if ((cavSpeedAttr = cav.m_21051_(Attributes.f_22279_)) != null) {
            cavSpeedAttr.m_22100_(moveSpeed);
        }
        if ((cavJumpAttr = cav.m_21051_(Attributes.f_22288_)) != null) {
            cavJumpAttr.m_22100_(jumpStrength);
        }
        cav.m_274367_(1.1f);
        cav.m_21153_((float)Math.min(health, maxHealth));
        cav.m_30651_(wasTamed);
        cav.m_30586_(owner);
        cav.m_30649_(temper);
        cav.m_21530_();
        if (variant != null) {
            cav.m_28464_(variant);
        }
        if (customName != null) {
            cav.m_6593_((Component)Component.m_237113_((String)customName));
        }
        if (leashHolder != null) {
            cav.m_21463_(leashHolder, true);
        }
        return cav;
    }

    public boolean m_142391_() {
        return true;
    }

    public boolean m_6469_(@Nonnull DamageSource damageSource, float damageAmount) {
        if (this.m_9236_().f_46443_) {
            return true;
        }
        float cooldownImpact = 0.4f;
        if (damageSource.m_269533_(DamageTypeTags.f_268415_) && damageSource.m_7639_() instanceof Creeper) {
            damageAmount *= 0.3f;
        }
        if (damageSource.m_276093_(DamageSourceKeys.STUCK_DAMAGE)) {
            damageAmount *= 0.0f;
        }
        this.animalData.setCombatCooldown(this.animalData.getCombatCooldown() + damageAmount * cooldownImpact);
        this.animalData.markDirty();
        return super.m_6469_(damageSource, damageAmount);
    }

    public void m_7380_(@Nonnull CompoundTag tag) {
        super.m_7380_(tag);
        tag.m_128405_("colony", this.animalColonyHandler.getColonyId());
        if (this.animalData != null) {
            tag.m_128405_("animalid", this.getManagedAnimalId());
        }
    }

    public void m_7378_(@Nonnull CompoundTag tag) {
        super.m_7378_(tag);
        if (tag.m_128441_("colony")) {
            int colonyId = tag.m_128451_("colony");
            this.setColonyId(colonyId);
            if (tag.m_128441_("animalid")) {
                this.setManagedAnimalId(tag.m_128451_("animalid"));
            } else {
                IColony colony = this.animalColonyHandler.getColony();
                if (colony != null) {
                    this.animalData = colony.getAnimalManager().createAndRegisterAnimalData(this);
                }
            }
        }
    }

    public void prepareForCombat(float combatReadiness) {
        this.animalData.setCombatCooldown(this.animalData.getCombatCooldown() - Math.abs(combatReadiness));
    }

    public boolean isReadyForCombat() {
        if (this.animalData == null) {
            return false;
        }
        return this.animalData.getCombatCooldown() <= this.m_21233_() * 0.66f;
    }

    protected boolean m_196406_(@Nonnull Vec3 vec3) {
        this.lastHorizontalCollision = this.f_19853_.m_46467_();
        return super.m_196406_(vec3);
    }

    public boolean hadHorizontalCollission() {
        return this.f_19853_.m_46467_() - this.lastHorizontalCollision < 10L;
    }

    public void reserve(Entity reserver) {
        CompoundTag data = this.getPersistentData();
        data.m_128362_(RESERVE_KEY, reserver.m_20148_());
        this.reservationExpiration = 0;
    }

    public void clearReservation() {
        this.getPersistentData().m_128473_(RESERVE_KEY);
    }

    public boolean clearFor(Entity reserver) {
        CompoundTag data = this.getPersistentData();
        if (data.m_128425_(RESERVE_KEY, 11)) {
            UUID who = data.m_128342_(RESERVE_KEY);
            if (reserver.m_20148_().equals(who)) {
                this.clearReservation();
                return true;
            }
        }
        return false;
    }

    public UUID reservedBy() {
        CompoundTag data = this.getPersistentData();
        return data.m_128425_(RESERVE_KEY, 11) ? data.m_128342_(RESERVE_KEY) : null;
    }

    public boolean hasReservation() {
        return this.reservedBy() != null;
    }

    public IBuilding getStableBuilding() {
        if (this.animalData == null) {
            return null;
        }
        IBuilding building = this.animalData.getHomeBuilding();
        return building;
    }

    public boolean isInStable() {
        IBuilding stable = this.getStableBuilding();
        if (stable == null) {
            return false;
        }
        return stable.isInBuilding(this.m_20097_());
    }

    @Override
    public IAnimalData getAnimalData() {
        return this.animalData;
    }

    @Override
    public IAnimalDataView getAnimalDataView() {
        return this.animalDataView;
    }

    @Override
    public void setAnimalData(IAnimalData data) {
        if (data == null) {
            return;
        }
        this.animalData = data;
    }

    @Override
    public CavalryHorseEntity getEntity() {
        return this;
    }
}

