/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.entity.mobs.aitasks;

import com.minecolonies.api.blocks.decorative.AbstractBlockGate;
import com.minecolonies.api.colony.ICitizenData;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.entity.citizen.AbstractEntityCitizen;
import com.minecolonies.api.entity.mobs.AbstractEntityMinecoloniesRaider;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.BlockPosUtil;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.colony.buildings.AbstractBuildingGuards;
import com.minecolonies.core.colony.jobs.AbstractJobGuard;
import com.minecolonies.core.entity.ai.workers.guard.AbstractEntityAIGuard;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.BreakDoorGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;

public class EntityAIBreakDoor
extends BreakDoorGoal {
    private BlockPos prevDoorPos = BlockPos.f_121853_;
    private int hardness = 0;
    private int breakChance = 1;

    public EntityAIBreakDoor(Mob entityIn) {
        super(entityIn, difficulty -> difficulty.m_19028_() > 0);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8045_() {
        return super.m_8045_() && !this.f_25189_.f_19853_.m_46859_(this.f_25190_);
    }

    public void m_8056_() {
        super.m_8056_();
        if (!this.prevDoorPos.equals((Object)this.f_25190_)) {
            this.f_25082_ = 0;
        }
        this.prevDoorPos = this.f_25190_;
        this.hardness = (int)(1.0f + this.f_25189_.f_19853_.m_8055_(this.f_25190_).m_60800_((BlockGetter)this.f_25189_.f_19853_, this.f_25190_));
        if (this.f_25189_ instanceof AbstractEntityMinecoloniesRaider) {
            ((AbstractEntityMinecoloniesRaider)this.f_25189_).setCanBeStuck(false);
        }
    }

    public void m_8041_() {
        super.m_8041_();
        this.f_25189_.f_19853_.m_6801_(this.f_25189_.m_19879_(), this.f_25190_, -1);
        if (this.f_25189_ instanceof AbstractEntityMinecoloniesRaider) {
            ((AbstractEntityMinecoloniesRaider)this.f_25189_).setCanBeStuck(true);
        }
    }

    public void m_8037_() {
        BlockState toBreak;
        if (this.f_25189_.m_20193_().m_46791_().m_19028_() < 2 || !((Boolean)MineColonies.getConfig().getServer().raidersbreakdoors.get()).booleanValue()) {
            this.f_25082_ = 0;
            return;
        }
        if (this.f_25189_.m_217043_().m_188503_(this.breakChance) != 0) {
            --this.f_25082_;
        } else {
            Mob mob;
            double fasterBreakPerXNearby = 5.0;
            if (this.f_25189_ instanceof AbstractEntityMinecoloniesRaider && !this.f_25189_.f_19853_.m_5776_() && this.f_25189_.f_19853_.m_8055_(this.f_25190_).m_60734_() instanceof AbstractBlockGate) {
                IColony colony = ((AbstractEntityMinecoloniesRaider)this.f_25189_).getColony();
                fasterBreakPerXNearby += colony.getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.MECHANIC_ENHANCED_GATES);
            }
            this.breakChance = (int)Math.max(1.0, (double)this.hardness / (1.0 + (double)this.f_25189_.f_19853_.m_45976_(AbstractEntityMinecoloniesRaider.class, this.f_25189_.m_20191_().m_82400_(5.0)).size() / (fasterBreakPerXNearby /= 2.0)));
            if (this.f_25189_.m_217043_().m_188503_(this.breakChance) == 0 && (mob = this.f_25189_) instanceof AbstractEntityMinecoloniesRaider) {
                AbstractEntityMinecoloniesRaider raider = (AbstractEntityMinecoloniesRaider)mob;
                if (this.f_25189_.f_19853_.m_8055_(this.f_25190_).m_60734_() instanceof AbstractBlockGate) {
                    ArrayList<AbstractEntityCitizen> possibleGuards = new ArrayList<AbstractEntityCitizen>();
                    for (ICitizenData entry : raider.getColony().getCitizenManager().getCitizens()) {
                        if (!entry.getEntity().isPresent() || !(entry.getJob() instanceof AbstractJobGuard) || BlockPosUtil.getDistanceSquared(entry.getEntity().get().m_20183_(), this.f_25190_) >= 10000L || entry.getJob().getWorkerAI() == null || !((AbstractEntityAIGuard)entry.getJob().getWorkerAI()).canHelp(this.f_25190_) || this.f_25190_.equals((Object)((AbstractEntityAIGuard)entry.getJob().getWorkerAI()).getCurrentPatrolPoint())) continue;
                        possibleGuards.add(entry.getEntity().get());
                    }
                    possibleGuards.sort(Comparator.comparingInt(guard -> (int)this.f_25190_.m_123331_((Vec3i)guard.m_20183_())));
                    BlockPos gotoPos = BlockPos.m_274446_((Position)Vec3.m_82512_((Vec3i)this.f_25190_).m_82549_(Vec3.m_82512_((Vec3i)raider.getColony().getCenter()).m_82546_(Vec3.m_82512_((Vec3i)this.f_25190_)).m_82541_().m_82542_(3.0, 0.0, 3.0)));
                    for (int i = 0; i < possibleGuards.size() && i <= 3; ++i) {
                        ((AbstractBuildingGuards)((AbstractEntityCitizen)possibleGuards.get(i)).getCitizenData().getWorkBuilding()).setTempNextPatrolPoint(gotoPos);
                    }
                }
            }
        }
        if (this.f_25082_ == this.m_25100_() - 1 && (toBreak = this.f_25189_.f_19853_.m_8055_(this.f_25190_)).m_60734_() instanceof AbstractBlockGate) {
            ((AbstractBlockGate)toBreak.m_60734_()).removeGate(this.f_25189_.f_19853_, this.f_25190_, ((Direction)toBreak.m_61143_((Property)BlockStateProperties.f_61374_)).m_122427_());
        }
        super.m_8037_();
    }
}

