/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.commands.colonycommands;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.colonyEvents.registry.ColonyEventTypeRegistryEntry;
import com.minecolonies.api.colony.managers.interfaces.IRaiderManager;
import com.minecolonies.core.commands.arguments.MultiColonyIdArgument;
import com.minecolonies.core.commands.commandTypes.IMCCommand;
import com.minecolonies.core.commands.commandTypes.IMCOPCommand;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.BlockPosArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class CommandRaid
implements IMCOPCommand {
    private static final DynamicCommandExceptionType ERROR_INVALID_COLONY_EVENT_TYPE = new DynamicCommandExceptionType(entry -> Component.m_237110_((String)"com.minecolonies.command.raid.colony_type.invalid", (Object[])new Object[]{entry}));

    private int onExecuteWithType(CommandContext<CommandSourceStack> ctx) {
        return this.checkPreConditionAndExecute(ctx, context -> {
            String raidType = this.getRaidType((CommandContext<CommandSourceStack>)context);
            boolean allowShips = BoolArgumentType.getBool((CommandContext)context, (String)"allowships");
            return this.raidExecute((CommandContext<CommandSourceStack>)context, new IRaiderManager.RaidSettings(true, raidType, allowShips, null, null));
        });
    }

    private int onExecuteWithAmount(CommandContext<CommandSourceStack> ctx) {
        return this.checkPreConditionAndExecute(ctx, context -> {
            String raidType = this.getRaidType((CommandContext<CommandSourceStack>)context);
            boolean allowShips = BoolArgumentType.getBool((CommandContext)context, (String)"allowships");
            int raidAmount = IntegerArgumentType.getInteger((CommandContext)context, (String)"raidamount");
            return this.raidExecute((CommandContext<CommandSourceStack>)context, new IRaiderManager.RaidSettings(true, raidType, allowShips, raidAmount, null));
        });
    }

    private int onExecuteWithLocation(CommandContext<CommandSourceStack> ctx) {
        return this.checkPreConditionAndExecute(ctx, context -> {
            String raidType = this.getRaidType((CommandContext<CommandSourceStack>)context);
            boolean allowShips = BoolArgumentType.getBool((CommandContext)context, (String)"allowships");
            int raidAmount = IntegerArgumentType.getInteger((CommandContext)context, (String)"raidamount");
            BlockPos raidLocation = BlockPosArgument.m_264582_((CommandContext)context, (String)"raidlocation");
            return this.raidExecute((CommandContext<CommandSourceStack>)context, new IRaiderManager.RaidSettings(true, raidType, allowShips, raidAmount, raidLocation));
        });
    }

    private String getRaidType(CommandContext<CommandSourceStack> context) throws CommandSyntaxException {
        String raidTypeString = StringArgumentType.getString(context, (String)"raidtype");
        ResourceLocation raidType = new ResourceLocation("minecolonies", raidTypeString);
        ColonyEventTypeRegistryEntry colonyEventTypeRegistryEntry = (ColonyEventTypeRegistryEntry)IMinecoloniesAPI.getInstance().getColonyEventRegistry().getValue(raidType);
        if (colonyEventTypeRegistryEntry != null && colonyEventTypeRegistryEntry.isRaidEvent()) {
            return raidTypeString;
        }
        throw ERROR_INVALID_COLONY_EVENT_TYPE.create((Object)raidTypeString);
    }

    @Override
    public final LiteralArgumentBuilder<CommandSourceStack> build() {
        List<String> raidTimes = List.of("now", "tonight");
        ArrayList<String> raidTypes = new ArrayList<String>();
        for (ColonyEventTypeRegistryEntry colonyEventType : IMinecoloniesAPI.getInstance().getColonyEventRegistry()) {
            if (!colonyEventType.isRaidEvent()) continue;
            raidTypes.add(colonyEventType.getRegistryName().m_135815_());
        }
        RequiredArgumentBuilder raidLocationArg = (RequiredArgumentBuilder)IMCCommand.newArgument("raidlocation", BlockPosArgument.m_118239_()).executes(this::onExecuteWithLocation);
        RequiredArgumentBuilder raidAmountArg = (RequiredArgumentBuilder)((RequiredArgumentBuilder)IMCCommand.newArgument("raidamount", IntegerArgumentType.integer((int)1)).executes(this::onExecuteWithAmount)).then((ArgumentBuilder)raidLocationArg);
        RequiredArgumentBuilder raidShipArg = (RequiredArgumentBuilder)((RequiredArgumentBuilder)IMCCommand.newArgument("allowships", BoolArgumentType.bool()).executes(this::onExecuteWithType)).then((ArgumentBuilder)raidAmountArg);
        RequiredArgumentBuilder raidTypeArg = (RequiredArgumentBuilder)IMCCommand.newArgument("raidtype", StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_((Iterable)raidTypes, (SuggestionsBuilder)builder)).then((ArgumentBuilder)raidShipArg);
        RequiredArgumentBuilder raidTimeArg = (RequiredArgumentBuilder)((RequiredArgumentBuilder)IMCCommand.newArgument("raidtime", StringArgumentType.string()).suggests((ctx, builder) -> SharedSuggestionProvider.m_82970_((Iterable)raidTimes, (SuggestionsBuilder)builder)).executes(this::checkPreConditionAndExecute)).then((ArgumentBuilder)raidTypeArg);
        RequiredArgumentBuilder colonyIdArg = (RequiredArgumentBuilder)IMCCommand.newArgument("colonyID", MultiColonyIdArgument.id()).then((ArgumentBuilder)raidTimeArg);
        RequiredArgumentBuilder allColoniesArg = (RequiredArgumentBuilder)IMCCommand.newArgument("colonyID", StringArgumentType.string()).then((ArgumentBuilder)raidTimeArg);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)IMCCommand.newLiteral(this.getName()).then((ArgumentBuilder)colonyIdArg)).then((ArgumentBuilder)allColoniesArg);
    }

    @Override
    public final int onExecute(CommandContext<CommandSourceStack> context) {
        return this.raidExecute(context, new IRaiderManager.RaidSettings(true, null, true, null, null));
    }

    private int raidExecute(CommandContext<CommandSourceStack> context, IRaiderManager.RaidSettings raidSettings) {
        String raidTime;
        return switch (raidTime = StringArgumentType.getString(context, (String)"raidtime")) {
            case "now" -> this.startRaidNow(context, raidSettings);
            case "tonight" -> this.startRaidTonight(context, raidSettings);
            default -> 0;
        };
    }

    private int startRaidNow(CommandContext<CommandSourceStack> context, IRaiderManager.RaidSettings raidSettings) {
        List<IColony> colonies = MultiColonyIdArgument.getColonies(context, "colonyID");
        for (IColony colony : colonies) {
            IRaiderManager.RaidSpawnResult result = colony.getRaiderManager().raiderEvent(raidSettings);
            if (result == IRaiderManager.RaidSpawnResult.SUCCESS) {
                ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.raidnow.success", (Object[])new Object[]{colony.getName()}), true);
                continue;
            }
            ((CommandSourceStack)context.getSource()).m_81352_((Component)Component.m_237110_((String)"com.minecolonies.command.raidnow.failure", (Object[])new Object[]{colony.getName(), result}));
        }
        return 1;
    }

    private int startRaidTonight(CommandContext<CommandSourceStack> context, IRaiderManager.RaidSettings raidSettings) {
        List<IColony> colonies = MultiColonyIdArgument.getColonies(context, "colonyID");
        for (IColony colony : colonies) {
            colony.getRaiderManager().setRaidNextNight(raidSettings);
            ((CommandSourceStack)context.getSource()).m_288197_(() -> Component.m_237110_((String)"com.minecolonies.command.raidtonight.success", (Object[])new Object[]{colony.getName()}), true);
        }
        return 1;
    }

    @Override
    public String getName() {
        return "raid";
    }
}

