/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.townhall;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.PaneBuilders;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.views.DropDownList;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.MinecoloniesAPIProxy;
import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.research.util.ResearchConstants;
import com.minecolonies.api.util.Tuple;
import com.minecolonies.core.MineColonies;
import com.minecolonies.core.client.gui.townhall.AbstractWindowTownHall;
import com.minecolonies.core.colony.buildings.moduleviews.CombinedHiringLimitModuleView;
import com.minecolonies.core.colony.buildings.moduleviews.WorkerBuildingModuleView;
import com.minecolonies.core.colony.buildings.views.AbstractBuildingView;
import com.minecolonies.core.colony.buildings.workerbuildings.BuildingTownHall;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import org.jetbrains.annotations.NotNull;

public class WindowStatsPage
extends AbstractWindowTownHall {
    public static final LinkedHashMap<String, Integer> INTERVAL = new LinkedHashMap();
    private DropDownList intervalDropdown;
    public String selectedInterval = "com.minecolonies.coremod.gui.interval.yesterday";

    public WindowStatsPage(BuildingTownHall.View townHall) {
        super(townHall, "layoutstats.xml");
    }

    @Override
    public void onOpened() {
        super.onOpened();
        this.updateStats();
        this.createAndSetStatistics();
    }

    private void createAndSetStatistics() {
        int citizensCap;
        int citizensSize = ((ITownHallView)this.buildingView).getColony().getCitizens().size();
        if (MinecoloniesAPIProxy.getInstance().getGlobalResearchTree().hasResearchEffect(ResearchConstants.CITIZEN_CAP)) {
            int max = Math.max(25, (int)((ITownHallView)this.buildingView).getColony().getResearchManager().getResearchEffects().getEffectStrength(ResearchConstants.CITIZEN_CAP));
            citizensCap = Math.min(max, (Integer)MineColonies.getConfig().getServer().maxCitizenPerColony.get());
        } else {
            citizensCap = (Integer)MineColonies.getConfig().getServer().maxCitizenPerColony.get();
        }
        Text totalCitizenLabel = (Text)this.findPaneOfTypeByID("totalCitizens", Text.class);
        totalCitizenLabel.setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.townhall.population.totalcitizens.count", (Object[])new Object[]{citizensSize, Math.max(citizensSize, ((ITownHallView)this.buildingView).getColony().getCitizenCountLimit())}));
        ArrayList<MutableComponent> hoverText = new ArrayList<MutableComponent>();
        if ((double)citizensSize < (double)citizensCap * 0.9 && (double)citizensSize < (double)((ITownHallView)this.buildingView).getColony().getCitizenCountLimit() * 0.9) {
            totalCitizenLabel.setColors(DARKGREEN);
        } else if (citizensSize < citizensCap) {
            hoverText.add(Component.m_237110_((String)"com.minecolonies.coremod.gui.townhall.population.totalcitizens.houselimited", (Object[])new Object[]{((ITownHallView)this.buildingView).getColony().getName()}));
            totalCitizenLabel.setColors(ORANGE);
        } else {
            if (citizensCap < (Integer)MineColonies.getConfig().getServer().maxCitizenPerColony.get()) {
                hoverText.add(Component.m_237110_((String)"com.minecolonies.coremod.gui.townhall.population.totalcitizens.researchlimited", (Object[])new Object[]{((ITownHallView)this.buildingView).getColony().getName()}));
            } else {
                hoverText.add(Component.m_237110_((String)"com.minecolonies.coremod.gui.townhall.population.totalcitizens.configlimited", (Object[])new Object[]{((ITownHallView)this.buildingView).getColony().getName()}));
            }
            totalCitizenLabel.setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.townhall.population.totalcitizens.count", (Object[])new Object[]{citizensSize, citizensCap}));
            totalCitizenLabel.setColors(RED);
        }
        PaneBuilders.tooltipBuilder().hoverPane((Pane)totalCitizenLabel).build().setText(hoverText);
        int children = 0;
        HashMap<String, Tuple<Integer, Integer>> jobMaxCountMap = new HashMap<String, Tuple<Integer, Integer>>();
        for (IBuildingView iBuildingView : ((ITownHallView)this.buildingView).getColony().getBuildings()) {
            if (!(iBuildingView instanceof AbstractBuildingView)) continue;
            for (WorkerBuildingModuleView module : iBuildingView.getModuleViews(WorkerBuildingModuleView.class)) {
                int alreadyAssigned = -1;
                if (module instanceof CombinedHiringLimitModuleView) {
                    alreadyAssigned = 0;
                    for (WorkerBuildingModuleView combinedModule : iBuildingView.getModuleViews(WorkerBuildingModuleView.class)) {
                        alreadyAssigned += combinedModule.getAssignedCitizens().size();
                    }
                }
                int max = module.getMaxInhabitants();
                if (alreadyAssigned != -1) {
                    max -= alreadyAssigned;
                    max += module.getAssignedCitizens().size();
                }
                int workers = module.getAssignedCitizens().size();
                String jobName = module.getJobDisplayName().toLowerCase(Locale.US);
                Tuple<Integer, Integer> tuple = jobMaxCountMap.getOrDefault(jobName, new Tuple<Integer, Integer>(0, 0));
                jobMaxCountMap.put(jobName, new Tuple<Integer, Integer>(tuple.getA() + workers, tuple.getB() + max));
            }
        }
        int unemployed = 0;
        for (ICitizenDataView iCitizenDataView : ((ITownHallView)this.buildingView).getColony().getCitizens().values()) {
            if (iCitizenDataView.isChild()) {
                ++children;
                continue;
            }
            if (iCitizenDataView.getJobView() != null) continue;
            ++unemployed;
        }
        final int n = children;
        final int unemployedCount = unemployed;
        ScrollingList list = (ScrollingList)this.findPaneOfTypeByID("citizen-stats", ScrollingList.class);
        if (list == null) {
            return;
        }
        final int maxJobs = jobMaxCountMap.size();
        final ArrayList theList = new ArrayList(jobMaxCountMap.entrySet());
        theList.sort(Map.Entry.comparingByKey());
        list.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return maxJobs + 2;
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                Text label = (Text)rowPane.findPaneOfTypeByID("citizensAmount", Text.class);
                if (index < theList.size()) {
                    Map.Entry entry = (Map.Entry)theList.get(index);
                    String jobString = Component.m_237115_((String)((String)entry.getKey())).getString();
                    String formattedJobString = jobString.substring(0, 1).toUpperCase(Locale.US) + jobString.substring(1);
                    MutableComponent numberOfWorkers = Component.m_237110_((String)"com.minecolonies.coremod.gui.townhall.population.each", (Object[])new Object[]{formattedJobString, ((Tuple)entry.getValue()).getA(), ((Tuple)entry.getValue()).getB()});
                    label.setText((Component)numberOfWorkers);
                } else if (index == maxJobs + 1) {
                    label.setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.townhall.population.unemployed", (Object[])new Object[]{unemployedCount}));
                } else {
                    label.setText(Component.m_237110_((String)"com.minecolonies.coremod.gui.townhall.population.childs", (Object[])new Object[]{n}));
                }
            }
        });
    }

    private void updateStats() {
        final @NotNull ArrayList<String> stats = new ArrayList<String>(((ITownHallView)this.buildingView).getColony().getStatisticsManager().getStatTypes());
        ((ScrollingList)this.findPaneOfTypeByID("stats", ScrollingList.class)).setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return stats.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                int stat = ((ITownHallView)WindowStatsPage.this.buildingView).getColony().getStatisticsManager().getStatTotal((String)stats.get(index));
                int interval = INTERVAL.get(WindowStatsPage.this.selectedInterval);
                if (interval > 0) {
                    stat = ((ITownHallView)WindowStatsPage.this.buildingView).getColony().getStatisticsManager().getStatsInPeriod((String)stats.get(index), ((ITownHallView)WindowStatsPage.this.buildingView).getColony().getDay() - interval, ((ITownHallView)WindowStatsPage.this.buildingView).getColony().getDay());
                }
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("desc", Text.class);
                resourceLabel.setText(Component.m_237110_((String)("com.minecolonies.coremod.gui.townhall.stats." + (String)stats.get(index)), (Object[])new Object[]{stat}));
            }
        });
        this.intervalDropdown = (DropDownList)this.findPaneOfTypeByID("intervals", DropDownList.class);
        this.intervalDropdown.setHandler(this::onDropDownListChanged);
        this.intervalDropdown.setDataProvider(new DropDownList.DataProvider(){

            public int getElementCount() {
                return INTERVAL.size();
            }

            public String getLabel(int index) {
                return Component.m_237115_((String)((String)INTERVAL.keySet().toArray()[index])).getString();
            }
        });
        this.intervalDropdown.setSelectedIndex(new ArrayList<String>(INTERVAL.keySet()).indexOf(this.selectedInterval));
    }

    private void onDropDownListChanged(DropDownList dropDownList) {
        String temp = (String)INTERVAL.keySet().toArray()[dropDownList.getSelectedIndex()];
        if (!temp.equals(this.selectedInterval)) {
            this.selectedInterval = temp;
            this.updateStats();
        }
    }

    @Override
    protected String getWindowId() {
        return "happiness";
    }

    static {
        INTERVAL.put("com.minecolonies.coremod.gui.interval.yesterday", 1);
        INTERVAL.put("com.minecolonies.coremod.gui.interval.lastweek", 7);
        INTERVAL.put("com.minecolonies.coremod.gui.interval.100days", 100);
        INTERVAL.put("com.minecolonies.coremod.gui.interval.alltime", -1);
    }
}

