/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.core.client.gui.modules.building;

import com.ldtteam.blockui.Pane;
import com.ldtteam.blockui.controls.Button;
import com.ldtteam.blockui.controls.Text;
import com.ldtteam.blockui.controls.TextField;
import com.ldtteam.blockui.views.ScrollingList;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.modules.IEntityListModuleView;
import com.minecolonies.core.client.gui.AbstractModuleWindow;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;

public class EntityListModuleWindow
extends AbstractModuleWindow<IEntityListModuleView> {
    private final ScrollingList resourceList;
    private String filter = "";
    private final boolean isInverted;
    private final List<ResourceLocation> groupedItemList;
    private final List<ResourceLocation> currentDisplayedList = new ArrayList<ResourceLocation>();
    private int tick;

    public EntityListModuleWindow(IEntityListModuleView moduleView) {
        super(moduleView, new ResourceLocation("minecolonies", "gui/layouthuts/layoutfilterableentitylist.xml"));
        this.isInverted = moduleView.isInverted();
        this.id = moduleView.getId();
        this.resourceList = (ScrollingList)this.window.findPaneOfTypeByID("resources", ScrollingList.class);
        this.groupedItemList = new ArrayList<ResourceLocation>((Collection<ResourceLocation>)IColonyManager.getInstance().getCompatibilityManager().getAllMonsters());
        ((TextField)this.window.findPaneOfTypeByID("input", TextField.class)).setHandler(input -> {
            String newFilter = input.getText();
            if (!newFilter.equals(this.filter)) {
                this.filter = newFilter;
                this.tick = 10;
            }
        });
    }

    @Override
    public void onButtonClicked(@NotNull Button button) {
        super.onButtonClicked(button);
        if (Objects.equals(button.getID(), "switch")) {
            this.switchClicked(button);
        } else if (Objects.equals(button.getID(), "resetDefault")) {
            this.reset();
        }
    }

    @Override
    public void onOpened() {
        this.updateResources();
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (this.tick > 0 && --this.tick == 0) {
            this.updateResources();
        }
    }

    private void switchClicked(@NotNull Button button) {
        int row = this.resourceList.getListElementIndexByPane((Pane)button);
        ResourceLocation item = this.currentDisplayedList.get(row);
        boolean on = button.getText().equals((Object)Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon"));
        boolean add = on && this.isInverted || !on && !this.isInverted;
        IEntityListModuleView module = this.buildingView.getModuleViewMatching(IEntityListModuleView.class, view -> view.getId().equals(this.id));
        if (add) {
            module.addEntity(item);
        } else {
            module.removeEntity(item);
        }
        this.resourceList.refreshElementPanes();
    }

    private void reset() {
        IEntityListModuleView module = this.buildingView.getModuleViewMatching(IEntityListModuleView.class, view -> view.getId().equals(this.id));
        module.clearEntities();
        this.resourceList.refreshElementPanes();
    }

    private void updateResources() {
        Predicate<ResourceLocation> filterPredicate = res -> this.filter.isEmpty() || ((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(res)).m_20676_().getString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US)) || res.toString().toLowerCase(Locale.US).contains(this.filter.toLowerCase(Locale.US));
        this.currentDisplayedList.clear();
        for (ResourceLocation storage : this.groupedItemList) {
            if (!filterPredicate.test(storage)) continue;
            this.currentDisplayedList.add(storage);
        }
        this.currentDisplayedList.sort((o1, o2) -> {
            boolean o1Allowed = this.buildingView.getModuleViewMatching(IEntityListModuleView.class, view -> view.getId().equals(this.id)).isAllowedEntity((ResourceLocation)o1);
            boolean o2Allowed = this.buildingView.getModuleViewMatching(IEntityListModuleView.class, view -> view.getId().equals(this.id)).isAllowedEntity((ResourceLocation)o2);
            if (!o1Allowed && o2Allowed) {
                return this.isInverted ? -1 : 1;
            }
            if (o1Allowed && !o2Allowed) {
                return this.isInverted ? 1 : -1;
            }
            return 0;
        });
        this.updateResourceList();
    }

    private void updateResourceList() {
        this.resourceList.enable();
        this.resourceList.show();
        this.resourceList.setDataProvider(new ScrollingList.DataProvider(){

            public int getElementCount() {
                return EntityListModuleWindow.this.currentDisplayedList.size();
            }

            public void updateElement(int index, @NotNull Pane rowPane) {
                ResourceLocation resource = EntityListModuleWindow.this.currentDisplayedList.get(index);
                Text resourceLabel = (Text)rowPane.findPaneOfTypeByID("resourceName", Text.class);
                resourceLabel.setText(((EntityType)ForgeRegistries.ENTITY_TYPES.getValue(resource)).m_20676_());
                resourceLabel.setColors(7);
                boolean isAllowedItem = EntityListModuleWindow.this.buildingView.getModuleViewMatching(IEntityListModuleView.class, view -> view.getId().equals(EntityListModuleWindow.this.id)).isAllowedEntity(resource);
                Button switchButton = (Button)rowPane.findPaneOfTypeByID("switch", Button.class);
                if (EntityListModuleWindow.this.isInverted && !isAllowedItem || !EntityListModuleWindow.this.isInverted && isAllowedItem) {
                    switchButton.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.retrieveon"));
                } else {
                    switchButton.setText(Component.m_237115_((String)"com.minecolonies.coremod.gui.workerhuts.retrieveoff"));
                }
            }
        });
    }
}

