/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.research.requirements;

import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.research.IGlobalResearchTree;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.core.util.GsonHelper;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class ResearchResearchRequirement
implements IResearchRequirement {
    public static final String RESEARCH_REQUIRED_RESEARCH_PROP = "research";
    private static final String TAG_ID = "id";
    private final ResourceLocation researchId;

    public ResearchResearchRequirement(CompoundTag nbt) {
        this.researchId = new ResourceLocation(nbt.m_128461_(TAG_ID));
    }

    public ResearchResearchRequirement(JsonObject json) {
        this.researchId = GsonHelper.getAsResourceLocation(json, RESEARCH_REQUIRED_RESEARCH_PROP);
    }

    public ResourceLocation getResearchId() {
        return this.researchId;
    }

    @Override
    public ModResearchRequirements.ResearchRequirementEntry getRegistryEntry() {
        return (ModResearchRequirements.ResearchRequirementEntry)ModResearchRequirements.researchResearchRequirement.get();
    }

    @Override
    public MutableComponent getDesc() {
        return MutableComponent.m_237204_((ComponentContents)IGlobalResearchTree.getInstance().getResearch(this.researchId).getName());
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        return colony.getResearchManager().getResearchTree().hasCompletedResearch(this.researchId);
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(TAG_ID, this.researchId.toString());
        return nbt;
    }
}

