/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.research.requirements;

import com.google.gson.JsonObject;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.colony.buildings.registry.IBuildingRegistry;
import com.minecolonies.api.research.IResearchRequirement;
import com.minecolonies.api.research.ModResearchRequirements;
import com.minecolonies.core.util.GsonHelper;
import java.util.Objects;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;

public class BuildingResearchRequirement
implements IResearchRequirement {
    private static final String TAG_BUILDING_NAME = "building-name";
    private static final String TAG_BUILDING_LVL = "building-lvl";
    private static final String RESEARCH_REQUIREMENT_BUILDING_PROP = "building";
    private static final String RESEARCH_REQUIREMENT_BUILDING_LEVEL_PROP = "level";
    private final ResourceLocation building;
    private final int buildingLevel;
    private final boolean singleBuilding;

    public BuildingResearchRequirement(CompoundTag nbt) {
        this.building = BuildingResearchRequirement.parseFallbackBuildingKey(nbt.m_128461_(TAG_BUILDING_NAME));
        this.buildingLevel = nbt.m_128451_(TAG_BUILDING_LVL);
        this.singleBuilding = nbt.m_128461_("requirement-type").equals(ModResearchRequirements.BUILDING_SINGLE_RESEARCH_REQ_ID.toString());
    }

    public static ResourceLocation parseFallbackBuildingKey(String key) {
        ResourceLocation buildingResourceLocation = ResourceLocation.m_135820_((String)key);
        return Objects.requireNonNullElseGet(buildingResourceLocation, () -> new ResourceLocation("minecolonies", key));
    }

    public BuildingResearchRequirement(JsonObject json) {
        this.building = BuildingResearchRequirement.parseFallbackBuildingKey(GsonHelper.m_13906_((JsonObject)json, (String)RESEARCH_REQUIREMENT_BUILDING_PROP));
        this.buildingLevel = GsonHelper.m_13927_((JsonObject)json, (String)RESEARCH_REQUIREMENT_BUILDING_LEVEL_PROP);
        this.singleBuilding = GsonHelper.getAsResourceLocation(json, "type").equals((Object)ModResearchRequirements.BUILDING_SINGLE_RESEARCH_REQ_ID);
    }

    public ResourceLocation getBuilding() {
        return this.building;
    }

    public int getBuildingLevel() {
        return this.buildingLevel;
    }

    @Override
    public ModResearchRequirements.ResearchRequirementEntry getRegistryEntry() {
        return (ModResearchRequirements.ResearchRequirementEntry)ModResearchRequirements.buildingResearchRequirement.get();
    }

    @Override
    public MutableComponent getDesc() {
        MutableComponent buildingName;
        BuildingEntry buildingEntry = (BuildingEntry)IBuildingRegistry.getInstance().getValue(this.building);
        MutableComponent mutableComponent = buildingName = buildingEntry != null ? Component.m_237115_((String)buildingEntry.getTranslationKey()) : Component.m_237119_();
        if (this.singleBuilding) {
            return Component.m_237110_((String)"com.minecolonies.coremod.research.requirement.building.single.level", (Object[])new Object[]{buildingName, this.buildingLevel});
        }
        return Component.m_237110_((String)"com.minecolonies.coremod.research.requirement.building.level", (Object[])new Object[]{buildingName, this.buildingLevel});
    }

    @Override
    public boolean isFulfilled(IColony colony) {
        return colony.hasBuilding(this.building, this.buildingLevel, this.singleBuilding);
    }

    @Override
    public CompoundTag writeToNBT() {
        CompoundTag nbt = new CompoundTag();
        nbt.m_128359_(TAG_BUILDING_NAME, this.building.toString());
        nbt.m_128405_(TAG_BUILDING_LVL, this.buildingLevel);
        return nbt;
    }
}

