/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.api.colony;

import com.minecolonies.api.colony.ICitizenDataView;
import com.minecolonies.api.colony.IColony;
import com.minecolonies.api.colony.buildingextensions.IBuildingExtension;
import com.minecolonies.api.colony.buildings.views.IBuildingView;
import com.minecolonies.api.colony.buildings.workerbuildings.ITownHallView;
import com.minecolonies.api.colony.managers.interfaces.IAnimalDataView;
import com.minecolonies.api.colony.permissions.ColonyPlayer;
import com.minecolonies.api.colony.permissions.IPermissions;
import com.minecolonies.api.colony.requestsystem.manager.IRequestManager;
import com.minecolonies.api.colony.requestsystem.requester.IRequester;
import com.minecolonies.api.colony.workorders.IWorkOrderView;
import com.minecolonies.api.network.IMessage;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IColonyView
extends IColony {
    public List<BlockPos> getFreePositions();

    public List<Block> getFreeBlocks();

    @Override
    public void addFreePosition(@NotNull BlockPos var1);

    @Override
    public void addFreeBlock(@NotNull Block var1);

    @Override
    public void removeFreePosition(@NotNull BlockPos var1);

    @Override
    public void removeFreeBlock(@NotNull Block var1);

    @Override
    public ResourceKey<Level> getDimension();

    @Override
    public boolean isManualHiring();

    @Override
    public boolean isManualHousing();

    @Override
    public boolean canMoveIn();

    @Nullable
    public ITownHallView getTownHall();

    public IBuildingView getBuilding(int var1, int var2, int var3);

    public IBuildingView getBuilding(BlockPos var1);

    @NotNull
    public Map<UUID, ColonyPlayer> getPlayers();

    public int getCitizenCount();

    public int getCitizenCountLimit();

    public Map<Integer, ICitizenDataView> getCitizens();

    public Collection<IWorkOrderView> getWorkOrders();

    public IWorkOrderView getWorkOrder(int var1);

    @Override
    public ICitizenDataView getCitizen(int var1);

    @Nullable
    public IMessage handleColonyViewMessage(@NotNull FriendlyByteBuf var1, @NotNull Level var2, boolean var3);

    @Nullable
    public IMessage handlePermissionsViewMessage(@NotNull FriendlyByteBuf var1);

    @Nullable
    public IMessage handleColonyViewWorkOrderMessage(FriendlyByteBuf var1);

    @Nullable
    public IMessage handleColonyViewCitizensMessage(int var1, FriendlyByteBuf var2);

    public void handleColonyViewVisitorMessage(FriendlyByteBuf var1, boolean var2);

    public void handleColonyViewAnimalMessage(FriendlyByteBuf var1, boolean var2);

    @Nullable
    public IMessage handleColonyViewRemoveCitizenMessage(int var1);

    @Nullable
    public IMessage handleColonyViewRemoveBuildingMessage(BlockPos var1);

    @Nullable
    public IMessage handleColonyViewRemoveWorkOrderMessage(int var1);

    @Nullable
    public IMessage handleColonyBuildingViewMessage(BlockPos var1, @NotNull FriendlyByteBuf var2);

    public void handleColonyViewResearchManagerUpdate(CompoundTag var1);

    public void handleColonyBuildingExtensionViewUpdateMessage(Set<IBuildingExtension> var1);

    @NotNull
    public List<IBuildingExtension> getBuildingExtensions(Predicate<IBuildingExtension> var1);

    @Nullable
    public IBuildingExtension getBuildingExtension(Predicate<IBuildingExtension> var1);

    public void addPlayer(String var1);

    public void removePlayer(UUID var1);

    @Override
    public double getOverallHappiness();

    @Override
    public BlockPos getCenter();

    @Override
    public String getName();

    @Override
    public void setName(String var1);

    @Override
    @NotNull
    public IPermissions getPermissions();

    @Override
    public boolean isCoordInColony(@NotNull Level var1, @NotNull BlockPos var2);

    @Override
    public long getDistanceSquared(@NotNull BlockPos var1);

    @Override
    public boolean hasTownHall();

    @Override
    public int getID();

    @Override
    public boolean hasWarehouse();

    @Override
    public int getLastContactInHours();

    @Override
    public Level getWorld();

    @Override
    @NotNull
    public IRequestManager getRequestManager();

    @Override
    public void markDirty();

    @Override
    public boolean canBeAutoDeleted();

    @Override
    @Nullable
    public IRequester getRequesterBuildingForPosition(@NotNull BlockPos var1);

    @Override
    public void removeVisitingPlayer(Player var1);

    @Override
    public void addVisitingPlayer(Player var1);

    public List<BlockPos> getLastSpawnPoints();

    @Override
    public boolean isRemote();

    public List<IBuildingView> getBuildings();

    @Override
    public String getStructurePack();

    public boolean isRaiding();

    public boolean areSpiesEnabled();

    public ICitizenDataView getVisitor(int var1);

    public IAnimalDataView getAnimal(int var1);

    public List<String> getNameFileIds();
}

