/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.scarecrowsterritory;

import com.supermartijn642.core.block.BaseBlockEntityType;
import com.supermartijn642.core.block.BlockProperties;
import com.supermartijn642.core.block.BlockShape;
import com.supermartijn642.core.item.BaseBlockItem;
import com.supermartijn642.core.item.ItemProperties;
import com.supermartijn642.core.registry.RegistrationHandler;
import com.supermartijn642.scarecrowsterritory.ScarecrowBlock;
import com.supermartijn642.scarecrowsterritory.ScarecrowBlockEntity;
import com.supermartijn642.scarecrowsterritory.ScarecrowsTerritory;
import java.util.Arrays;
import java.util.EnumMap;
import java.util.Locale;
import java.util.Map;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;

public enum ScarecrowType {
    PRIMITIVE;

    private static final BlockShape PRIMITIVE_SHAPE;
    private static final BlockShape[] PRIMITIVE_SHAPES_BOTTOM;
    private static final BlockShape[] PRIMITIVE_SHAPES_TOP;
    public final EnumMap<DyeColor, ScarecrowBlock> blocks = new EnumMap(DyeColor.class);
    public BlockEntityType<? extends ScarecrowBlockEntity> blockEntityType;
    public final EnumMap<DyeColor, BaseBlockItem> items = new EnumMap(DyeColor.class);

    public void registerBlock(RegistrationHandler.Helper<Block> helper) {
        switch (this) {
            case PRIMITIVE: {
                Arrays.stream(DyeColor.values()).forEach(color -> this.blocks.put((DyeColor)color, new ScarecrowBlock(this, (DyeColor)color)));
            }
        }
        for (Map.Entry<DyeColor, ScarecrowBlock> entry : this.blocks.entrySet()) {
            helper.register(this.getRegistryName(entry.getKey()), (Object)entry.getValue());
        }
    }

    public void registerBlockEntityType(RegistrationHandler.Helper<BlockEntityType<?>> helper) {
        this.blockEntityType = BaseBlockEntityType.create(this::createBlockEntity, (Block[])this.blocks.values().toArray(new Block[0]));
        helper.register(this.name().toLowerCase(Locale.ROOT) + "_tile", this.blockEntityType);
    }

    public void registerItem(RegistrationHandler.Helper<Item> helper) {
        this.blocks.forEach((color, block) -> this.items.put((DyeColor)color, new BaseBlockItem((Block)block, ItemProperties.create().group((CreativeModeTab)ScarecrowsTerritory.GROUP))));
        for (Map.Entry<DyeColor, BaseBlockItem> entry : this.items.entrySet()) {
            helper.register(this.getRegistryName(entry.getKey()), (Object)entry.getValue());
        }
    }

    public String getRegistryName(DyeColor color) {
        return (color == DyeColor.PURPLE ? this.name().toLowerCase(Locale.ROOT) : color.m_41065_()) + "_scarecrow";
    }

    public BlockProperties getBlockProperties(DyeColor color) {
        switch (this) {
            case PRIMITIVE: {
                return BlockProperties.create().mapColor(color.m_284406_()).sound(SoundType.f_56745_).destroyTime(0.5f).explosionResistance(0.5f);
            }
        }
        return BlockProperties.create().air();
    }

    public BlockShape getBlockShape(Direction facing, boolean bottom) {
        switch (this) {
            case PRIMITIVE: {
                return bottom ? PRIMITIVE_SHAPES_BOTTOM[facing.m_122416_()] : PRIMITIVE_SHAPES_TOP[facing.m_122416_()];
            }
        }
        return BlockShape.empty();
    }

    public ScarecrowBlockEntity createBlockEntity(BlockPos pos, BlockState state) {
        switch (this) {
            default: 
        }
        return new ScarecrowBlockEntity(this, pos, state);
    }

    public RenderType getRenderLayer() {
        switch (this) {
            case PRIMITIVE: {
                return RenderType.m_110466_();
            }
        }
        return RenderType.m_110451_();
    }

    public boolean is2BlocksHigh() {
        return this == PRIMITIVE;
    }

    static {
        PRIMITIVE_SHAPE = BlockShape.or((BlockShape)BlockShape.createBlockShape((double)7.5, (double)0.0, (double)7.5, (double)8.5, (double)26.0, (double)8.5), (BlockShape[])new BlockShape[]{BlockShape.createBlockShape((double)4.0, (double)9.0, (double)6.0, (double)12.0, (double)22.0, (double)10.0), BlockShape.createBlockShape((double)4.0, (double)21.0, (double)4.0, (double)12.0, (double)29.0, (double)12.0)});
        PRIMITIVE_SHAPES_BOTTOM = new BlockShape[4];
        PRIMITIVE_SHAPES_TOP = new BlockShape[4];
        ScarecrowType.PRIMITIVE_SHAPES_BOTTOM[Direction.NORTH.m_122416_()] = PRIMITIVE_SHAPE;
        ScarecrowType.PRIMITIVE_SHAPES_BOTTOM[Direction.EAST.m_122416_()] = PRIMITIVE_SHAPE.rotate(Direction.Axis.Y);
        ScarecrowType.PRIMITIVE_SHAPES_BOTTOM[Direction.SOUTH.m_122416_()] = PRIMITIVE_SHAPE.rotate(Direction.Axis.Y).rotate(Direction.Axis.Y);
        ScarecrowType.PRIMITIVE_SHAPES_BOTTOM[Direction.WEST.m_122416_()] = PRIMITIVE_SHAPE.rotate(Direction.Axis.Y).rotate(Direction.Axis.Y).rotate(Direction.Axis.Y);
        for (int i = 0; i < 4; ++i) {
            ScarecrowType.PRIMITIVE_SHAPES_TOP[i] = PRIMITIVE_SHAPES_BOTTOM[i].offset(0.0, -1.0, 0.0);
        }
    }
}

