/*
 * Decompiled with CFR 0.152.
 */
package com.supermartijn642.scarecrowsterritory;

import com.supermartijn642.core.ClientUtils;
import com.supermartijn642.scarecrowsterritory.MobSpawningUtil;
import com.supermartijn642.scarecrowsterritory.ScarecrowBlock;
import com.supermartijn642.scarecrowsterritory.ScarecrowBlockEntity;
import com.supermartijn642.scarecrowsterritory.ScarecrowsTerritoryConfig;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.Difficulty;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.NaturalSpawner;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.MobSpawnEvent;
import net.minecraftforge.event.level.BlockEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ScarecrowTracker {
    private static final Map<LevelAccessor, Set<BlockPos>> SCARECROWS_PER_WORLD = new HashMap<LevelAccessor, Set<BlockPos>>();
    private static final Map<LevelAccessor, Map<ChunkPos, Integer>> CHUNKS_TO_SPAWN_MOBS = new HashMap<LevelAccessor, Map<ChunkPos, Integer>>();

    @SubscribeEvent
    public static void onEntityDespawn(MobSpawnEvent.AllowDespawn e) {
        Player entity;
        if (!ScarecrowsTerritoryConfig.passiveMobSpawning.get().booleanValue() || e.getEntity().m_9236_().f_46443_) {
            return;
        }
        Mob mob = e.getEntity();
        double range = Math.max(ScarecrowsTerritoryConfig.passiveMobRange.get(), ScarecrowsTerritoryConfig.loadSpawnerRange.get()) + ScarecrowsTerritoryConfig.noDespawnBuffer.get();
        if (ScarecrowTracker.isScarecrowInRange((LevelAccessor)mob.m_9236_(), mob.m_20182_(), range)) {
            e.setResult(Event.Result.DENY);
        } else if (mob.getPersistentData().m_128471_("spawnedByScarecrow") && (entity = mob.m_9236_().m_45930_((Entity)mob, -1.0)) == null) {
            if (mob.m_6785_(range * range)) {
                e.setResult(Event.Result.ALLOW);
            } else {
                mob.m_21310_(0);
            }
        }
    }

    @SubscribeEvent
    public static void onWorldTick(TickEvent.LevelTickEvent e) {
        Level level = e.level;
        if (!ScarecrowsTerritoryConfig.passiveMobSpawning.get().booleanValue() || level.f_46443_ || !(level instanceof ServerLevel) || level.m_46659_()) {
            return;
        }
        if (!level.m_46469_().m_46207_(GameRules.f_46134_)) {
            return;
        }
        Map<ChunkPos, Integer> chunks = CHUNKS_TO_SPAWN_MOBS.get(level);
        if (chunks != null) {
            for (Map.Entry<ChunkPos, Integer> entry : chunks.entrySet()) {
                LevelChunk chunk;
                if (entry.getValue() <= 0 || !((ServerLevel)level).m_7726_().m_143239_(entry.getKey().m_45588_()) || (chunk = level.m_7726_().m_62227_(entry.getKey().f_45578_, entry.getKey().f_45579_, false)) == null || chunk.m_6430_() || !level.m_6857_().m_61927_(entry.getKey())) continue;
                ScarecrowTracker.spawnEntitiesInChunk((ServerLevel)level, chunk);
            }
        }
    }

    private static void spawnEntitiesInChunk(ServerLevel level, LevelChunk chunk) {
        NaturalSpawner.SpawnState entityDensityManager = level.m_7726_().m_8485_();
        if (entityDensityManager != null) {
            boolean spawnAnimals = level.m_6106_().m_6793_() % 400L == 0L;
            boolean spawnHostiles = level.m_46791_() != Difficulty.PEACEFUL;
            MobSpawningUtil.spawnEntitiesInChunk(level, chunk, entityDensityManager, true, spawnHostiles, spawnAnimals);
        }
    }

    private static void addScarecrow(LevelAccessor level, BlockPos pos) {
        SCARECROWS_PER_WORLD.putIfAbsent(level, new HashSet());
        SCARECROWS_PER_WORLD.computeIfPresent(level, (w, s) -> {
            s.add(pos);
            return s;
        });
        int range = (int)Math.ceil(ScarecrowsTerritoryConfig.passiveMobRange.get());
        int minX = pos.m_123341_() - range >> 4;
        int maxX = pos.m_123341_() + range >> 4;
        int minZ = pos.m_123343_() - range >> 4;
        int maxZ = pos.m_123343_() + range >> 4;
        CHUNKS_TO_SPAWN_MOBS.putIfAbsent(level, new LinkedHashMap());
        CHUNKS_TO_SPAWN_MOBS.computeIfPresent(level, (w, s) -> {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    ChunkPos chunk = new ChunkPos(x, z);
                    s.putIfAbsent(chunk, 0);
                    s.computeIfPresent(chunk, (c, i) -> i + 1);
                }
            }
            return s;
        });
    }

    private static void removeScarecrow(LevelAccessor level, BlockPos pos) {
        SCARECROWS_PER_WORLD.computeIfPresent(level, (w, s) -> {
            s.remove(pos);
            return s;
        });
        int range = (int)Math.ceil(ScarecrowsTerritoryConfig.passiveMobRange.get());
        int minX = pos.m_123341_() - range >> 4;
        int maxX = pos.m_123341_() + range >> 4;
        int minZ = pos.m_123343_() - range >> 4;
        int maxZ = pos.m_123343_() + range >> 4;
        CHUNKS_TO_SPAWN_MOBS.computeIfPresent(level, (w, s) -> {
            for (int x = minX; x <= maxX; ++x) {
                for (int z = minZ; z <= maxZ; ++z) {
                    ChunkPos chunk = new ChunkPos(x, z);
                    if (s.containsKey(chunk) && (Integer)s.get(chunk) == 1) {
                        s.remove(chunk);
                        continue;
                    }
                    s.computeIfPresent(chunk, (c, i) -> Math.max(i - 1, 0));
                }
            }
            return s;
        });
    }

    @SubscribeEvent
    public static void onWorldUnload(LevelEvent.Unload e) {
        SCARECROWS_PER_WORLD.remove(e.getLevel());
    }

    @SubscribeEvent
    public static void onChunkLoad(ChunkEvent.Load e) {
        ChunkAccess chunk = e.getChunk();
        Runnable task = () -> {
            for (BlockPos pos : chunk.m_5928_()) {
                if (!(chunk.m_7702_(pos) instanceof ScarecrowBlockEntity)) continue;
                ScarecrowTracker.addScarecrow(e.getLevel(), pos);
            }
        };
        if (e.getLevel().m_5776_()) {
            ClientUtils.queueTask((Runnable)task);
        } else {
            e.getLevel().m_7654_().m_6937_((Runnable)new TickTask(0, task));
        }
    }

    @SubscribeEvent
    public static void onChunkUnload(ChunkEvent.Unload e) {
        ChunkAccess chunk = e.getChunk();
        for (BlockPos pos : chunk.m_5928_()) {
            if (!(chunk.m_7702_(pos) instanceof ScarecrowBlockEntity)) continue;
            ScarecrowTracker.removeScarecrow(e.getLevel(), pos);
        }
    }

    @SubscribeEvent
    public static void onBlockAdded(BlockEvent.EntityPlaceEvent e) {
        if (e.getPlacedBlock().m_60734_() instanceof ScarecrowBlock) {
            ScarecrowTracker.addScarecrow(e.getLevel(), e.getPos());
            boolean bottom = (Boolean)e.getPlacedBlock().m_61143_((Property)ScarecrowBlock.BOTTOM);
            BlockPos otherHalf = bottom ? e.getPos().m_7494_() : e.getPos().m_7495_();
            BlockState state = e.getLevel().m_8055_(otherHalf);
            if (state.m_60734_() instanceof ScarecrowBlock && (Boolean)state.m_61143_((Property)ScarecrowBlock.BOTTOM) != bottom) {
                ScarecrowTracker.addScarecrow(e.getLevel(), otherHalf);
            }
        }
    }

    @SubscribeEvent
    public static void onBlockBreak(BlockEvent.BreakEvent e) {
        if (e.getState().m_60734_() instanceof ScarecrowBlock) {
            ScarecrowTracker.removeScarecrow(e.getLevel(), e.getPos());
            boolean bottom = (Boolean)e.getState().m_61143_((Property)ScarecrowBlock.BOTTOM);
            BlockPos otherHalf = bottom ? e.getPos().m_7494_() : e.getPos().m_7495_();
            BlockState state = e.getLevel().m_8055_(otherHalf);
            if (state.m_60734_() instanceof ScarecrowBlock && (Boolean)state.m_61143_((Property)ScarecrowBlock.BOTTOM) != bottom) {
                ScarecrowTracker.removeScarecrow(e.getLevel(), otherHalf);
            }
        }
    }

    public static boolean isScarecrowInRange(LevelAccessor level, Vec3 pos, double range) {
        Set scarecrows = SCARECROWS_PER_WORLD.getOrDefault(level, Collections.emptySet());
        for (BlockPos scarecrow : scarecrows) {
            Vec3 center = Vec3.m_82512_((Vec3i)scarecrow);
            if (!(Math.abs(center.f_82479_ - pos.f_82479_) <= range) || !(Math.abs(center.f_82480_ - pos.f_82480_) <= range) || !(Math.abs(center.f_82481_ - pos.f_82481_) <= range)) continue;
            return true;
        }
        return false;
    }

    public static BlockPos getClosestScarecrow(Level level, BlockPos pos) {
        Set scarecrows = SCARECROWS_PER_WORLD.getOrDefault(level, Collections.emptySet());
        BlockPos closestPos = null;
        double closest = Double.MAX_VALUE;
        for (BlockPos scarecrow : scarecrows) {
            double distance = scarecrow.m_123331_((Vec3i)pos);
            if (!(distance < closest) && closestPos != null) continue;
            closestPos = scarecrow;
            closest = distance;
        }
        return closestPos;
    }

    public static Set<BlockPos> getScarecrows(Level level) {
        return SCARECROWS_PER_WORLD.getOrDefault(level, Collections.emptySet());
    }
}

