/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.pipe.modules.modifier;

import com.mojang.blaze3d.systems.RenderSystem;
import de.ellpeck.prettypipes.packets.PacketButton;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeGui;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleItem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.client.resources.sounds.SimpleSoundInstance;
import net.minecraft.client.resources.sounds.SoundInstance;
import net.minecraft.core.Holder;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Inventory;

public class FilterModifierModuleGui
extends AbstractPipeGui<FilterModifierModuleContainer> {
    private int scrollOffset;
    private boolean isScrolling;
    private List<ResourceLocation> tags;
    private final List<Tag> tagButtons = new ArrayList<Tag>();

    public FilterModifierModuleGui(FilterModifierModuleContainer screenContainer, Inventory inv, Component titleIn) {
        super(screenContainer, inv, titleIn);
    }

    @Override
    protected void m_7286_(GuiGraphics graphics, float partialTicks, int mouseX, int mouseY) {
        super.m_7286_(graphics, partialTicks, mouseX, mouseY);
        graphics.m_280218_(AbstractPipeGui.TEXTURE, this.f_97735_ + 7, this.f_97736_ + 32 + 15, 0, 196, 162, 60);
        for (Tag tag : this.tagButtons) {
            tag.draw(graphics, mouseX, mouseY);
        }
        if (this.tags.size() >= 6) {
            float percentage = (float)this.scrollOffset / (float)(this.tags.size() - 5);
            graphics.m_280218_(AbstractPipeGui.TEXTURE, this.f_97735_ + 156, this.f_97736_ + 32 + 16 + (int)(percentage * 43.0f), 232, 241, 12, 15);
        } else {
            graphics.m_280218_(AbstractPipeGui.TEXTURE, this.f_97735_ + 156, this.f_97736_ + 32 + 16, 244, 241, 12, 15);
        }
    }

    @Override
    protected void m_7856_() {
        super.m_7856_();
        this.tags = ((FilterModifierModuleContainer)this.f_97732_).getTags();
        this.updateWidgets();
    }

    @Override
    public boolean m_6375_(double mouseX, double mouseY, int button) {
        for (Tag tag : this.tagButtons) {
            if (!tag.onClicked(mouseX, mouseY, button)) continue;
            return true;
        }
        if (button == 0 && mouseX >= (double)(this.f_97735_ + 156) && (double)this.f_97736_ + mouseY >= 48.0 && mouseX < (double)(this.f_97735_ + 156 + 12) && mouseY < (double)(this.f_97736_ + 32 + 16 + 58)) {
            this.isScrolling = true;
            return true;
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        if (button == 0) {
            this.isScrolling = false;
        }
        return super.m_6348_(mouseX, mouseY, button);
    }

    public boolean m_7979_(double mouseX, double mouseY, int i, double j, double k) {
        if (this.isScrolling) {
            float percentage = Mth.m_14036_((float)(((float)mouseY - (float)(this.f_97736_ + 32 + 18)) / 43.0f), (float)0.0f, (float)1.0f);
            int offset = Math.max(0, (int)(percentage * (float)(this.tags.size() - 5)));
            if (offset != this.scrollOffset) {
                this.scrollOffset = offset;
                this.updateWidgets();
            }
            return true;
        }
        return super.m_7979_(mouseX, mouseY, i, j, k);
    }

    public boolean m_6050_(double x, double y, double scroll) {
        int offset;
        if (this.tags.size() >= 6 && (offset = Mth.m_14045_((int)(this.scrollOffset - (int)Math.signum(scroll)), (int)0, (int)(this.tags.size() - 5))) != this.scrollOffset) {
            this.scrollOffset = offset;
            this.updateWidgets();
        }
        return true;
    }

    private void updateWidgets() {
        this.tagButtons.clear();
        for (int i = 0; i < 5 && i < this.tags.size(); ++i) {
            this.tagButtons.add(new Tag(this.tags.get(this.scrollOffset + i), this.f_97735_ + 10, this.f_97736_ + 32 + 17 + i * 12));
        }
    }

    private class Tag {
        private final ResourceLocation tag;
        private final int x;
        private final int y;

        public Tag(ResourceLocation tag, int x, int y) {
            this.tag = tag;
            this.x = x;
            this.y = y;
        }

        private void draw(GuiGraphics graphics, double mouseX, double mouseY) {
            int color = 0x404040;
            Object text = this.tag.toString();
            if (mouseX >= (double)this.x && mouseY >= (double)this.y && mouseX < (double)(this.x + 140) && mouseY < (double)(this.y + 12)) {
                color = 0xFFFFFF;
            }
            if (this.tag.equals((Object)FilterModifierModuleItem.getFilterTag(((FilterModifierModuleContainer)((FilterModifierModuleGui)FilterModifierModuleGui.this).f_97732_).moduleStack))) {
                text = ChatFormatting.BOLD + (String)text;
            }
            graphics.m_280056_(FilterModifierModuleGui.this.f_96547_, (String)text, this.x, this.y, color, false);
            RenderSystem.setShader(GameRenderer::m_172817_);
            RenderSystem.setShaderTexture((int)0, (ResourceLocation)TEXTURE);
        }

        private boolean onClicked(double mouseX, double mouseY, int button) {
            if (button != 0) {
                return false;
            }
            if (mouseX < (double)this.x || mouseY < (double)this.y || mouseX >= (double)(this.x + 140) || mouseY >= (double)(this.y + 12)) {
                return false;
            }
            PacketButton.sendAndExecute(((FilterModifierModuleContainer)((FilterModifierModuleGui)FilterModifierModuleGui.this).f_97732_).tile.m_58899_(), PacketButton.ButtonResult.TAG_FILTER, FilterModifierModuleGui.this.tags.indexOf(this.tag));
            FilterModifierModuleGui.this.getMinecraft().m_91106_().m_120367_((SoundInstance)SimpleSoundInstance.m_263171_((Holder)SoundEvents.f_12490_, (float)1.0f));
            return true;
        }
    }
}

