/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes.packets;

import com.google.common.collect.Streams;
import com.mojang.datafixers.util.Pair;
import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderSet;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.NetworkEvent;

public class PacketGhostSlot {
    private BlockPos pos;
    private List<Entry> stacks;

    public PacketGhostSlot(BlockPos pos, List<Entry> stacks) {
        this.pos = pos;
        this.stacks = stacks;
    }

    private PacketGhostSlot() {
    }

    public static PacketGhostSlot fromBytes(FriendlyByteBuf buf) {
        PacketGhostSlot packet = new PacketGhostSlot();
        packet.pos = buf.m_130135_();
        packet.stacks = new ArrayList<Entry>();
        for (int i = buf.readInt(); i > 0; --i) {
            packet.stacks.add(new Entry(buf));
        }
        return packet;
    }

    public static void toBytes(PacketGhostSlot packet, FriendlyByteBuf buf) {
        buf.m_130064_(packet.pos);
        buf.writeInt(packet.stacks.size());
        for (Entry entry : packet.stacks) {
            entry.write(buf);
        }
    }

    public static void onMessage(PacketGhostSlot message, Supplier<NetworkEvent.Context> ctx) {
        final Consumer<Player> doIt = p -> {
            CraftingTerminalBlockEntity tile = Utility.getBlockEntity(CraftingTerminalBlockEntity.class, (BlockGetter)p.m_9236_(), message.pos);
            if (tile != null) {
                tile.setGhostItems(message.stacks);
            }
        };
        ServerPlayer player = ctx.get().getSender();
        if (player == null) {
            ctx.get().enqueueWork(new Runnable(){

                @Override
                public void run() {
                    doIt.accept(Minecraft.m_91087_().f_91074_);
                }
            });
        } else {
            ctx.get().enqueueWork(new Runnable(){
                final /* synthetic */ Player val$player;
                {
                    this.val$player = player;
                }

                @Override
                public void run() {
                    doIt.accept(this.val$player);
                }
            });
        }
        ctx.get().setPacketHandled(true);
    }

    public static class Entry {
        private final List<ItemStack> stacks;
        private final TagKey<Item> tag;

        public Entry(Level level, List<ItemStack> stacks) {
            TagKey<Item> tag = Entry.getTagForStacks(level, stacks);
            if (tag != null) {
                this.stacks = null;
                this.tag = tag;
            } else {
                this.stacks = stacks;
                this.tag = null;
            }
        }

        public Entry(FriendlyByteBuf buf) {
            if (buf.readBoolean()) {
                this.tag = null;
                this.stacks = new ArrayList<ItemStack>();
                for (int i = buf.readInt(); i > 0; --i) {
                    this.stacks.add(buf.m_130267_());
                }
            } else {
                this.stacks = null;
                this.tag = TagKey.m_203882_((ResourceKey)Registries.f_256913_, (ResourceLocation)new ResourceLocation(buf.m_130277_()));
            }
        }

        public List<ItemStack> getStacks(Level level) {
            if (this.stacks != null) {
                return this.stacks;
            }
            return Streams.stream(((Registry)level.m_9598_().m_6632_(Registries.f_256913_).get()).m_206058_(this.tag).iterator()).filter(h -> h.m_203334_() != null & h.m_203334_() != Items.f_41852_).map(h -> new ItemStack((ItemLike)h.m_203334_())).collect(Collectors.toList());
        }

        public FriendlyByteBuf write(FriendlyByteBuf buf) {
            if (this.stacks != null) {
                buf.writeBoolean(true);
                buf.writeInt(this.stacks.size());
                for (ItemStack stack : this.stacks) {
                    buf.m_130055_(stack);
                }
            } else {
                buf.writeBoolean(false);
                buf.m_130070_(this.tag.f_203868_().toString());
            }
            return buf;
        }

        private static TagKey<Item> getTagForStacks(Level level, List<ItemStack> stacks) {
            return ((Registry)level.m_9598_().m_6632_(Registries.f_256913_).get()).m_203612_().filter(e -> {
                HolderSet.Named tag = (HolderSet.Named)e.getSecond();
                if (tag.m_203632_() != stacks.size()) {
                    return false;
                }
                for (int i = 0; i < tag.m_203632_(); ++i) {
                    if (((ItemStack)stacks.get(i)).m_41720_() == tag.m_203662_(i).m_203334_()) continue;
                    return false;
                }
                return true;
            }).map(Pair::getFirst).findFirst().orElse(null);
        }
    }
}

