/*
 * Decompiled with CFR 0.152.
 */
package de.ellpeck.prettypipes;

import de.ellpeck.prettypipes.Utility;
import de.ellpeck.prettypipes.entities.PipeFrameEntity;
import de.ellpeck.prettypipes.entities.PipeFrameRenderer;
import de.ellpeck.prettypipes.items.IModule;
import de.ellpeck.prettypipes.items.ModuleItem;
import de.ellpeck.prettypipes.items.ModuleTier;
import de.ellpeck.prettypipes.items.PipeFrameItem;
import de.ellpeck.prettypipes.items.WrenchItem;
import de.ellpeck.prettypipes.misc.ItemEquality;
import de.ellpeck.prettypipes.misc.ModuleClearingRecipe;
import de.ellpeck.prettypipes.network.PipeNetwork;
import de.ellpeck.prettypipes.packets.PacketHandler;
import de.ellpeck.prettypipes.pipe.IPipeConnectable;
import de.ellpeck.prettypipes.pipe.PipeBlock;
import de.ellpeck.prettypipes.pipe.PipeBlockEntity;
import de.ellpeck.prettypipes.pipe.PipeRenderer;
import de.ellpeck.prettypipes.pipe.containers.AbstractPipeContainer;
import de.ellpeck.prettypipes.pipe.containers.MainPipeContainer;
import de.ellpeck.prettypipes.pipe.containers.MainPipeGui;
import de.ellpeck.prettypipes.pipe.modules.HighPriorityModuleItem;
import de.ellpeck.prettypipes.pipe.modules.LowPriorityModuleItem;
import de.ellpeck.prettypipes.pipe.modules.RedstoneModuleItem;
import de.ellpeck.prettypipes.pipe.modules.SortingModuleItem;
import de.ellpeck.prettypipes.pipe.modules.SpeedModuleItem;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleGui;
import de.ellpeck.prettypipes.pipe.modules.craft.CraftingModuleItem;
import de.ellpeck.prettypipes.pipe.modules.extraction.ExtractionModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.extraction.ExtractionModuleGui;
import de.ellpeck.prettypipes.pipe.modules.extraction.ExtractionModuleItem;
import de.ellpeck.prettypipes.pipe.modules.filter.FilterIncreaseModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.filter.FilterIncreaseModuleGui;
import de.ellpeck.prettypipes.pipe.modules.filter.FilterIncreaseModuleItem;
import de.ellpeck.prettypipes.pipe.modules.insertion.FilterModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.insertion.FilterModuleGui;
import de.ellpeck.prettypipes.pipe.modules.insertion.FilterModuleItem;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleGui;
import de.ellpeck.prettypipes.pipe.modules.modifier.FilterModifierModuleItem;
import de.ellpeck.prettypipes.pipe.modules.retrieval.RetrievalModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.retrieval.RetrievalModuleGui;
import de.ellpeck.prettypipes.pipe.modules.retrieval.RetrievalModuleItem;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleContainer;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleGui;
import de.ellpeck.prettypipes.pipe.modules.stacksize.StackSizeModuleItem;
import de.ellpeck.prettypipes.pressurizer.PressurizerBlock;
import de.ellpeck.prettypipes.pressurizer.PressurizerBlockEntity;
import de.ellpeck.prettypipes.pressurizer.PressurizerContainer;
import de.ellpeck.prettypipes.pressurizer.PressurizerGui;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlock;
import de.ellpeck.prettypipes.terminal.CraftingTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlock;
import de.ellpeck.prettypipes.terminal.ItemTerminalBlockEntity;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.CraftingTerminalGui;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalContainer;
import de.ellpeck.prettypipes.terminal.containers.ItemTerminalGui;
import java.util.Comparator;
import java.util.Locale;
import java.util.function.BiFunction;
import net.minecraft.client.gui.screens.MenuScreens;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderers;
import net.minecraft.client.renderer.entity.EntityRenderers;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.extensions.IForgeMenuType;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegisterEvent;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public final class Registry {
    public static Capability<PipeNetwork> pipeNetworkCapability = CapabilityManager.get((CapabilityToken)new CapabilityToken<PipeNetwork>(){});
    public static Capability<IPipeConnectable> pipeConnectableCapability = CapabilityManager.get((CapabilityToken)new CapabilityToken<IPipeConnectable>(){});
    public static Item wrenchItem;
    public static Item pipeFrameItem;
    public static Block pipeBlock;
    public static BlockEntityType<PipeBlockEntity> pipeBlockEntity;
    public static MenuType<MainPipeContainer> pipeContainer;
    public static Block itemTerminalBlock;
    public static BlockEntityType<ItemTerminalBlockEntity> itemTerminalBlockEntity;
    public static MenuType<ItemTerminalContainer> itemTerminalContainer;
    public static Block craftingTerminalBlock;
    public static BlockEntityType<CraftingTerminalBlockEntity> craftingTerminalBlockEntity;
    public static MenuType<CraftingTerminalContainer> craftingTerminalContainer;
    public static EntityType<PipeFrameEntity> pipeFrameEntity;
    public static Block pressurizerBlock;
    public static BlockEntityType<PressurizerBlockEntity> pressurizerBlockEntity;
    public static MenuType<PressurizerContainer> pressurizerContainer;
    public static MenuType<ExtractionModuleContainer> extractionModuleContainer;
    public static MenuType<FilterModuleContainer> filterModuleContainer;
    public static MenuType<RetrievalModuleContainer> retrievalModuleContainer;
    public static MenuType<StackSizeModuleContainer> stackSizeModuleContainer;
    public static MenuType<FilterIncreaseModuleContainer> filterIncreaseModuleContainer;
    public static MenuType<CraftingModuleContainer> craftingModuleContainer;
    public static MenuType<FilterModifierModuleContainer> filterModifierModuleContainer;

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        event.register(ForgeRegistries.Keys.BLOCKS, h -> {
            pipeBlock = new PipeBlock();
            h.register(new ResourceLocation("prettypipes", "pipe"), (Object)pipeBlock);
            itemTerminalBlock = new ItemTerminalBlock();
            h.register(new ResourceLocation("prettypipes", "item_terminal"), (Object)itemTerminalBlock);
            craftingTerminalBlock = new CraftingTerminalBlock();
            h.register(new ResourceLocation("prettypipes", "crafting_terminal"), (Object)craftingTerminalBlock);
            pressurizerBlock = new PressurizerBlock();
            h.register(new ResourceLocation("prettypipes", "pressurizer"), (Object)pressurizerBlock);
        });
        event.register(ForgeRegistries.Keys.ITEMS, h -> {
            String name;
            wrenchItem = new WrenchItem();
            h.register(new ResourceLocation("prettypipes", "wrench"), (Object)wrenchItem);
            h.register(new ResourceLocation("prettypipes", "blank_module"), (Object)new Item(new Item.Properties()));
            pipeFrameItem = new PipeFrameItem();
            h.register(new ResourceLocation("prettypipes", "pipe_frame"), (Object)pipeFrameItem);
            h.register(new ResourceLocation("prettypipes", "stack_size_module"), (Object)new StackSizeModuleItem());
            h.register(new ResourceLocation("prettypipes", "redstone_module"), (Object)new RedstoneModuleItem());
            h.register(new ResourceLocation("prettypipes", "filter_increase_modifier"), (Object)new FilterIncreaseModuleItem());
            Registry.registerTieredModule((RegisterEvent.RegisterHelper<Item>)h, "extraction_module", ExtractionModuleItem::new);
            Registry.registerTieredModule((RegisterEvent.RegisterHelper<Item>)h, "filter_module", FilterModuleItem::new);
            Registry.registerTieredModule((RegisterEvent.RegisterHelper<Item>)h, "speed_module", SpeedModuleItem::new);
            Registry.registerTieredModule((RegisterEvent.RegisterHelper<Item>)h, "low_priority_module", LowPriorityModuleItem::new);
            Registry.registerTieredModule((RegisterEvent.RegisterHelper<Item>)h, "high_priority_module", HighPriorityModuleItem::new);
            Registry.registerTieredModule((RegisterEvent.RegisterHelper<Item>)h, "retrieval_module", RetrievalModuleItem::new);
            Registry.registerTieredModule((RegisterEvent.RegisterHelper<Item>)h, "crafting_module", CraftingModuleItem::new);
            for (ItemEquality.Type type : ItemEquality.Type.values()) {
                name = type.name().toLowerCase(Locale.ROOT) + "_filter_modifier";
                h.register(new ResourceLocation("prettypipes", name), (Object)new FilterModifierModuleItem(name, type));
            }
            for (Enum enum_ : SortingModuleItem.Type.values()) {
                name = enum_.name().toLowerCase(Locale.ROOT) + "_sorting_modifier";
                h.register(new ResourceLocation("prettypipes", name), (Object)new SortingModuleItem(name, (SortingModuleItem.Type)enum_));
            }
            ForgeRegistries.BLOCKS.getEntries().stream().filter(b -> ((ResourceKey)b.getKey()).m_135782_().m_135827_().equals("prettypipes")).forEach(b -> h.register(((ResourceKey)b.getKey()).m_135782_(), (Object)new BlockItem((Block)b.getValue(), new Item.Properties())));
        });
        event.register(ForgeRegistries.Keys.BLOCK_ENTITY_TYPES, h -> {
            pipeBlockEntity = BlockEntityType.Builder.m_155273_(PipeBlockEntity::new, (Block[])new Block[]{pipeBlock}).m_58966_(null);
            h.register(new ResourceLocation("prettypipes", "pipe"), (Object)pipeBlockEntity);
            itemTerminalBlockEntity = BlockEntityType.Builder.m_155273_(ItemTerminalBlockEntity::new, (Block[])new Block[]{itemTerminalBlock}).m_58966_(null);
            h.register(new ResourceLocation("prettypipes", "item_terminal"), (Object)itemTerminalBlockEntity);
            craftingTerminalBlockEntity = BlockEntityType.Builder.m_155273_(CraftingTerminalBlockEntity::new, (Block[])new Block[]{craftingTerminalBlock}).m_58966_(null);
            h.register(new ResourceLocation("prettypipes", "crafting_terminal"), (Object)craftingTerminalBlockEntity);
            pressurizerBlockEntity = BlockEntityType.Builder.m_155273_(PressurizerBlockEntity::new, (Block[])new Block[]{pressurizerBlock}).m_58966_(null);
            h.register(new ResourceLocation("prettypipes", "pressurizer"), (Object)pressurizerBlockEntity);
        });
        event.register(ForgeRegistries.Keys.ENTITY_TYPES, h -> {
            pipeFrameEntity = EntityType.Builder.m_20704_(PipeFrameEntity::new, (MobCategory)MobCategory.MISC).m_20712_("pipe_frame");
            h.register(new ResourceLocation("prettypipes", "pipe_frame"), (Object)pipeFrameEntity);
        });
        event.register(ForgeRegistries.Keys.MENU_TYPES, h -> {
            pipeContainer = IForgeMenuType.create((windowId, inv, data) -> new MainPipeContainer(pipeContainer, windowId, inv.f_35978_, data.m_130135_()));
            h.register(new ResourceLocation("prettypipes", "pipe"), (Object)pipeContainer);
            itemTerminalContainer = IForgeMenuType.create((windowId, inv, data) -> new ItemTerminalContainer(itemTerminalContainer, windowId, inv.f_35978_, data.m_130135_()));
            h.register(new ResourceLocation("prettypipes", "item_terminal"), (Object)itemTerminalContainer);
            craftingTerminalContainer = IForgeMenuType.create((windowId, inv, data) -> new CraftingTerminalContainer(craftingTerminalContainer, windowId, inv.f_35978_, data.m_130135_()));
            h.register(new ResourceLocation("prettypipes", "crafting_terminal"), (Object)craftingTerminalContainer);
            pressurizerContainer = IForgeMenuType.create((windowId, inv, data) -> new PressurizerContainer(pressurizerContainer, windowId, inv.f_35978_, data.m_130135_()));
            h.register(new ResourceLocation("prettypipes", "pressurizer"), (Object)pressurizerContainer);
            extractionModuleContainer = Registry.registerPipeContainer(h, "extraction_module");
            filterModuleContainer = Registry.registerPipeContainer(h, "filter_module");
            retrievalModuleContainer = Registry.registerPipeContainer(h, "retrieval_module");
            stackSizeModuleContainer = Registry.registerPipeContainer(h, "stack_size_module");
            filterIncreaseModuleContainer = Registry.registerPipeContainer(h, "filter_increase_module");
            craftingModuleContainer = Registry.registerPipeContainer(h, "crafting_module");
            filterModifierModuleContainer = Registry.registerPipeContainer(h, "filter_modifier_module");
        });
        event.register(BuiltInRegistries.f_279662_.m_123023_(), h -> h.register(new ResourceLocation("prettypipes", "tab"), (Object)CreativeModeTab.builder().m_257941_((Component)Component.m_237115_((String)"item_group.prettypipes.tab")).m_257737_(() -> new ItemStack((ItemLike)wrenchItem)).m_257501_((params, output) -> ForgeRegistries.ITEMS.getEntries().stream().filter(b -> ((ResourceKey)b.getKey()).m_135782_().m_135827_().equals("prettypipes")).sorted(Comparator.comparing(b -> ((Item)b.getValue()).getClass().getSimpleName())).forEach(b -> output.m_246326_((ItemLike)b.getValue()))).m_257652_()));
        event.register(ForgeRegistries.Keys.RECIPE_SERIALIZERS, h -> h.register(new ResourceLocation("prettypipes", "module_clearing"), ModuleClearingRecipe.SERIALIZER));
    }

    private static <T extends AbstractPipeContainer<?>> MenuType<T> registerPipeContainer(RegisterEvent.RegisterHelper<MenuType<?>> helper, String name) {
        MenuType type = IForgeMenuType.create((windowId, inv, data) -> {
            PipeBlockEntity tile = Utility.getBlockEntity(PipeBlockEntity.class, (BlockGetter)inv.f_35978_.m_9236_(), data.m_130135_());
            int moduleIndex = data.readInt();
            ItemStack moduleStack = tile.modules.getStackInSlot(moduleIndex);
            return ((IModule)moduleStack.m_41720_()).getContainer(moduleStack, tile, windowId, inv, inv.f_35978_, moduleIndex);
        });
        helper.register(new ResourceLocation("prettypipes", name), (Object)type);
        return type;
    }

    private static void registerTieredModule(RegisterEvent.RegisterHelper<Item> helper, String name, BiFunction<String, ModuleTier, ModuleItem> item) {
        for (ModuleTier tier : ModuleTier.values()) {
            helper.register(new ResourceLocation("prettypipes", tier.name().toLowerCase(Locale.ROOT) + "_" + name), (Object)item.apply(name, tier));
        }
    }

    public static void setup(FMLCommonSetupEvent event) {
        PacketHandler.setup();
    }

    public static final class Client {
        public static void setup(FMLClientSetupEvent event) {
            BlockEntityRenderers.m_173590_(pipeBlockEntity, PipeRenderer::new);
            EntityRenderers.m_174036_(pipeFrameEntity, PipeFrameRenderer::new);
            MenuScreens.m_96206_(pipeContainer, MainPipeGui::new);
            MenuScreens.m_96206_(itemTerminalContainer, ItemTerminalGui::new);
            MenuScreens.m_96206_(pressurizerContainer, PressurizerGui::new);
            MenuScreens.m_96206_(craftingTerminalContainer, CraftingTerminalGui::new);
            MenuScreens.m_96206_(extractionModuleContainer, ExtractionModuleGui::new);
            MenuScreens.m_96206_(filterModuleContainer, FilterModuleGui::new);
            MenuScreens.m_96206_(retrievalModuleContainer, RetrievalModuleGui::new);
            MenuScreens.m_96206_(stackSizeModuleContainer, StackSizeModuleGui::new);
            MenuScreens.m_96206_(filterIncreaseModuleContainer, FilterIncreaseModuleGui::new);
            MenuScreens.m_96206_(craftingModuleContainer, CraftingModuleGui::new);
            MenuScreens.m_96206_(filterModifierModuleContainer, FilterModifierModuleGui::new);
        }
    }
}

