/*
 * Decompiled with CFR 0.152.
 */
package org.cyclops.integratedcrafting.core;

import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import org.cyclops.commoncapabilities.api.ingredient.IngredientComponent;
import org.cyclops.cyclopscore.datastructure.MultitransformIterator;
import org.cyclops.cyclopscore.ingredient.collection.IIngredientMapMutable;
import org.cyclops.cyclopscore.ingredient.collection.IngredientHashMap;
import org.cyclops.integratedcrafting.api.crafting.CraftingJob;
import org.cyclops.integratedcrafting.api.recipe.ICraftingJobIndexModifiable;

public class CraftingJobIndexDefault
implements ICraftingJobIndexModifiable {
    private final Map<IngredientComponent<?, ?>, IIngredientMapMutable<?, ?, Collection<CraftingJob>>> recipeComponentIndexes = Maps.newIdentityHashMap();
    private final Int2ObjectMap<CraftingJob> craftingJobs = new Int2ObjectOpenHashMap();

    @Override
    public Collection<CraftingJob> getCraftingJobs() {
        return Collections.unmodifiableCollection(this.craftingJobs.values());
    }

    @Override
    public <T, M> Iterator<CraftingJob> getCraftingJobs(IngredientComponent<T, M> outputType, T output, M matchCondition) {
        IIngredientMapMutable<?, ?, Collection<CraftingJob>> index = this.recipeComponentIndexes.get(outputType);
        if (index == null) {
            return Iterators.forArray((Object[])new CraftingJob[0]);
        }
        return MultitransformIterator.flattenIterableIterator((Iterator)Iterators.transform((Iterator)index.iterator(output, matchCondition), entry -> (Collection)entry.getValue()));
    }

    @Override
    @Nullable
    public CraftingJob getCraftingJob(int craftingJobId) {
        return (CraftingJob)this.craftingJobs.get(craftingJobId);
    }

    @Nullable
    protected <T, M> IIngredientMapMutable<T, M, Collection<CraftingJob>> initializeIndex(IngredientComponent<T, M> recipeComponent) {
        return new IngredientHashMap(recipeComponent);
    }

    @Override
    public void addCraftingJob(CraftingJob craftingJob) {
        this.craftingJobs.put(craftingJob.getId(), (Object)craftingJob);
        for (IngredientComponent recipeComponent : craftingJob.getRecipe().getOutput().getComponents()) {
            IIngredientMapMutable index = this.recipeComponentIndexes.computeIfAbsent(recipeComponent, this::initializeIndex);
            if (index == null) continue;
            this.addCraftingJobForComponent(index, craftingJob);
        }
    }

    protected <T, M> void addCraftingJobForComponent(IIngredientMapMutable<T, M, Collection<CraftingJob>> index, CraftingJob craftingJob) {
        for (Object instance : craftingJob.getRecipe().getOutput().getInstances(index.getComponent())) {
            Collection set = (Collection)index.get(instance);
            if (set == null) {
                set = Sets.newIdentityHashSet();
                index.put(instance, (Object)set);
            }
            set.add(craftingJob);
        }
    }

    @Override
    public void removeCraftingJob(CraftingJob craftingJob) {
        this.craftingJobs.remove(craftingJob.getId());
        for (IngredientComponent recipeComponent : craftingJob.getRecipe().getOutput().getComponents()) {
            IIngredientMapMutable<?, ?, Collection<CraftingJob>> index = this.recipeComponentIndexes.get(recipeComponent);
            if (index == null) continue;
            this.removeCraftingJobForComponent(index, craftingJob);
        }
    }

    protected <T, M> void removeCraftingJobForComponent(IIngredientMapMutable<T, M, Collection<CraftingJob>> index, CraftingJob craftingJob) {
        for (Object instance : craftingJob.getRecipe().getOutput().getInstances(index.getComponent())) {
            Collection set = (Collection)index.get(instance);
            if (set == null || !set.remove(craftingJob) || !set.isEmpty()) continue;
            index.remove(instance);
        }
    }
}

