/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.impl.capability.v3;

import fuzs.puzzleslib.api.capability.v3.data.CapabilityComponent;
import fuzs.puzzleslib.api.capability.v3.data.CopyStrategy;
import fuzs.puzzleslib.api.capability.v3.data.EntityCapabilityKey;
import fuzs.puzzleslib.api.capability.v3.data.SyncStrategy;
import fuzs.puzzleslib.api.event.v1.entity.living.LivingConversionCallback;
import fuzs.puzzleslib.api.event.v1.entity.player.PlayerEvents;
import fuzs.puzzleslib.api.network.v3.PlayerSet;
import java.util.Optional;
import net.minecraft.world.entity.Entity;

public interface EntityCapabilityKeyImpl<T extends Entity, C extends CapabilityComponent<T>>
extends EntityCapabilityKey.Mutable<T, C> {
    @Override
    default public EntityCapabilityKey.Mutable<T, C> setSyncStrategy(SyncStrategy syncStrategy) {
        if (this.getSyncStrategy() != SyncStrategy.MANUAL) {
            throw new IllegalStateException("Sync strategy has already been set!");
        }
        if (syncStrategy != SyncStrategy.MANUAL) {
            PlayerEvents.LOGGED_IN.register(serverPlayer -> this.getIfProvided(serverPlayer).ifPresent(capabilityComponent -> capabilityComponent.setChanged(PlayerSet.ofPlayer(serverPlayer))));
            PlayerEvents.AFTER_CHANGE_DIMENSION.register((serverPlayer, from, to) -> this.getIfProvided(serverPlayer).ifPresent(capabilityComponent -> capabilityComponent.setChanged(PlayerSet.ofPlayer(serverPlayer))));
            PlayerEvents.RESPAWN.register((serverPlayer, originalStillAlive) -> this.getIfProvided(serverPlayer).ifPresent(capabilityComponent -> capabilityComponent.setChanged(PlayerSet.ofPlayer(serverPlayer))));
            if (syncStrategy == SyncStrategy.TRACKING) {
                PlayerEvents.START_TRACKING.register((trackedEntity, serverPlayer) -> this.getIfProvided(trackedEntity).ifPresent(capabilityComponent -> capabilityComponent.setChanged(PlayerSet.ofPlayer(serverPlayer))));
            }
        }
        return this;
    }

    @Override
    default public EntityCapabilityKey.Mutable<T, C> setCopyStrategy(CopyStrategy copyStrategy) {
        if (this.getCopyStrategy() != CopyStrategy.NEVER) {
            throw new IllegalStateException("Copy strategy has already been set!");
        }
        if (copyStrategy == CopyStrategy.ALWAYS) {
            LivingConversionCallback.EVENT.register((originalEntity, newEntity) -> {
                Optional originalCapability = this.getIfProvided(originalEntity);
                Optional newCapability = this.getIfProvided(newEntity);
                if (originalCapability.isPresent() && newCapability.isPresent()) {
                    this.getCopyStrategy().copy((Entity)originalEntity, (CapabilityComponent)originalCapability.get(), (Entity)newEntity, (CapabilityComponent)newCapability.get(), false);
                }
            });
        }
        return this;
    }

    default public void initialize() {
        PlayerEvents.COPY.register((originalPlayer, newPlayer, originalStillAlive) -> {
            Optional originalCapability = this.getIfProvided(originalPlayer);
            Optional newCapability = this.getIfProvided(newPlayer);
            if (originalCapability.isPresent() && newCapability.isPresent()) {
                this.getCopyStrategy().copy((Entity)originalPlayer, (CapabilityComponent)originalCapability.get(), (Entity)newPlayer, (CapabilityComponent)newCapability.get(), originalStillAlive);
            }
        });
    }
}

