/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.icon;

import com.mafuyu404.oelib.icon.IconVariant;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;

public final class DynamicIconRegistry {
    private static final Map<String, List<IconVariant>> VARIANTS = new ConcurrentHashMap<String, List<IconVariant>>();
    private static final Map<String, String> SELECTED_FABRIC_PATH = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> SELECTED_FORGE_PATH = new ConcurrentHashMap<String, String>();
    private static final Random RANDOM = new Random();

    private DynamicIconRegistry() {
    }

    public static Builder forMod(String modId) {
        return new Builder(modId);
    }

    public static boolean hasConfig(String modId) {
        return VARIANTS.containsKey(modId);
    }

    public static void register(String modId, List<IconVariant> variants) {
        if (variants == null || variants.isEmpty()) {
            return;
        }
        VARIANTS.put(modId, List.copyOf(variants));
    }

    public static Optional<String> getSelectedFabricPath(String modId) {
        String cached = SELECTED_FABRIC_PATH.get(modId);
        if (cached != null) {
            return Optional.of(cached);
        }
        List<IconVariant> variants = VARIANTS.get(modId);
        if (variants == null || variants.isEmpty()) {
            return Optional.empty();
        }
        List<IconVariant> effective = DynamicIconRegistry.filterForFabric(variants);
        if (effective.isEmpty()) {
            return Optional.empty();
        }
        IconVariant picked = DynamicIconRegistry.pickWeighted(effective);
        String path = DynamicIconRegistry.resolveFabricPath(modId, picked);
        SELECTED_FABRIC_PATH.put(modId, path);
        return Optional.of(path);
    }

    public static Optional<String> getSelectedForgePath(String modId) {
        String cached = SELECTED_FORGE_PATH.get(modId);
        if (cached != null) {
            return Optional.of(cached);
        }
        List<IconVariant> variants = VARIANTS.get(modId);
        if (variants == null || variants.isEmpty()) {
            return Optional.empty();
        }
        List<IconVariant> effective = DynamicIconRegistry.filterForForge(variants);
        if (effective.isEmpty()) {
            return Optional.empty();
        }
        IconVariant picked = DynamicIconRegistry.pickWeighted(effective);
        String path = DynamicIconRegistry.resolveForgePath(picked);
        SELECTED_FORGE_PATH.put(modId, path);
        return Optional.of(path);
    }

    private static IconVariant pickWeighted(List<IconVariant> variants) {
        int total = 0;
        for (IconVariant v : variants) {
            total += Math.max(1, v.getWeight());
        }
        int r = RANDOM.nextInt(total);
        int acc = 0;
        for (IconVariant v : variants) {
            if (r >= (acc += Math.max(1, v.getWeight()))) continue;
            return v;
        }
        return variants.get(variants.size() - 1);
    }

    private static List<IconVariant> filterForFabric(List<IconVariant> variants) {
        ArrayList<IconVariant> out = new ArrayList<IconVariant>();
        for (IconVariant v : variants) {
            if (!v.appliesToFabric()) continue;
            out.add(v);
        }
        return out;
    }

    private static List<IconVariant> filterForForge(List<IconVariant> variants) {
        ArrayList<IconVariant> out = new ArrayList<IconVariant>();
        for (IconVariant v : variants) {
            if (!v.appliesToForge()) continue;
            out.add(v);
        }
        return out;
    }

    private static String resolveFabricPath(String modId, IconVariant variant) {
        if (variant.isPath()) {
            return variant.getPath();
        }
        return "assets/" + modId + "/" + variant.getName();
    }

    private static String resolveForgePath(IconVariant variant) {
        if (variant.isPath()) {
            return variant.getPath();
        }
        return variant.getName();
    }

    public static final class Builder {
        private final String modId;
        private final List<IconVariant> localVariants = new ArrayList<IconVariant>();

        private Builder(String modId) {
            this.modId = modId;
        }

        public Builder addName(String fileName, int weight) {
            this.localVariants.add(IconVariant.name(fileName, weight));
            return this;
        }

        public Builder addPath(String path, int weight) {
            this.localVariants.add(IconVariant.path(path, weight));
            return this;
        }

        public Builder addNameFabric(String fileName, int weight) {
            this.localVariants.add(IconVariant.nameFabric(fileName, weight));
            return this;
        }

        public Builder addPathFabric(String path, int weight) {
            this.localVariants.add(IconVariant.pathFabric(path, weight));
            return this;
        }

        public Builder addNameForge(String fileName, int weight) {
            this.localVariants.add(IconVariant.nameForge(fileName, weight));
            return this;
        }

        public Builder addPathForge(String path, int weight) {
            this.localVariants.add(IconVariant.pathForge(path, weight));
            return this;
        }

        public void register() {
            DynamicIconRegistry.register(this.modId, this.localVariants);
        }
    }
}

