/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.forge.data.net;

import com.mafuyu404.oelib.OELib;
import com.mafuyu404.oelib.forge.data.net.DataSyncChunkPacket;
import com.mafuyu404.oelib.forge.network.NetworkManager;
import com.mafuyu404.oelib.util.CodecUtils;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DataSyncPacket<T> {
    private static final int MAX_CHUNK_SIZE = 30000;
    private final Class<T> dataClass;
    private final Map<ResourceLocation, T> data;

    public DataSyncPacket(Class<T> dataClass, Map<ResourceLocation, T> data) {
        this.dataClass = dataClass;
        this.data = data;
    }

    public void sendTo(ServerPlayer player) {
        if (player == null) {
            OELib.LOGGER.warn("Cannot send packet: player is null");
            return;
        }
        this.sendToTarget(PacketDistributor.PLAYER.with(() -> player));
    }

    public void sendToAll() {
        MinecraftServer server = ServerLifecycleHooks.getCurrentServer();
        if (server == null) {
            OELib.LOGGER.warn("Cannot send packet to all players: server instance is null");
            return;
        }
        this.sendToTarget(PacketDistributor.ALL.noArg());
    }

    private void sendToTarget(PacketDistributor.PacketTarget target) {
        try {
            Optional<String> jsonOpt = CodecUtils.encodeToJson(this.dataClass, this.data);
            if (jsonOpt.isEmpty()) {
                OELib.LOGGER.error("Failed to encode {} data to JSON", (Object)this.dataClass.getSimpleName());
                return;
            }
            String jsonData = jsonOpt.get();
            byte[] dataBytes = jsonData.getBytes(StandardCharsets.UTF_8);
            OELib.LOGGER.info("Sending {} data: {} entries, {} bytes", new Object[]{this.dataClass.getSimpleName(), this.data.size(), dataBytes.length});
            if (dataBytes.length <= 30000) {
                this.sendSingleChunk(target, dataBytes);
            } else {
                this.sendChunked(target, dataBytes);
            }
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to send {} sync packet: {}", new Object[]{this.dataClass.getSimpleName(), e.getMessage(), e});
        }
    }

    private void sendSingleChunk(PacketDistributor.PacketTarget target, byte[] dataBytes) {
        try {
            UUID sessionId = UUID.randomUUID();
            DataSyncChunkPacket chunk = new DataSyncChunkPacket(sessionId, 0, 1, this.dataClass.getName(), dataBytes);
            if (target == PacketDistributor.ALL.noArg()) {
                chunk.sendToAll();
            } else {
                NetworkManager.getChannel().send(target, (Object)chunk);
            }
            OELib.LOGGER.debug("Sent single chunk for {} session {}", (Object)this.dataClass.getSimpleName(), (Object)sessionId);
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to send single chunk for {}: {}", new Object[]{this.dataClass.getSimpleName(), e.getMessage(), e});
        }
    }

    private void sendChunked(PacketDistributor.PacketTarget target, byte[] data) {
        try {
            UUID sessionId = UUID.randomUUID();
            int totalChunks = (int)Math.ceil((double)data.length / 30000.0);
            OELib.LOGGER.info("Splitting {} data into {} chunks for session {}", new Object[]{this.dataClass.getSimpleName(), totalChunks, sessionId});
            for (int i = 0; i < totalChunks; ++i) {
                int start = i * 30000;
                int end = Math.min(start + 30000, data.length);
                int chunkSize = end - start;
                byte[] chunkData = new byte[chunkSize];
                System.arraycopy(data, start, chunkData, 0, chunkSize);
                DataSyncChunkPacket chunk = new DataSyncChunkPacket(sessionId, i, totalChunks, this.dataClass.getName(), chunkData);
                if (target == PacketDistributor.ALL.noArg()) {
                    chunk.sendToAll();
                } else {
                    NetworkManager.getChannel().send(target, (Object)chunk);
                }
                OELib.LOGGER.debug("Sent chunk {}/{} ({} bytes) for {} session {}", new Object[]{i + 1, totalChunks, chunkSize, this.dataClass.getSimpleName(), sessionId});
            }
        }
        catch (Exception e) {
            OELib.LOGGER.error("Failed to send chunked {} data: {}", new Object[]{this.dataClass.getSimpleName(), e.getMessage(), e});
        }
    }
}

