/*
 * Decompiled with CFR 0.152.
 */
package com.mafuyu404.oelib.data.mvel.processor;

import com.mafuyu404.oelib.api.data.ExpressionFunction;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.annotation.processing.SupportedSourceVersion;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;

@SupportedAnnotationTypes(value={"com.mafuyu404.oelib.api.data.ExpressionFunction"})
@SupportedSourceVersion(value=SourceVersion.RELEASE_17)
public class ExpressionFunctionProcessor
extends AbstractProcessor {
    private Messager messager;
    private Filer filer;

    @Override
    public synchronized void init(ProcessingEnvironment env) {
        super.init(env);
        this.messager = env.getMessager();
        this.filer = env.getFiler();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        HashMap<String, ExecutableElement> functionsByName = new HashMap<String, ExecutableElement>();
        ArrayList<ExecutableElement> allMethods = new ArrayList<ExecutableElement>();
        for (Element element : roundEnv.getElementsAnnotatedWith(ExpressionFunction.class)) {
            String name;
            if (!(element instanceof ExecutableElement)) continue;
            ExecutableElement method = (ExecutableElement)element;
            allMethods.add(method);
            if (!method.getModifiers().contains((Object)Modifier.STATIC)) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "@ExpressionFunction should annotate a static method (MVEL requires static): " + String.valueOf(method.getSimpleName()), method);
                continue;
            }
            ExpressionFunction ann = method.getAnnotation(ExpressionFunction.class);
            String string = name = ann.value().isEmpty() ? method.getSimpleName().toString() : ann.value();
            if (functionsByName.containsKey(name)) {
                this.messager.printMessage(Diagnostic.Kind.WARNING, "Duplicate ExpressionFunction name: '" + name + "'. Only the first one will be registered.", method);
                continue;
            }
            functionsByName.put(name, method);
        }
        if (functionsByName.isEmpty()) {
            return false;
        }
        try {
            this.generateRegistrar(functionsByName, allMethods);
        }
        catch (IOException e) {
            this.messager.printMessage(Diagnostic.Kind.ERROR, "Failed to generate ExpressionFunctionsRegistrar: " + e.getMessage());
        }
        return false;
    }

    private void generateRegistrar(Map<String, ExecutableElement> functionsByName, List<ExecutableElement> allMethods) throws IOException {
        String hash = this.hashSuffix(allMethods);
        ExecutableElement sample = allMethods.get(0);
        TypeElement owner = (TypeElement)sample.getEnclosingElement();
        PackageElement ownerPkg = this.processingEnv.getElementUtils().getPackageOf(owner);
        String pkg = ownerPkg.getQualifiedName().toString() + ".oelib_mvel_gen";
        String cls = "GeneratedExpressionFunctions_" + hash;
        JavaFileObject file = this.filer.createSourceFile(pkg + "." + cls, new Element[0]);
        try (PrintWriter out = new PrintWriter(file.openWriter());){
            out.println("package " + pkg + ";");
            out.println();
            out.println("import com.mafuyu404.oelib.data.mvel.gen.ExpressionFunctionRegistry;");
            out.println("import com.mafuyu404.oelib.data.mvel.gen.ExpressionFunctionsRegistrar;");
            for (ExecutableElement executableElement : functionsByName.values()) {
                TypeElement methodOwner = (TypeElement)executableElement.getEnclosingElement();
                out.println("import " + methodOwner.getQualifiedName().toString() + ";");
            }
            out.println("import java.util.Set;");
            out.println();
            out.println("public final class " + cls + " implements ExpressionFunctionsRegistrar {");
            out.println("    @Override");
            out.println("    public void register(ExpressionFunctionRegistry registry, Set<String> requiredFunctions) {");
            for (Map.Entry entry : functionsByName.entrySet()) {
                String name = (String)entry.getKey();
                ExecutableElement method = (ExecutableElement)entry.getValue();
                TypeElement methodOwner = (TypeElement)method.getEnclosingElement();
                String ownerSimple = methodOwner.getQualifiedName().toString().substring(methodOwner.getQualifiedName().toString().lastIndexOf(46) + 1);
                List<TypeMirror> params = method.getParameters().stream().map(VariableElement::asType).toList();
                StringBuilder paramTypesBuilder = new StringBuilder();
                if (!params.isEmpty()) {
                    for (int i = 0; i < params.size(); ++i) {
                        TypeMirror tm = params.get(i);
                        String typeName = tm.toString();
                        int lastDot = typeName.lastIndexOf(46);
                        String simpleName = lastDot >= 0 ? typeName.substring(lastDot + 1) : typeName;
                        paramTypesBuilder.append(simpleName).append(".class");
                        if (i >= params.size() - 1) continue;
                        paramTypesBuilder.append(", ");
                    }
                }
                out.println("        if (requiredFunctions == null || requiredFunctions.contains(\"" + name + "\")) {");
                out.println("            registry.register(\"" + name + "\", " + ownerSimple + ".class, \"" + String.valueOf(method.getSimpleName()) + "\"" + (String)(params.isEmpty() ? "" : ", " + String.valueOf(paramTypesBuilder)) + ");");
                out.println("        }");
            }
            out.println("    }");
            out.println("}");
        }
        String registrarService = "com.mafuyu404.oelib.data.mvel.gen.ExpressionFunctionsRegistrar";
        try (PrintWriter svc = new PrintWriter(this.filer.createResource(StandardLocation.CLASS_OUTPUT, "", "META-INF/services/" + registrarService, new Element[0]).openWriter());){
            svc.println(pkg + "." + cls);
        }
    }

    private String hashSuffix(List<ExecutableElement> methods) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            for (ExecutableElement m : methods) {
                TypeElement owner = (TypeElement)m.getEnclosingElement();
                PackageElement pkg = this.processingEnv.getElementUtils().getPackageOf(owner);
                md.update(pkg.getQualifiedName().toString().getBytes(StandardCharsets.UTF_8));
                md.update(owner.getQualifiedName().toString().getBytes(StandardCharsets.UTF_8));
                md.update(m.getSimpleName().toString().getBytes(StandardCharsets.UTF_8));
                for (VariableElement variableElement : m.getParameters()) {
                    md.update(variableElement.asType().toString().getBytes(StandardCharsets.UTF_8));
                }
            }
            byte[] digest = md.digest();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < Math.min(6, digest.length); ++i) {
                sb.append(String.format("%02x", digest[i]));
            }
            return sb.toString();
        }
        catch (Exception e) {
            return Integer.toHexString(methods.hashCode());
        }
    }
}

