/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.common.utils;

import com.google.common.collect.BiMap;
import java.util.Map;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.block.IWashable;
import net.mehvahdjukaar.moonlight.api.platform.network.Message;
import net.mehvahdjukaar.moonlight.api.set.BlocksColorAPI;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.supplementaries.SuppPlatformStuff;
import net.mehvahdjukaar.supplementaries.common.network.ClientBoundParticlePacket;
import net.mehvahdjukaar.supplementaries.common.network.ModNetwork;
import net.mehvahdjukaar.supplementaries.common.utils.BlockPredicate;
import net.mehvahdjukaar.supplementaries.common.utils.BlockUtil;
import net.mehvahdjukaar.supplementaries.configs.CommonConfigs;
import net.mehvahdjukaar.supplementaries.reg.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.item.HoneycombItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.piston.PistonBaseBlock;
import net.minecraft.world.level.block.piston.PistonHeadBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.PistonType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class SoapWashableHelper {
    public static boolean canCleanColor(@NotNull Block block) {
        if (block.m_204297_().m_203656_(ModTags.SOAP_BLACKLIST_BLOCK)) {
            return false;
        }
        return !CommonConfigs.Functional.SOAP_DYE_CLEAN_BLACKLIST.get().contains(BlocksColorAPI.getKey((Block)block));
    }

    public static boolean canCleanColor(@NotNull Item item) {
        if (item.m_204114_().m_203656_(ModTags.SOAP_BLACKLIST_ITEM)) {
            return false;
        }
        return !CommonConfigs.Functional.SOAP_DYE_CLEAN_BLACKLIST.get().contains(BlocksColorAPI.getKey((Item)item));
    }

    public static boolean tryWash(Level level, BlockPos pos, BlockState state, Vec3 hitVec) {
        if (SoapWashableHelper.tryWashWithInterface(level, pos, state, hitVec) || SoapWashableHelper.tryCleaningSign(level, pos, state) || SoapWashableHelper.tryChangingColor(level, pos, state) || SoapWashableHelper.tryCleaningPiston(level, pos, state) || SoapWashableHelper.tryCleanFromConfig(level, pos, state) || SoapWashableHelper.tryUnWax(level, pos, state)) {
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                ModNetwork.CHANNEL.sendToAllClientPlayersInParticleRange((Level)serverLevel, pos, (Message)new ClientBoundParticlePacket(pos, ClientBoundParticlePacket.Type.BUBBLE_CLEAN));
            }
            return true;
        }
        return false;
    }

    private static boolean tryCleaningSign(Level level, BlockPos pos, BlockState state) {
        SignBlockEntity te;
        BlockEntity blockEntity;
        if (state.m_60734_() instanceof SignBlock && (blockEntity = level.m_7702_(pos)) instanceof SignBlockEntity && (te = (SignBlockEntity)blockEntity).m_277118_()) {
            te.m_277031_(false);
            if (!level.f_46443_) {
                te.m_6596_();
                level.m_7260_(pos, state, state, 3);
            }
            return true;
        }
        return false;
    }

    private static boolean tryUnWax(Level level, BlockPos pos, BlockState state) {
        Block b = state.m_60734_();
        BlockState toPlace = null;
        Block unWaxed = (Block)((BiMap)HoneycombItem.f_150863_.get()).inverse().get((Object)b);
        if (unWaxed != null) {
            toPlace = unWaxed.m_152465_(state);
        }
        if (toPlace == null) {
            toPlace = SoapWashableHelper.tryParseWax(state);
        }
        if (toPlace != null) {
            SoapWashableHelper.replaceWithBlockEntity(level, pos, b, toPlace);
            return true;
        }
        return false;
    }

    private static boolean tryCleaningPiston(Level level, BlockPos pos, BlockState state) {
        if (state.m_60713_(Blocks.f_50032_)) {
            Direction dir = (Direction)state.m_61143_((Property)PistonBaseBlock.f_52588_);
            BlockPos headPos = pos.m_121945_(dir);
            BlockState headState = level.m_8055_(headPos);
            if (headState.m_60713_(Blocks.f_50040_) && headState.m_61143_((Property)PistonHeadBlock.f_52588_) == dir) {
                level.m_46597_(headPos, (BlockState)headState.m_61124_((Property)PistonHeadBlock.f_60235_, (Comparable)PistonType.DEFAULT));
            }
            level.m_46597_(pos, Blocks.f_50039_.m_152465_(state));
            return true;
        }
        if (state.m_60713_(Blocks.f_50040_) && state.m_61143_((Property)PistonHeadBlock.f_60235_) == PistonType.STICKY) {
            Direction dir = (Direction)state.m_61143_((Property)PistonHeadBlock.f_52588_);
            BlockPos basePos = pos.m_121945_(dir.m_122424_());
            BlockState baseState = level.m_8055_(basePos);
            level.m_46597_(pos, (BlockState)Blocks.f_50040_.m_152465_(state).m_61124_((Property)PistonHeadBlock.f_60235_, (Comparable)PistonType.DEFAULT));
            if (baseState.m_60713_(Blocks.f_50032_) && baseState.m_61143_((Property)PistonBaseBlock.f_52588_) == dir) {
                level.m_46597_(basePos, Blocks.f_50039_.m_152465_(baseState));
            }
            return true;
        }
        return false;
    }

    private static boolean tryCleanFromConfig(Level level, BlockPos pos, BlockState state) {
        BlockState toPlace = null;
        for (Map.Entry<BlockPredicate, ResourceLocation> e : CommonConfigs.Functional.SOAP_SPECIAL.get().entrySet()) {
            if (!e.getKey().test(state)) continue;
            toPlace = BuiltInRegistries.f_256975_.m_6612_(e.getValue()).map(s -> s.m_152465_(state)).orElse(null);
            break;
        }
        if (toPlace != null) {
            level.m_7731_(pos, toPlace, 11);
            return true;
        }
        return false;
    }

    private static BlockState tryParseWax(BlockState oldState) {
        String[] keywords;
        ResourceLocation r = Utils.getID((Block)oldState.m_60734_());
        String name = r.m_135815_();
        for (String key : keywords = new String[]{"waxed_", "weathered_", "exposed_", "oxidized_", "_waxed", "_weathered", "_exposed", "_oxidized"}) {
            BlockState newState;
            if (!name.contains(key)) continue;
            String newName = name.replace(key, "");
            Optional bb = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(r.m_135827_(), newName));
            if (bb.isEmpty()) {
                bb = BuiltInRegistries.f_256975_.m_6612_(new ResourceLocation(newName));
            }
            if (!bb.isPresent() || (newState = ((Block)bb.get()).m_152465_(oldState)) == oldState) continue;
            return newState;
        }
        return null;
    }

    private static boolean tryWashWithInterface(Level level, BlockPos pos, BlockState state, Vec3 hitVec) {
        BlockEntity tile;
        IWashable soapWashable;
        Block b = state.m_60734_();
        IWashable cap = b instanceof IWashable ? (soapWashable = (IWashable)b) : SuppPlatformStuff.getForgeCap(b, IWashable.class);
        if (cap == null && (tile = level.m_7702_(pos)) != null) {
            IWashable soapWashable2;
            cap = tile instanceof IWashable ? (soapWashable2 = (IWashable)tile) : SuppPlatformStuff.getForgeCap(tile, IWashable.class);
        }
        if (cap != null) {
            return cap.tryWash(level, pos, state, hitVec);
        }
        return false;
    }

    private static boolean tryChangingColor(Level level, BlockPos pos, BlockState state) {
        Block newColor = BlocksColorAPI.changeColor((Block)state.m_60734_(), null);
        if (newColor != null) {
            BlockPos other;
            BlockState otherBed;
            Block otherBedColor;
            if (!SoapWashableHelper.canCleanColor(state.m_60734_())) {
                return false;
            }
            if (state.m_61138_((Property)BedBlock.f_49440_) && (otherBedColor = BlocksColorAPI.changeColor((Block)(otherBed = level.m_8055_(other = pos.m_121945_(BlockUtil.getConnectedBedDirection(state)))).m_60734_(), null)) != null) {
                level.m_7731_(other, otherBedColor.m_152465_(otherBed), 18);
            }
            BlockState toPlace = newColor.m_152465_(state);
            SoapWashableHelper.replaceWithBlockEntity(level, pos, newColor, toPlace);
            return true;
        }
        return false;
    }

    private static void replaceWithBlockEntity(Level level, BlockPos pos, Block newColor, BlockState toPlace) {
        BlockEntity be;
        BlockEntity oldBe;
        CompoundTag oldBetag = null;
        if (newColor instanceof EntityBlock && (oldBe = level.m_7702_(pos)) != null) {
            oldBetag = oldBe.m_187482_();
            level.m_46747_(pos);
        }
        level.m_7731_(pos, toPlace, 18);
        if (oldBetag != null && (be = level.m_7702_(pos)) != null) {
            be.m_142466_(oldBetag);
        }
    }
}

