/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.objects.GLMessages;

import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.util.objects.GLMessages.EGLMessageSeverity;
import com.seibel.distanthorizons.core.util.objects.GLMessages.EGLMessageSource;
import com.seibel.distanthorizons.core.util.objects.GLMessages.EGLMessageType;
import com.seibel.distanthorizons.core.util.objects.GLMessages.GLMessage;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.logging.log4j.Logger;

public class GLMessageBuilder {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    private static final int FINAL_LEGACY_PARSER_STAGE_INDEX = 15;
    private static final int FINAL_NEW_PARSER_STAGE_INDEX = 5;
    private EGLMessageType type;
    private EGLMessageSeverity severity;
    private EGLMessageSource source;
    private final Function<EGLMessageType, Boolean> typeFilter;
    private final Function<EGLMessageSeverity, Boolean> severityFilter;
    private final Function<EGLMessageSource, Boolean> sourceFilter;
    private String id;
    private String message;
    private int parserStage = 0;
    private boolean legacyMessage = true;

    public GLMessageBuilder() {
        this(null, null, null);
    }

    public GLMessageBuilder(Function<EGLMessageType, Boolean> typeFilter, Function<EGLMessageSeverity, Boolean> severityFilter, Function<EGLMessageSource, Boolean> sourceFilter) {
        this.typeFilter = typeFilter;
        this.severityFilter = severityFilter;
        this.sourceFilter = sourceFilter;
    }

    public GLMessage add(String str) {
        if ((str = str.trim()).isEmpty()) {
            return null;
        }
        boolean messageFinished = false;
        boolean parseSuccess = this.runNextParserStage(str);
        if (this.legacyMessage && this.parserStage > 15) {
            messageFinished = true;
        } else if (!this.legacyMessage && this.parserStage > 5) {
            messageFinished = true;
        }
        if (parseSuccess && messageFinished) {
            this.parserStage = 0;
            GLMessage msg = new GLMessage(this.type, this.severity, this.source, this.id, this.message);
            if (this.doesMessagePassFilters(msg)) {
                return msg;
            }
        } else if (!parseSuccess && messageFinished) {
            LOGGER.warn("Failed to parse GLMessage line [" + str + "] at stage [" + this.parserStage + "]");
        }
        return null;
    }

    private boolean doesMessagePassFilters(GLMessage msg) {
        if (this.sourceFilter != null && !this.sourceFilter.apply(msg.source).booleanValue()) {
            return false;
        }
        if (this.typeFilter != null && !this.typeFilter.apply(msg.type).booleanValue()) {
            return false;
        }
        return this.severityFilter == null || this.severityFilter.apply(msg.severity) != false;
    }

    private boolean runNextParserStage(String str) {
        if (this.parserStage == 0) {
            return this.checkExactAndIncStage(str, "[LWJGL] OpenGL debug message");
        }
        if (this.parserStage == 1) {
            boolean bl = this.legacyMessage = !str.contains("ID: ");
        }
        if (this.legacyMessage) {
            return this.runNextLegacyParserStage(str);
        }
        return this.runNextNewParserStage(str);
    }

    private boolean runNextLegacyParserStage(String str) {
        switch (this.parserStage) {
            case 0: {
                throw new IllegalStateException("Parser should be past stage [" + this.parserStage + "], next stage is [1].");
            }
            case 1: {
                return this.checkExactAndIncStage(str, "ID");
            }
            case 2: {
                return this.checkExactAndIncStage(str, ":");
            }
            case 3: {
                this.id = str;
                ++this.parserStage;
                return true;
            }
            case 4: {
                return this.checkExactAndIncStage(str, "Source");
            }
            case 5: {
                return this.checkExactAndIncStage(str, ":");
            }
            case 6: {
                this.source = EGLMessageSource.get(str);
                ++this.parserStage;
                return true;
            }
            case 7: {
                return this.checkExactAndIncStage(str, "Type");
            }
            case 8: {
                return this.checkExactAndIncStage(str, ":");
            }
            case 9: {
                this.type = EGLMessageType.get(str);
                ++this.parserStage;
                return true;
            }
            case 10: {
                return this.checkExactAndIncStage(str, "Severity");
            }
            case 11: {
                return this.checkExactAndIncStage(str, ":");
            }
            case 12: {
                this.severity = EGLMessageSeverity.get(str);
                ++this.parserStage;
                return true;
            }
            case 13: {
                return this.checkExactAndIncStage(str, "Message");
            }
            case 14: {
                return this.checkExactAndIncStage(str, ":");
            }
            case 15: {
                this.message = str;
                ++this.parserStage;
                return true;
            }
        }
        return false;
    }

    private boolean runNextNewParserStage(String str) {
        switch (this.parserStage) {
            case 0: {
                throw new IllegalStateException("Parser should be past stage [" + this.parserStage + "], next stage is [1].");
            }
            case 1: {
                String idPrefix = "ID: ";
                return this.checkPrefixAndRun(str, idPrefix, line -> {
                    this.id = GLMessageBuilder.trySubstring(str, idPrefix.length());
                    ++this.parserStage;
                });
            }
            case 2: {
                String sourcePrefix = "Source: ";
                return this.checkPrefixAndRun(str, sourcePrefix, line -> {
                    String sourceString = GLMessageBuilder.trySubstring(str, sourcePrefix.length());
                    this.source = EGLMessageSource.get(sourceString);
                    ++this.parserStage;
                });
            }
            case 3: {
                String typePrefix = "Type: ";
                return this.checkPrefixAndRun(str, typePrefix, line -> {
                    String sourceString = GLMessageBuilder.trySubstring(str, typePrefix.length());
                    this.type = EGLMessageType.get(sourceString);
                    ++this.parserStage;
                });
            }
            case 4: {
                String severityPrefix = "Severity: ";
                return this.checkPrefixAndRun(str, severityPrefix, line -> {
                    String sourceString = GLMessageBuilder.trySubstring(str, severityPrefix.length());
                    this.severity = EGLMessageSeverity.get(sourceString);
                    ++this.parserStage;
                });
            }
            case 5: {
                String messagePrefix = "Message: ";
                return this.checkPrefixAndRun(str, messagePrefix, line -> {
                    this.message = GLMessageBuilder.trySubstring(str, messagePrefix.length());
                    ++this.parserStage;
                });
            }
        }
        return false;
    }

    private boolean checkExactAndIncStage(String message, String expectedString) {
        boolean equal = message.equals(expectedString);
        if (equal) {
            ++this.parserStage;
        }
        return equal;
    }

    private boolean checkPrefixAndRun(String message, String expectedPrefix, Consumer<String> successConsumer) {
        boolean equal = message.startsWith(expectedPrefix);
        if (equal) {
            successConsumer.accept(message);
        }
        return equal;
    }

    private static String trySubstring(String string, int beginIndex) {
        if (beginIndex > string.length()) {
            return "";
        }
        return string.substring(beginIndex);
    }
}

