/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.oneenoughblock.init;

import com.sighs.oneenoughblock.Config;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITag;
import net.minecraftforge.registries.tags.ITagManager;

public class Utils {
    public static <T extends Comparable<T>> BlockState saveState(BlockState from, BlockState to) {
        if (((Boolean)Config.extendedBlockProperty.get()).booleanValue()) {
            return to;
        }
        for (Map.Entry entry : from.m_61148_().entrySet()) {
            to = (BlockState)to.m_263224_((Property)entry.getKey(), (Comparable)entry.getValue());
        }
        return to;
    }

    public static String getBlockRegistryName(Block block) {
        if (block == null) {
            return null;
        }
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)block);
        return id != null ? id.toString() : null;
    }

    public static Block getBlockById(String id) {
        if (id == null || id.isEmpty()) {
            return null;
        }
        try {
            return (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(id));
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isTagExists(ResourceLocation tagId) {
        ITagManager mgr = ForgeRegistries.BLOCKS.tags();
        TagKey key = ForgeRegistries.BLOCKS.tags().createTagKey(tagId);
        return mgr != null && mgr.isKnownTagName(key);
    }

    public static Collection<Block> getBlocksOfTag(ResourceLocation tagId) {
        ITagManager mgr = ForgeRegistries.BLOCKS.tags();
        if (mgr == null) {
            return Collections.emptyList();
        }
        TagKey key = ForgeRegistries.BLOCKS.tags().createTagKey(tagId);
        ITag tag = mgr.getTag(key);
        return tag.stream().toList();
    }

    public static List<Block> resolveBlockList(List<String> identifiers) {
        ArrayList<Block> result = new ArrayList<Block>();
        for (String id : identifiers) {
            if (id == null || id.isEmpty()) continue;
            if (id.startsWith("#")) {
                ResourceLocation tag = new ResourceLocation(id.substring(1));
                result.addAll(Utils.getBlocksOfTag(tag));
                continue;
            }
            Block f = Utils.getBlockById(id);
            if (f == null) continue;
            result.add(f);
        }
        return result;
    }
}

