/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.oneenoughblock.init;

import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.init.config.DomainConfig;
import com.mafuyu404.oneenoughitem.init.config.OEIConfig;
import com.sighs.oneenoughblock.Oneenoughblock;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.tags.ITagManager;

public class BlockReplacementCache {
    private static final ConcurrentHashMap<String, String> BlockMapCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, String> TagMapCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Replacements.Rules> BlockRulesCache = new ConcurrentHashMap();
    private static final ConcurrentHashMap<String, Replacements.Rules> TagRulesCache = new ConcurrentHashMap();
    private static volatile Map<String, String> ReloadOverrideBlockMap = null;

    public static String matchBlock(String id) {
        return ((Map)Objects.requireNonNullElse(ReloadOverrideBlockMap, BlockMapCache)).getOrDefault(id, null);
    }

    public static String matchTag(String tagId) {
        return TagMapCache.getOrDefault(tagId, null);
    }

    public static String matchTag(ResourceLocation tagId) {
        return tagId != null ? BlockReplacementCache.matchTag(tagId.toString()) : null;
    }

    public static boolean isTagReplaced(String tagId) {
        return tagId != null && TagMapCache.containsKey(tagId);
    }

    public static boolean isTagReplaced(ResourceLocation tagId) {
        return tagId != null && BlockReplacementCache.isTagReplaced(tagId.toString());
    }

    public static boolean isSourceBlockId(String id) {
        return id != null && ((Map)Objects.requireNonNullElse(ReloadOverrideBlockMap, BlockMapCache)).containsKey(id);
    }

    public static Optional<Block> resolveTarget(Block source) {
        ResourceLocation id = ForgeRegistries.BLOCKS.getKey((Object)source);
        if (id == null) {
            return Optional.empty();
        }
        String target = BlockReplacementCache.matchBlock(id.toString());
        if (target != null) {
            Block b = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(target));
            return Optional.ofNullable(b);
        }
        return Optional.empty();
    }

    public static Optional<Block> resolveTargetByTags(Block source) {
        ITagManager tags = ForgeRegistries.BLOCKS.tags();
        for (Map.Entry<String, String> entry : TagMapCache.entrySet()) {
            Block target;
            String tagId = entry.getKey();
            String targetId = entry.getValue();
            TagKey tagKey = tags.createTagKey(new ResourceLocation(tagId));
            if (!source.m_204297_().m_203656_(tagKey) || (target = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(targetId))) == null) continue;
            return Optional.of(target);
        }
        return Optional.empty();
    }

    public static void putBlockMapping(String sourceId, String targetId) {
        if (sourceId != null && targetId != null) {
            BlockMapCache.put(sourceId, targetId);
        }
    }

    public static void putTagMapping(String sourceTag, String targetId) {
        if (sourceTag != null && targetId != null) {
            TagMapCache.put(sourceTag, targetId);
        }
    }

    public static boolean removeBlockReplacement(String blockId) {
        if (blockId != null && BlockMapCache.containsKey(blockId)) {
            String removed = BlockMapCache.remove(blockId);
            BlockRulesCache.remove(blockId);
            Oneenoughblock.LOGGER.debug("Removed fluid replacement from runtime cache: {} -> {}", (Object)blockId, (Object)removed);
            return true;
        }
        return false;
    }

    public static boolean removeTagReplacement(String tagId) {
        if (tagId != null && TagMapCache.containsKey(tagId)) {
            String removed = TagMapCache.remove(tagId);
            TagRulesCache.remove(tagId);
            Oneenoughblock.LOGGER.debug("Removed tag replacement from runtime cache: {} -> {}", (Object)tagId, (Object)removed);
            return true;
        }
        return false;
    }

    public static void removeReplacements(Collection<String> blockIds, Collection<String> tagIds) {
        boolean changed = false;
        if (blockIds != null) {
            for (String blockId : blockIds) {
                if (!BlockReplacementCache.removeBlockReplacement(blockId)) continue;
                changed = true;
            }
        }
        if (tagIds != null) {
            for (String tagId : tagIds) {
                if (!BlockReplacementCache.removeTagReplacement(tagId)) continue;
                changed = true;
            }
        }
        if (changed) {
            Oneenoughblock.LOGGER.info("Removed {} block replacements and {} tag replacements from runtime cache", (Object)(blockIds != null ? blockIds.size() : 0), (Object)(tagIds != null ? tagIds.size() : 0));
        }
    }

    public static Collection<String> trackSourceIdOf(String id) {
        HashSet<String> result = new HashSet<String>();
        BlockMapCache.forEach((match, target) -> {
            if (target.equals(id)) {
                result.add((String)match);
            }
        });
        return result;
    }

    public static void clearCache() {
        BlockMapCache.clear();
        TagMapCache.clear();
        BlockRulesCache.clear();
        TagRulesCache.clear();
    }

    public static void putReplacement(Replacements replacement) {
        String result = replacement.result();
        replacement.rules().ifPresentOrElse(rules -> {
            for (String m : replacement.match()) {
                if (m == null || m.isEmpty()) continue;
                if (m.startsWith("#")) {
                    String tagId = m.substring(1);
                    TagMapCache.put(tagId, result);
                    TagRulesCache.put(tagId, (Replacements.Rules)rules);
                    continue;
                }
                BlockMapCache.put(m, result);
                BlockRulesCache.put(m, (Replacements.Rules)rules);
            }
        }, () -> {
            for (String m : replacement.match()) {
                if (m == null || m.isEmpty()) continue;
                if (m.startsWith("#")) {
                    TagMapCache.put(m.substring(1), result);
                    continue;
                }
                BlockMapCache.put(m, result);
            }
        });
    }

    public static Optional<Replacements.Rules> getGlobalDefaultRules() {
        try {
            DomainConfig.DefaultRules cfg = OEIConfig.getDefaultRules((String)"oeb");
            if (cfg != null) {
                return Optional.of(cfg.toRules());
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return Optional.empty();
    }

    public static Optional<Replacements.Rules> getBlockRules(String blockId) {
        return Optional.ofNullable(BlockRulesCache.get(blockId));
    }

    public static Optional<Replacements.Rules> getTagRules(String tagId) {
        return Optional.ofNullable(TagRulesCache.get(tagId));
    }

    public static boolean shouldReplaceInDataDir(String blockId, String directory) {
        return BlockReplacementCache.getBlockRules(blockId).or(BlockReplacementCache::getGlobalDefaultRules).flatMap(Replacements.Rules::data).map(dataRules -> (Replacements.ProcessingMode)dataRules.get(directory)).map(mode -> mode == Replacements.ProcessingMode.REPLACE).orElse(false);
    }

    public static boolean shouldReplaceInTagType(String blockId, String tagType) {
        return BlockReplacementCache.getBlockRules(blockId).or(BlockReplacementCache::getGlobalDefaultRules).flatMap(Replacements.Rules::tag).map(tagRules -> (Replacements.ProcessingMode)tagRules.get(tagType)).map(mode -> mode == Replacements.ProcessingMode.REPLACE).orElse(false);
    }

    public static void beginReloadOverride(Map<String, String> currentBlockMap) {
        if (currentBlockMap == null || currentBlockMap.isEmpty()) {
            ReloadOverrideBlockMap = null;
            return;
        }
        ReloadOverrideBlockMap = new HashMap<String, String>(currentBlockMap);
    }

    public static void endReloadOverride() {
        if (ReloadOverrideBlockMap != null) {
            Oneenoughblock.LOGGER.info("Disabled reload-override mapping: {} entries", (Object)ReloadOverrideBlockMap.size());
        }
        ReloadOverrideBlockMap = null;
    }

    public static boolean hasReloadOverride() {
        return ReloadOverrideBlockMap != null;
    }
}

