/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.oneenoughblock.event;

import com.mafuyu404.oelib.forge.data.DataManager;
import com.mafuyu404.oelib.forge.event.DataReloadEvent;
import com.mafuyu404.oneenoughitem.data.Replacements;
import com.mafuyu404.oneenoughitem.event.base.AbstractReplacementEventHandler;
import com.mafuyu404.oneenoughitem.init.config.DomainConfig;
import com.mafuyu404.oneenoughitem.init.config.OEIConfig;
import com.sighs.oneenoughblock.init.BlockReplacementCache;
import java.util.Optional;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.event.server.ServerStartedEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.ForgeRegistries;

@Mod.EventBusSubscriber(modid="oneenoughblock")
public class ServerEventHandler {
    private static final Handler HANDLER = new Handler();

    @SubscribeEvent
    public static void onServerStarted(ServerStartedEvent event) {
        HANDLER.rebuildReplacementCache("oeb-server-start", DataManager.get(Replacements.class));
    }

    @SubscribeEvent
    public static void onDataReload(DataReloadEvent event) {
        if (event.isDataType(Replacements.class)) {
            HANDLER.rebuildReplacementCache("oeb-server-data-reload", DataManager.get(Replacements.class));
        }
    }

    private static class Handler
    extends AbstractReplacementEventHandler {
        private Handler() {
        }

        protected void clearModuleCache() {
            BlockReplacementCache.clearCache();
        }

        protected void putToModuleCache(Replacements r) {
            BlockReplacementCache.putReplacement(this.buildReplacements(r));
        }

        protected boolean tryResolveData(String id) {
            return ForgeRegistries.BLOCKS.getValue(new ResourceLocation(id)) != null;
        }

        protected boolean tryResolveTag(String tagId) {
            TagKey tag = TagKey.m_203882_((ResourceKey)Registries.f_256747_, (ResourceLocation)new ResourceLocation(tagId));
            for (Block b : ForgeRegistries.BLOCKS) {
                if (!b.m_204297_().m_203656_(tag)) continue;
                return true;
            }
            return false;
        }

        protected Replacements buildReplacements(Replacements r) {
            DomainConfig.DefaultRules dr = OEIConfig.getDefaultRules((String)"oeb");
            if (r.rules().isEmpty() && dr != null) {
                return new Replacements(r.match(), r.result(), Optional.of(dr.toRules()));
            }
            return r;
        }
    }
}

