/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.oneenoughblock.client.gui;

import com.mafuyu404.oneenoughitem.client.gui.BaseObjectSelectionScreen;
import com.mafuyu404.oneenoughitem.client.gui.ReplacementEditorScreen;
import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import com.mafuyu404.oneenoughitem.util.ReplacementControl;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockSelectionScreen
extends BaseObjectSelectionScreen<Block> {
    public BlockSelectionScreen(ReplacementEditorScreen parent, boolean isForMatch) {
        super(parent, isForMatch, (Component)Component.m_237113_((String)"gui.oneenoughblock.add_block"));
        this.allObjects = this.loadAllObjects();
        this.filteredObjects = new ArrayList(this.allObjects);
        this.applySort();
    }

    protected Component sortLabel() {
        return Component.m_237115_((String)"gui.oneenoughitem.sort.name");
    }

    protected List<Block> loadAllObjects() {
        return ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b.m_5456_() != Items.f_41852_).collect(Collectors.toList());
    }

    protected String getId(Block obj) {
        ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)obj);
        return key != null ? key.toString() : null;
    }

    protected String getName(Block obj) {
        return obj.m_49954_().getString();
    }

    protected void renderObject(Block obj, GuiGraphics graphics, int x, int y) {
        ItemStack stack = (ItemStack)ReplacementControl.withSkipReplacement(() -> new ItemStack((ItemLike)obj.m_5456_()));
        GuiUtils.drawItemBox((GuiGraphics)graphics, (int)x, (int)y, (int)18, (int)18);
        graphics.m_280480_(stack, x + 1, y + 1);
        graphics.m_280370_(Minecraft.m_91087_().f_91062_, stack, x + 1, y + 1);
    }

    protected void onSelectSingle(String id) {
        ResourceLocation key = ResourceLocation.m_135820_((String)id);
        if (key == null) {
            return;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(key);
        if (block == null || block.m_5456_() == Items.f_41852_) {
            return;
        }
        if (this.isForMatch) {
            this.parent.addMatchItem(block.m_5456_());
        } else {
            this.parent.setResultItem(block.m_5456_());
        }
    }

    protected boolean isSelectable(String id, boolean forMatch) {
        ResourceLocation key = ResourceLocation.m_135820_((String)id);
        if (key == null) {
            return false;
        }
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(key);
        return block != null && block.m_5456_() != Items.f_41852_;
    }

    protected Comparator<Block> getComparator(BaseObjectSelectionScreen.SortMode mode) {
        return switch (mode) {
            default -> throw new IncompatibleClassChangeError();
            case BaseObjectSelectionScreen.SortMode.NAME -> Comparator.comparing(b -> new ItemStack((ItemLike)b.m_5456_()).m_41786_().getString());
            case BaseObjectSelectionScreen.SortMode.MOD -> Comparator.comparing(b -> Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey(b)).m_135827_());
            case BaseObjectSelectionScreen.SortMode.ID -> Comparator.comparing(b -> Objects.requireNonNull(ForgeRegistries.BLOCKS.getKey(b)).toString());
        };
    }

    protected void updateGrid() {
        if (this.itemGrid == null) {
            return;
        }
        ArrayList<ItemStack> pageItems = new ArrayList<ItemStack>();
        int startIndex = this.currentPage * 45;
        int endIndex = Math.min(startIndex + 45, this.filteredObjects.size());
        for (int i = startIndex; i < endIndex; ++i) {
            Block b = (Block)this.filteredObjects.get(i);
            ItemStack stack = (ItemStack)ReplacementControl.withSkipReplacement(() -> new ItemStack((ItemLike)b.m_5456_()));
            pageItems.add(stack);
        }
        this.itemGrid.setItems(pageItems);
        this.itemGrid.setSelectedItemIds(this.selectedIds);
    }
}

