/*
 * Decompiled with CFR 0.152.
 */
package com.sighs.oneenoughblock.api.adapter;

import com.mafuyu404.oneenoughitem.api.DomainAdapter;
import com.mafuyu404.oneenoughitem.api.DomainRuntimeCache;
import com.mafuyu404.oneenoughitem.api.ReplacementUiAdapter;
import com.mafuyu404.oneenoughitem.client.gui.ReplacementEditorScreen;
import com.mafuyu404.oneenoughitem.client.gui.cache.AbstractGlobalReplacementCache;
import com.mafuyu404.oneenoughitem.client.gui.util.GuiUtils;
import com.mafuyu404.oneenoughitem.util.ReplacementControl;
import com.sighs.oneenoughblock.api.adapter.ui.BlockReplacementUiAdapter;
import com.sighs.oneenoughblock.client.gui.BlockSelectionScreen;
import com.sighs.oneenoughblock.client.gui.BlockTagSelectionScreen;
import com.sighs.oneenoughblock.client.gui.cache.GlobalBlockReplacementCache;
import com.sighs.oneenoughblock.init.BlockReplacementCache;
import java.util.Collection;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockDomainAdapter
implements DomainAdapter {
    public String modId() {
        return "oneenoughblock";
    }

    public String id() {
        return "oeb";
    }

    public String dataId() {
        return "Blocks";
    }

    public Component selectObjectLabel() {
        return Component.m_237115_((String)"gui.oneenoughblock.add_block");
    }

    public Component selectTagLabel() {
        return Component.m_237115_((String)"gui.oneenoughblock.add_block_tag");
    }

    @OnlyIn(value=Dist.CLIENT)
    public Screen createObjectSelectionScreen(ReplacementEditorScreen parent, boolean isForMatch) {
        return new BlockSelectionScreen(parent, isForMatch);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Screen createTagSelectionScreen(ReplacementEditorScreen parent, boolean isForMatch) {
        return new BlockTagSelectionScreen(parent, isForMatch);
    }

    public boolean isAvailable() {
        return true;
    }

    public AbstractGlobalReplacementCache globalCache() {
        return GlobalBlockReplacementCache.get();
    }

    public DomainRuntimeCache runtimeCache() {
        return new DomainRuntimeCache(){

            public String matchData(String id) {
                return BlockReplacementCache.matchBlock(id);
            }

            public String matchTag(ResourceLocation tagId) {
                return BlockReplacementCache.matchTag(tagId);
            }

            public void removeReplacements(Collection<String> dataIds, Collection<String> tagIds) {
                BlockReplacementCache.removeReplacements(dataIds, tagIds);
            }

            public boolean isTagReplaced(String tagId) {
                return BlockReplacementCache.isTagReplaced(tagId);
            }

            public boolean isTagReplaced(ResourceLocation tagId) {
                return BlockReplacementCache.isTagReplaced(tagId);
            }
        };
    }

    public String dataIdFromItem(Item item) {
        if (item instanceof BlockItem) {
            BlockItem bi = (BlockItem)item;
            ResourceLocation key = ForgeRegistries.BLOCKS.getKey((Object)bi.m_40614_());
            return key != null ? key.toString() : null;
        }
        return null;
    }

    public ItemStack iconForDataId(String dataId) {
        Block block;
        ResourceLocation rl = ResourceLocation.m_135820_((String)dataId);
        Block block2 = block = rl != null ? (Block)ForgeRegistries.BLOCKS.getValue(rl) : null;
        if (block == null) {
            return ItemStack.f_41583_;
        }
        return (ItemStack)ReplacementControl.withSkipReplacement(() -> new ItemStack((ItemLike)block.m_5456_()));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void renderDataId(GuiGraphics graphics, String dataId, int x, int y) {
        ItemStack stack = this.iconForDataId(dataId);
        GuiUtils.drawItemBox((GuiGraphics)graphics, (int)x, (int)y, (int)18, (int)18);
        graphics.m_280480_(stack, x + 1, y + 1);
        graphics.m_280370_(Minecraft.m_91087_().f_91062_, stack, x + 1, y + 1);
    }

    public Component displayName(String dataId) {
        Block block;
        ResourceLocation rl = ResourceLocation.m_135820_((String)dataId);
        Block block2 = block = rl != null ? (Block)ForgeRegistries.BLOCKS.getValue(rl) : null;
        if (block == null) {
            return Component.m_237113_((String)dataId);
        }
        ItemStack stack = new ItemStack((ItemLike)block.m_5456_());
        return stack.m_41786_();
    }

    public ReplacementUiAdapter uiAdapter() {
        return new BlockReplacementUiAdapter(this.runtimeCache(), this.globalCache());
    }
}

