/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import com.google.common.collect.Streams;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Random;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.RecipeBookCategories;
import net.minecraft.core.BlockPos;
import net.minecraft.core.BlockSource;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.BlockParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleType;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.nbt.TagParser;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientboundExplodePacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.util.GsonHelper;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.DirectionalPlaceContext;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.ExplosionDamageCalculator;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FallingBlock;
import net.minecraft.world.level.block.PointedDripstoneBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.event.RegisterRecipeBookCategoriesEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IIngredientSerializer;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLEnvironment;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.NewRegistryEvent;
import net.minecraftforge.registries.RegisterEvent;
import net.minecraftforge.registries.RegistryManager;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.ContextualConditionTypes;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeConfig;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.LycheeTags;
import snownee.lychee.PostActionTypes;
import snownee.lychee.RecipeSerializers;
import snownee.lychee.RecipeTypes;
import snownee.lychee.compat.IngredientInfo;
import snownee.lychee.compat.forge.AlwaysTrueIngredient;
import snownee.lychee.core.contextual.CustomCondition;
import snownee.lychee.core.post.CustomAction;
import snownee.lychee.core.post.Explode;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.dripstone_dripping.DripstoneRecipeMod;
import snownee.lychee.interaction.InteractionRecipeMod;
import snownee.lychee.item_exploding.ItemExplodingRecipe;
import snownee.lychee.mixin.RecipeManagerAccess;
import snownee.lychee.util.ClientProxy;

@Mod(value="lychee")
public class CommonProxy {
    private static final Random RANDOM = new Random();
    private static final List<CustomActionListener> customActionListeners = ObjectArrayList.of();
    private static final List<CustomConditionListener> customConditionListeners = ObjectArrayList.of();
    public static boolean hasKiwi = CommonProxy.isModLoaded("kiwi");
    public static boolean hasDFLib = CommonProxy.isModLoaded("dripstone_fluid_lib");
    private static RecipeManager recipeManager;

    public CommonProxy() {
        Objects.requireNonNull(LycheeTags.FIRE_IMMUNE);
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(CommonProxy::newRegistries);
        modEventBus.addListener(CommonProxy::register);
        modEventBus.addListener(CommonProxy::registerRecipeBookCategories);
        MinecraftForge.EVENT_BUS.addListener(event -> {
            InteractionResult result = InteractionRecipeMod.useItemOn(event.getEntity(), event.getLevel(), event.getHand(), event.getHitVec());
            event.setCanceled(result.m_19077_());
            event.setCancellationResult(result);
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            InteractionResult result = InteractionRecipeMod.clickItemOn(event.getEntity(), event.getLevel(), event.getHand(), event.getPos(), event.getFace());
            event.setCanceled(result.m_19077_());
            event.setCancellationResult(result);
        });
        MinecraftForge.EVENT_BUS.addListener(event -> {
            Explosion explosion = event.getExplosion();
            ItemExplodingRecipe.on(event.getLevel(), explosion.f_46013_, explosion.f_46014_, explosion.f_46015_, event.getAffectedEntities(), explosion.f_46017_);
        });
        if (CommonProxy.isPhysicalClient()) {
            ClientProxy.init();
        }
    }

    public static void newRegistries(NewRegistryEvent event) {
        LycheeRegistries.init(event);
    }

    public static void register(RegisterEvent event) {
        event.register(LycheeRegistries.CONTEXTUAL.key(), helper -> Objects.requireNonNull(ContextualConditionTypes.CHANCE));
        event.register(LycheeRegistries.POST_ACTION.key(), helper -> {
            Objects.requireNonNull(PostActionTypes.DROP_ITEM);
            if (CommonProxy.isPhysicalClient()) {
                ClientProxy.registerPostActionRenderers();
            }
        });
        event.register(ForgeRegistries.RECIPE_SERIALIZERS.getRegistryKey(), helper -> {
            Objects.requireNonNull(RecipeSerializers.ITEM_BURNING);
            CraftingHelper.register((ResourceLocation)new ResourceLocation("lychee", "always_true"), (IIngredientSerializer)AlwaysTrueIngredient.Serializer.INSTANCE);
        });
        event.register(ForgeRegistries.RECIPE_TYPES.getRegistryKey(), helper -> RecipeTypes.init());
        event.register(ForgeRegistries.PARTICLE_TYPES.getRegistryKey(), helper -> {
            helper.register(new ResourceLocation("lychee", "dripstone_dripping"), DripstoneRecipeMod.DRIPSTONE_DRIPPING);
            helper.register(new ResourceLocation("lychee", "dripstone_falling"), DripstoneRecipeMod.DRIPSTONE_FALLING);
            helper.register(new ResourceLocation("lychee", "dripstone_splash"), DripstoneRecipeMod.DRIPSTONE_SPLASH);
        });
    }

    public static void registerRecipeBookCategories(RegisterRecipeBookCategoriesEvent event) {
        Function<Recipe, RecipeBookCategories> lookup = $ -> RecipeBookCategories.UNKNOWN;
        RecipeTypes.ALL.forEach($ -> event.registerRecipeCategoryFinder((RecipeType)$, lookup));
    }

    public static void dropItemStack(Level pLevel, double pX, double pY, double pZ, ItemStack pStack, @Nullable Consumer<ItemEntity> extraStep) {
        while (!pStack.m_41619_()) {
            ItemEntity itementity = new ItemEntity(pLevel, pX, pY, pZ, pStack.m_41620_(Math.min(RANDOM.nextInt(21) + 10, pStack.m_41741_())));
            itementity.m_20334_(RANDOM.nextGaussian() * 0.05 - 0.025, RANDOM.nextGaussian() * 0.05 + 0.2, RANDOM.nextGaussian() * 0.05 - 0.025);
            if (extraStep != null) {
                extraStep.accept(itementity);
            }
            pLevel.m_7967_((Entity)itementity);
        }
    }

    public static String makeDescriptionId(String pType, @Nullable ResourceLocation pId) {
        return pId == null ? pType + ".unregistered_sadface" : pType + "." + CommonProxy.wrapNamespace(pId.m_135827_()) + "." + pId.m_135815_().replace('/', '.');
    }

    public static String wrapNamespace(String modid) {
        return "minecraft".equals(modid) ? "lychee" : modid;
    }

    public static MutableComponent white(CharSequence s) {
        return Component.m_237113_((String)s.toString()).m_130940_(ChatFormatting.WHITE);
    }

    public static String chance(float chance) {
        return ((double)chance < 0.01 ? "<1" : String.valueOf((int)(chance * 100.0f))) + "%";
    }

    public static String capitaliseAllWords(String str) {
        int sz = str.length();
        StringBuilder buffer = new StringBuilder(sz);
        boolean space = true;
        for (int i = 0; i < sz; ++i) {
            char ch = str.charAt(i);
            if (Character.isWhitespace(ch)) {
                buffer.append(ch);
                space = true;
                continue;
            }
            if (space) {
                buffer.append(Character.toTitleCase(ch));
                space = false;
                continue;
            }
            buffer.append(ch);
        }
        return buffer.toString();
    }

    public static <T> T getCycledItem(List<T> list, T fallback, int interval) {
        if (list.isEmpty()) {
            return fallback;
        }
        if (list.size() == 1) {
            return list.get(0);
        }
        long index = System.currentTimeMillis() / (long)interval % (long)list.size();
        return list.get(Math.toIntExact(index));
    }

    public static ResourceLocation readNullableRL(FriendlyByteBuf buf) {
        String string = buf.m_130277_();
        if (string.isEmpty()) {
            return null;
        }
        return new ResourceLocation(string);
    }

    public static void writeNullableRL(ResourceLocation rl, FriendlyByteBuf buf) {
        if (rl == null) {
            buf.m_130070_("");
        } else {
            buf.m_130070_(rl.toString());
        }
    }

    public static InteractionResult interactionResult(Boolean bool) {
        if (bool == null) {
            return InteractionResult.PASS;
        }
        return bool != false ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    public static <T> T readRegistryId(LycheeRegistries.MappedRegistry<T> registry, FriendlyByteBuf buf) {
        return (T)buf.readRegistryIdUnsafe(registry.registry());
    }

    public static <T> void writeRegistryId(LycheeRegistries.MappedRegistry<T> registry, T entry, FriendlyByteBuf buf) {
        buf.writeRegistryIdUnsafe(registry.registry(), entry);
    }

    public static <T> T readRegistryId(Registry<T> registry, FriendlyByteBuf buf) {
        return (T)buf.readRegistryIdUnsafe((IForgeRegistry)RegistryManager.ACTIVE.getRegistry(registry.m_123023_()));
    }

    public static <T> void writeRegistryId(Registry<T> registry, T entry, FriendlyByteBuf buf) {
        buf.writeRegistryIdUnsafe((IForgeRegistry)RegistryManager.ACTIVE.getRegistry(registry.m_123023_()), entry);
    }

    public static RecipeManager recipeManager() {
        if (recipeManager == null && FMLEnvironment.dist.isClient()) {
            if (LycheeConfig.debug) {
                Lychee.LOGGER.trace("Early loading recipes..");
            }
            recipeManager = Minecraft.m_91087_().m_91403_().m_105141_();
        }
        return recipeManager;
    }

    public static void setRecipeManager(RecipeManager recipeManager, boolean fromServer) {
        if (!fromServer && CommonProxy.isPhysicalClient() && ClientProxy.isSinglePlayer()) {
            return;
        }
        CommonProxy.recipeManager = recipeManager;
        if (LycheeConfig.debug) {
            Lychee.LOGGER.trace("Setting recipe manager..");
        }
    }

    public static Recipe<?> recipe(ResourceLocation id) {
        return CommonProxy.recipeManager().m_44043_(id).orElse(null);
    }

    public static <T extends Recipe<?>> Collection<T> recipes(RecipeType<T> type) {
        return ((RecipeManagerAccess)CommonProxy.recipeManager()).callByType(type).values();
    }

    public static BlockPos getOnPos(Entity entity) {
        int i = Mth.m_14107_((double)entity.m_20185_());
        int j = Mth.m_14107_((double)(entity.m_20186_() - 0.05));
        int k = Mth.m_14107_((double)entity.m_20189_());
        BlockPos blockpos = new BlockPos(i, j, k);
        if (entity.m_9236_().m_46859_(blockpos)) {
            BlockPos blockpos1 = blockpos.m_7495_();
            BlockState blockstate = entity.m_9236_().m_8055_(blockpos1);
            if (blockstate.collisionExtendsVertically((BlockGetter)entity.m_9236_(), blockpos1, entity)) {
                return blockpos1;
            }
        }
        return blockpos;
    }

    public static Vec3 clampPos(Vec3 origin, BlockPos pos) {
        double x = CommonProxy.clamp(origin.f_82479_, pos.m_123341_());
        double y = CommonProxy.clamp(origin.f_82480_, pos.m_123342_());
        double z = CommonProxy.clamp(origin.f_82481_, pos.m_123343_());
        if (x == origin.f_82479_ && y == origin.f_82480_ && z == origin.f_82481_) {
            return origin;
        }
        return new Vec3(x, y, z);
    }

    private static double clamp(double v, int target) {
        if (v < (double)target) {
            return target;
        }
        if (v >= (double)(target + 1)) {
            return (double)target + 0.999999;
        }
        return v;
    }

    public static <T> List<T> tagElements(Registry<T> registry, TagKey<T> tag) {
        return Streams.stream((Iterable)registry.m_206058_(tag)).map(Holder::m_203334_).toList();
    }

    public static boolean isSimpleIngredient(Ingredient ingredient) {
        return ingredient.isSimple();
    }

    public static BlockPos parseOffset(JsonObject o) {
        int x = GsonHelper.m_13824_((JsonObject)o, (String)"offsetX", (int)0);
        int y = GsonHelper.m_13824_((JsonObject)o, (String)"offsetY", (int)0);
        int z = GsonHelper.m_13824_((JsonObject)o, (String)"offsetZ", (int)0);
        BlockPos offset = BlockPos.f_121853_;
        if (x != 0 || y != 0 || z != 0) {
            offset = new BlockPos(x, y, z);
        }
        return offset;
    }

    public static boolean isPhysicalClient() {
        return FMLEnvironment.dist.isClient();
    }

    public static void itemstackToJson(ItemStack stack, JsonObject jsonObject) {
        jsonObject.addProperty("item", BuiltInRegistries.f_257033_.m_7981_((Object)stack.m_41720_()).toString());
        if (stack.m_41782_()) {
            jsonObject.addProperty("nbt", stack.m_41783_().toString());
        }
        if (stack.m_41613_() > 1) {
            jsonObject.addProperty("count", (Number)stack.m_41613_());
        }
    }

    public static boolean isModLoaded(String modid) {
        return ModList.get().isLoaded(modid);
    }

    public static JsonObject tagToJson(CompoundTag tag) {
        return ((JsonElement)NbtOps.f_128958_.convertTo((DynamicOps)JsonOps.INSTANCE, (Tag)tag)).getAsJsonObject();
    }

    public static CompoundTag jsonToTag(JsonElement json) {
        if (json.isJsonObject()) {
            return (CompoundTag)JsonOps.INSTANCE.convertTo((DynamicOps)NbtOps.f_128958_, json);
        }
        try {
            return TagParser.m_129359_((String)json.getAsString());
        }
        catch (CommandSyntaxException e) {
            throw new IllegalArgumentException(e);
        }
    }

    public static synchronized void registerCustomActionListener(CustomActionListener listener) {
        customActionListeners.add(listener);
    }

    public static synchronized void registerCustomConditionListener(CustomConditionListener listener) {
        customConditionListeners.add(listener);
    }

    public static synchronized void postCustomActionEvent(String id, CustomAction action, ILycheeRecipe<?> recipe, ILycheeRecipe.NBTPatchContext patchContext) {
        for (CustomActionListener listener : customActionListeners) {
            if (!listener.on(id, action, recipe, patchContext)) continue;
            return;
        }
    }

    public static synchronized void postCustomConditionEvent(String id, CustomCondition condition) {
        for (CustomConditionListener listener : customConditionListeners) {
            if (!listener.on(id, condition)) continue;
            return;
        }
    }

    public static boolean hasModdedDripParticle(FluidState fluid) {
        return false;
    }

    public static IngredientInfo.Type getIngredientType(Ingredient ingredient) {
        if (ingredient == LycheeRecipe.Serializer.AIR_INGREDIENT) {
            return IngredientInfo.Type.AIR;
        }
        if (ingredient.getSerializer() == AlwaysTrueIngredient.Serializer.INSTANCE) {
            return IngredientInfo.Type.ANY;
        }
        return IngredientInfo.Type.NORMAL;
    }

    public static boolean dispensePlacement(BlockSource pSource, ItemStack pStack, Direction direction) {
        Item item = pStack.m_41720_();
        if (!(item instanceof BlockItem)) {
            return false;
        }
        BlockItem item2 = (BlockItem)item;
        BlockPos blockpos = pSource.m_7961_().m_121945_(direction);
        BlockState state = pSource.m_7727_().m_8055_(blockpos);
        if (!FallingBlock.m_53241_((BlockState)state)) {
            return false;
        }
        Block block = item2.m_40614_();
        if (block instanceof PointedDripstoneBlock) {
            PointedDripstoneBlock block2 = (PointedDripstoneBlock)block;
            BlockState blockState = (BlockState)block2.m_49966_().m_61124_((Property)PointedDripstoneBlock.f_154009_, (Comparable)Direction.DOWN);
            FallingBlockEntity entity = FallingBlockEntity.m_201971_((Level)pSource.m_7727_(), (BlockPos)blockpos, (BlockState)blockState);
            float f = 6.0f;
            entity.m_149656_(f, 40);
            pStack.m_41774_(1);
            return true;
        }
        try {
            return item2.m_40576_((BlockPlaceContext)new DirectionalPlaceContext((Level)pSource.m_7727_(), blockpos, direction, pStack, direction)).m_19077_();
        }
        catch (Exception exception) {
            Lychee.LOGGER.error("Error trying to place block at {}", (Object)blockpos, (Object)exception);
            return false;
        }
    }

    public static void explode(Explode action, ServerLevel level, Vec3 pos, @Nullable Entity entity, @Nullable DamageSource damageSource, @Nullable ExplosionDamageCalculator damageCalculator, float radius) {
        Explosion explosion = new Explosion((Level)level, entity, damageSource, damageCalculator, pos.f_82479_, pos.f_82480_, pos.f_82481_, radius, action.fire, action.blockInteraction);
        explosion.m_46061_();
        explosion.m_46075_(true);
        if (!explosion.m_254884_()) {
            explosion.m_46080_();
        }
        for (ServerPlayer player : level.m_6907_()) {
            if (!(player.m_20238_(pos) < 4096.0)) continue;
            player.f_8906_.m_9829_((Packet)new ClientboundExplodePacket(pos.f_82479_, pos.f_82480_, pos.f_82481_, radius, explosion.m_46081_(), (Vec3)explosion.m_46078_().get(player)));
        }
    }

    public static ParticleType<BlockParticleOption> registerParticleType(ParticleOptions.Deserializer<BlockParticleOption> deserializer) {
        return new ParticleType<BlockParticleOption>(false, deserializer){

            public Codec<BlockParticleOption> m_7652_() {
                return BlockParticleOption.m_123634_((ParticleType)this);
            }
        };
    }

    public static interface CustomActionListener {
        public boolean on(String var1, CustomAction var2, ILycheeRecipe<?> var3, ILycheeRecipe.NBTPatchContext var4);
    }

    public static interface CustomConditionListener {
        public boolean on(String var1, CustomCondition var2);
    }
}

