/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.text.MessageFormat;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.Util;
import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import snownee.lychee.PostActionTypes;
import snownee.lychee.client.core.post.CycleStatePropertyPostActionRenderer;
import snownee.lychee.client.core.post.IfPostActionRenderer;
import snownee.lychee.client.core.post.PlaceBlockPostActionRenderer;
import snownee.lychee.client.core.post.PostActionRenderer;
import snownee.lychee.compat.IngredientInfo;
import snownee.lychee.core.post.input.DamageItem;
import snownee.lychee.core.post.input.PreventDefault;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.core.recipe.LycheeRecipe;
import snownee.lychee.dripstone_dripping.DripstoneRecipeMod;
import snownee.lychee.dripstone_dripping.client.ParticleFactories;
import snownee.lychee.util.CommonProxy;

public interface ClientProxy {
    public static final List<RecipeViewerWidgetClickListener> recipeViewerWidgetClickListeners = ObjectArrayList.of();
    public static final boolean HAS_PONDER = ModList.get().isLoaded("ponder");

    public static MutableComponent getDimensionDisplayName(ResourceKey<Level> dimension) {
        String key = Util.m_137492_((String)"dimension", (ResourceLocation)dimension.m_135782_());
        if (I18n.m_118936_((String)key)) {
            return Component.m_237115_((String)key);
        }
        return Component.m_237113_((String)CommonProxy.capitaliseAllWords(dimension.m_135782_().m_135815_()));
    }

    public static MutableComponent getStructureDisplayName(ResourceLocation rawName) {
        String key = Util.m_137492_((String)"structure", (ResourceLocation)rawName);
        if (I18n.m_118936_((String)key)) {
            return Component.m_237115_((String)key);
        }
        return Component.m_237113_((String)CommonProxy.capitaliseAllWords(rawName.m_135815_()));
    }

    public static MutableComponent format(String s, Object ... objects) {
        try {
            return Component.m_237113_((String)MessageFormat.format(I18n.m_118938_((String)s, (Object[])new Object[0]), objects));
        }
        catch (Exception e) {
            return Component.m_237110_((String)s, (Object[])objects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerInfoBadgeClickListener(RecipeViewerWidgetClickListener listener) {
        List<RecipeViewerWidgetClickListener> list = recipeViewerWidgetClickListeners;
        synchronized (list) {
            recipeViewerWidgetClickListeners.add(listener);
        }
    }

    public static boolean postInfoBadgeClickEvent(ILycheeRecipe<?> recipe, int button) {
        for (RecipeViewerWidgetClickListener listener : recipeViewerWidgetClickListeners) {
            if (!listener.onClick(recipe, button)) continue;
            return true;
        }
        return false;
    }

    public static void init() {
        IEventBus modEventBus = FMLJavaModLoadingContext.get().getModEventBus();
        modEventBus.addListener(event -> {
            event.registerSpriteSet(DripstoneRecipeMod.DRIPSTONE_DRIPPING, ParticleFactories.Dripping::new);
            event.registerSpriteSet(DripstoneRecipeMod.DRIPSTONE_FALLING, ParticleFactories.Falling::new);
            event.registerSpriteSet(DripstoneRecipeMod.DRIPSTONE_SPLASH, ParticleFactories.Splash::new);
        });
    }

    public static void registerPostActionRenderers() {
        PostActionRenderer.register(PostActionTypes.DROP_ITEM, action -> action.stack);
        PostActionRenderer.register(PostActionTypes.SET_ITEM, action -> action.stack);
        PostActionRenderer.register(PostActionTypes.DROP_XP, action -> Items.f_42612_.m_7968_());
        PostActionRenderer.register(PostActionTypes.EXECUTE, action -> Items.f_42116_.m_7968_());
        PostActionRenderer.register(PostActionTypes.EXPLODE, action -> Items.f_41996_.m_7968_());
        PostActionRenderer.register(PostActionTypes.HURT, action -> Items.f_42383_.m_7968_());
        PostActionRenderer.register(PostActionTypes.IF, new IfPostActionRenderer());
        PostActionRenderer.register(PostActionTypes.PLACE, new PlaceBlockPostActionRenderer());
        PostActionRenderer.register(PostActionTypes.CYCLE_STATE_PROPERTY, new CycleStatePropertyPostActionRenderer());
        PostActionRenderer.register(PostActionTypes.DAMAGE_ITEM, new PostActionRenderer<DamageItem>(){

            @Override
            public void loadCatalystsInfo(DamageItem action, ILycheeRecipe<?> recipe, List<IngredientInfo> ingredients) {
                String key = CommonProxy.makeDescriptionId("postAction", PostActionTypes.DAMAGE_ITEM.getRegistryName());
                MutableComponent component = Component.m_237110_((String)key, (Object[])new Object[]{action.damage}).m_130940_(ChatFormatting.YELLOW);
                Minecraft mc = Minecraft.m_91087_();
                recipe.getItemIndexes(action.target).forEach(arg_0 -> 1.lambda$loadCatalystsInfo$0(ingredients, (Component)component, action, mc, arg_0));
            }

            private static /* synthetic */ void lambda$loadCatalystsInfo$0(List ingredients, Component component, DamageItem action, Minecraft mc, int i) {
                IngredientInfo info = (IngredientInfo)ingredients.get(i);
                info.addTooltip(component);
                action.getConditionTooltips(info.tooltips, 0, (Level)mc.f_91073_, (Player)mc.f_91074_);
                info.isCatalyst = true;
            }
        });
        PostActionRenderer.register(PostActionTypes.PREVENT_DEFAULT, new PostActionRenderer<PreventDefault>(){

            @Override
            public void loadCatalystsInfo(PreventDefault action, ILycheeRecipe<?> recipe, List<IngredientInfo> ingredients) {
                LycheeRecipe lycheeRecipe;
                block4: {
                    block3: {
                        if (!(recipe instanceof LycheeRecipe)) break block3;
                        lycheeRecipe = (LycheeRecipe)recipe;
                        if (lycheeRecipe.getType().canPreventConsumeInputs) break block4;
                    }
                    return;
                }
                Minecraft mc = Minecraft.m_91087_();
                for (IngredientInfo ingredient : ingredients) {
                    if (!ingredient.tooltips.isEmpty()) continue;
                    ingredient.addTooltip(lycheeRecipe.getType().getPreventDefaultDescription(lycheeRecipe));
                    action.getConditionTooltips(ingredient.tooltips, 0, (Level)mc.f_91073_, (Player)mc.f_91074_);
                    ingredient.isCatalyst = true;
                }
            }
        });
    }

    public static boolean isSinglePlayer() {
        return Minecraft.m_91087_().m_91092_() != null;
    }

    @FunctionalInterface
    public static interface RecipeViewerWidgetClickListener {
        public boolean onClick(ILycheeRecipe<?> var1, int var2);
    }
}

