/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.util;

import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.StatePropertiesPredicate;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import snownee.lychee.mixin.BlockPredicateAccess;

public record BlockStateSet(ImmutableSet<BlockState> blockStates) implements Predicate<BlockState>
{
    public static final Predicate<BlockState> ANY = Predicates.alwaysTrue();
    public static final Predicate<BlockState> NONE = Predicates.alwaysFalse();

    public static Predicate<BlockState> of(Block block, Stream<BlockPredicate> stream) {
        List<BlockPredicate> list = stream.toList();
        if (list.isEmpty()) {
            return NONE;
        }
        for (BlockPredicate predicate : list) {
            if (((BlockPredicateAccess)predicate).getProperties() != StatePropertiesPredicate.f_67658_) continue;
            return ANY;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        block1: for (BlockState blockState : block.m_49965_().m_61056_()) {
            for (BlockPredicate predicate : list) {
                if (!((BlockPredicateAccess)predicate).getProperties().m_67667_(blockState)) continue;
                builder.add((Object)blockState);
                continue block1;
            }
        }
        ImmutableSet set = builder.build();
        if (set.isEmpty()) {
            return NONE;
        }
        return new BlockStateSet((ImmutableSet<BlockState>)set);
    }

    @Override
    public boolean test(BlockState blockState) {
        return this.blockStates.contains((Object)blockState);
    }
}

