/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.mixin;

import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.FallingBlockEntity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.AnvilBlock;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import snownee.lychee.RecipeTypes;
import snownee.lychee.block_crushing.LycheeFallingBlockEntity;

@Mixin(value={FallingBlockEntity.class})
public abstract class FallingBlockEntityMixin
extends Entity
implements LycheeFallingBlockEntity {
    @Unique
    private boolean lychee$matched;
    @Unique
    private float lychee$anvilDamageChance = -1.0f;
    @Shadow
    private boolean f_31947_;
    @Shadow
    private BlockState f_31946_;

    public FallingBlockEntityMixin(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
    }

    @Inject(at={@At(value="HEAD")}, method={"causeFallDamage"})
    private void lychee_causeFallDamage(float pFallDistance, float pMultiplier, DamageSource pSource, CallbackInfoReturnable<Boolean> ci) {
        FallingBlockEntity entity = (FallingBlockEntity)this;
        if (entity.m_9236_().f_46443_) {
            return;
        }
        RecipeTypes.BLOCK_CRUSHING.process(entity);
    }

    @ModifyVariable(at=@At(value="STORE"), method={"tick"}, index=9)
    private boolean lychee_modifyFlag3(boolean original) {
        if (this.lychee$matched) {
            return false;
        }
        return original;
    }

    @ModifyVariable(at=@At(value="STORE"), method={"causeFallDamage"}, index=10)
    private boolean lychee_overrideDamageAnvil(boolean original) {
        if (original && this.lychee$anvilDamageChance >= 0.0f) {
            if (this.f_19796_.m_188501_() < this.lychee$anvilDamageChance) {
                BlockState blockstate = AnvilBlock.m_48824_((BlockState)this.f_31946_);
                if (blockstate == null) {
                    this.f_31947_ = true;
                } else {
                    this.f_31946_ = blockstate;
                }
            }
            return false;
        }
        return original;
    }

    @Override
    public void lychee$cancelDrop() {
        this.f_31947_ = true;
    }

    @Override
    public void lychee$matched() {
        this.lychee$matched = true;
    }

    @Override
    public void lychee$anvilDamageChance(float chance) {
        this.lychee$anvilDamageChance = Math.max(chance, this.lychee$anvilDamageChance);
    }
}

