/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.mixin;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectListIterator;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;
import snownee.lychee.RecipeTypes;
import snownee.lychee.block_exploding.BlockExplodingContext;
import snownee.lychee.block_exploding.BlockExplodingRecipe;

@Mixin(value={Explosion.class}, priority=700)
public abstract class ExplosionMixin {
    @Unique
    private static final ThreadLocal<snownee.lychee.util.Pair<BlockExplodingContext.Builder, List<ItemStack>>> lychee$CONTEXT = ThreadLocal.withInitial(() -> snownee.lychee.util.Pair.of(null, null));
    @Final
    @Shadow
    private float f_46017_;
    @Final
    @Shadow
    @Nullable
    private Entity f_46016_;
    @Final
    @Shadow
    private Level f_46012_;
    @Shadow
    @Final
    private Explosion.BlockInteraction f_46010_;

    @Shadow
    private static void m_46067_(ObjectArrayList<Pair<ItemStack, BlockPos>> objectArrayList, ItemStack itemStack, BlockPos blockPos) {
        throw new AssertionError();
    }

    @Inject(method={"lambda$finalizeExplosion$0", "m_46071_"}, at={@At(value="HEAD")}, cancellable=true)
    private static void lychee_deferAddingDrops(ObjectArrayList<Pair<ItemStack, BlockPos>> objectArrayList, BlockPos blockPos, ItemStack itemStack, CallbackInfo ci) {
        snownee.lychee.util.Pair<BlockExplodingContext.Builder, List<ItemStack>> pair = lychee$CONTEXT.get();
        if (pair.getSecond() != null) {
            pair.getSecond().add(itemStack);
            ci.cancel();
        }
    }

    @Inject(method={"finalizeExplosion"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getDrops(Lnet/minecraft/world/level/storage/loot/LootParams$Builder;)Ljava/util/List;")}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void initDeferring(boolean bl, CallbackInfo ci, boolean bl2, ObjectArrayList<Pair<ItemStack, BlockPos>> objectArrayList, boolean bl3, ObjectListIterator<Pair<ItemStack, BlockPos>> var5, BlockPos blockPos, BlockState state, Block block, BlockPos blockPos2, Level level, ServerLevel serverLevel, BlockEntity blockEntity) {
        snownee.lychee.util.Pair<BlockExplodingContext.Builder, List<ItemStack>> pair = lychee$CONTEXT.get();
        if (RecipeTypes.BLOCK_EXPLODING.isEmpty() || !RecipeTypes.BLOCK_EXPLODING.has(state)) {
            pair.setSecond(null);
        } else if (pair.getFirst() == null) {
            pair.setSecond((List<ItemStack>)new ObjectArrayList());
        } else {
            pair.getSecond().clear();
        }
    }

    @Inject(method={"finalizeExplosion"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;onBlockExploded(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Explosion;)V", remap=false)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void lychee_removeBlockPre(boolean bl, CallbackInfo ci, boolean bl2, ObjectArrayList<Pair<ItemStack, BlockPos>> objectArrayList, boolean bl3, ObjectListIterator<Pair<ItemStack, BlockPos>> var5, BlockPos blockPos, BlockState state, Block block) {
        if (this.f_46012_.f_46443_ || RecipeTypes.BLOCK_EXPLODING.isEmpty() || !RecipeTypes.BLOCK_EXPLODING.has(state)) {
            return;
        }
        BlockExplodingContext.Builder builder = new BlockExplodingContext.Builder(this.f_46012_);
        builder.withParameter(LootContextParams.f_81460_, Vec3.m_82512_((Vec3i)blockPos));
        builder.withParameter(LootContextParams.f_81461_, state);
        BlockEntity blockEntity = state.m_155947_() ? this.f_46012_.m_7702_(blockPos) : null;
        builder.withOptionalParameter(LootContextParams.f_81462_, blockEntity);
        builder.withOptionalParameter(LootContextParams.f_81455_, this.f_46016_);
        if (this.f_46010_ == Explosion.BlockInteraction.DESTROY_WITH_DECAY) {
            builder.withParameter(LootContextParams.f_81464_, Float.valueOf(this.f_46017_));
        }
        lychee$CONTEXT.get().setFirst(builder);
    }

    @Inject(method={"finalizeExplosion"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;onBlockExploded(Lnet/minecraft/world/level/Level;Lnet/minecraft/core/BlockPos;Lnet/minecraft/world/level/Explosion;)V", remap=false, shift=At.Shift.AFTER)}, locals=LocalCapture.CAPTURE_FAILHARD)
    private void lychee_removeBlockPost(boolean bl, CallbackInfo ci, boolean bl2, ObjectArrayList<Pair<ItemStack, BlockPos>> objectArrayList, boolean bl3, ObjectListIterator<Pair<ItemStack, BlockPos>> var5, BlockPos blockPos, BlockState state, Block block) {
        if (this.f_46012_.f_46443_) {
            return;
        }
        snownee.lychee.util.Pair<BlockExplodingContext.Builder, List<ItemStack>> pair = lychee$CONTEXT.get();
        BlockExplodingContext.Builder ctxBuilder = pair.getFirst();
        if (ctxBuilder == null) {
            return;
        }
        pair.setFirst(null);
        snownee.lychee.util.Pair<BlockExplodingContext, BlockExplodingRecipe> result = RecipeTypes.BLOCK_EXPLODING.process(this.f_46012_, state, () -> ctxBuilder.create(RecipeTypes.BLOCK_EXPLODING.contextParamSet));
        if (result == null) {
            for (ItemStack stack : pair.getSecond()) {
                ExplosionMixin.m_46067_(objectArrayList, stack, blockPos);
            }
            return;
        }
        BlockExplodingContext ctx = result.getFirst();
        if (ctx.runtime.doDefault && pair.getSecond() != null) {
            for (ItemStack stack : pair.getSecond()) {
                ExplosionMixin.m_46067_(objectArrayList, stack, blockPos);
            }
        }
        for (ItemStack stack : ctx.itemHolders.tempList) {
            ExplosionMixin.m_46067_(objectArrayList, stack, blockPos);
        }
    }
}

