/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.mixin;

import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.RecipeTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.dripstone_dripping.DripstoneRecipe;
import snownee.lychee.random_block_ticking.RandomlyTickable;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.Pair;

@Mixin(value={BlockBehaviour.BlockStateBase.class})
public abstract class BlockStateMixin {
    @Shadow
    private boolean f_244227_;

    @Shadow
    protected abstract BlockState m_7160_();

    @Inject(method={"initCache"}, at={@At(value="RETURN")})
    private void initCache(CallbackInfo ci) {
        BlockState state = this.m_7160_();
        if (((RandomlyTickable)state.m_60734_()).lychee$isTickable(state)) {
            this.f_244227_ = true;
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"randomTick"}, cancellable=true)
    private void randomTick(ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource, CallbackInfo ci) {
        Supplier<LycheeContext> ctxSupplier;
        Pair result;
        BlockState state = this.m_7160_();
        RandomlyTickable block = (RandomlyTickable)state.m_60734_();
        if (block.lychee$isTickable(state) && (result = RecipeTypes.RANDOM_BLOCK_TICKING.process((Level)serverLevel, state, ctxSupplier = () -> {
            LycheeContext.Builder builder = new LycheeContext.Builder((Level)serverLevel);
            builder.withRandom(randomSource);
            builder.withParameter(LootContextParams.f_81461_, state);
            builder.withParameter(LootContextParams.f_81460_, Vec3.m_82512_((Vec3i)blockPos));
            builder.withParameter(LycheeLootContextParams.BLOCK_POS, blockPos);
            return builder.create(RecipeTypes.RANDOM_BLOCK_TICKING.contextParamSet);
        })) != null && !result.getFirst().runtime.doDefault) {
            ci.cancel();
        }
        if (CommonProxy.hasDFLib && DripstoneRecipe.safeTick(state, serverLevel, blockPos, randomSource)) {
            ci.cancel();
        }
    }
}

