/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.recipe;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.advancements.critereon.MinMaxBounds;
import net.minecraft.core.RegistryAccess;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.Lychee;
import snownee.lychee.LycheeConfig;
import snownee.lychee.LycheeRegistries;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualHolder;
import snownee.lychee.core.def.IntBoundsHelper;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.core.recipe.type.LycheeRecipeType;
import snownee.lychee.fragment.Fragments;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.json.JsonPointer;

public abstract class LycheeRecipe<C extends LycheeContext>
extends ContextualHolder
implements ILycheeRecipe<C>,
Recipe<C> {
    private final ResourceLocation id;
    public boolean ghost;
    public boolean hideInRecipeViewer;
    @Nullable
    public String comment;
    public String group = "default";
    protected MinMaxBounds.Ints maxRepeats = MinMaxBounds.Ints.f_55364_;
    protected List<PostAction> actions = List.of();

    public LycheeRecipe(ResourceLocation id) {
        this.id = id;
        if (LycheeConfig.debug) {
            Lychee.LOGGER.debug("Construct recipe: {}", (Object)id);
        }
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public boolean m_8004_(int width, int height) {
        return true;
    }

    public ItemStack assemble(C inv, RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return ItemStack.f_41583_;
    }

    public void addPostAction(PostAction action) {
        Objects.requireNonNull(action);
        if (this.actions.isEmpty()) {
            this.actions = Lists.newArrayList();
        }
        if (!action.canRepeat()) {
            this.maxRepeats = IntBoundsHelper.ONE;
        }
        this.actions.add(action);
    }

    @Override
    public Stream<PostAction> getPostActions() {
        return this.actions.stream();
    }

    @Override
    public ContextualHolder getContextualHolder() {
        return this;
    }

    @Override
    @Nullable
    public String getComment() {
        return this.comment;
    }

    public MinMaxBounds.Ints getMaxRepeats() {
        return this.maxRepeats;
    }

    public int getRandomRepeats(int max, C ctx) {
        int times = Integer.MAX_VALUE;
        if (!this.maxRepeats.m_55327_()) {
            times = IntBoundsHelper.random(this.maxRepeats, ((LycheeContext)ctx).getRandom());
        }
        return Math.min(max, times);
    }

    @Override
    public boolean showInRecipeViewer() {
        return !this.hideInRecipeViewer;
    }

    public boolean tickOrApply(C ctx) {
        return true;
    }

    @Override
    public IntList getItemIndexes(JsonPointer pointer) {
        int size = this.m_7527_().size();
        if (pointer.size() == 1 && pointer.getString(0).equals("item_in")) {
            return IntList.of((int[])IntStream.range(0, size).toArray());
        }
        if (pointer.size() == 2 && pointer.getString(0).equals("item_in")) {
            try {
                return IntList.of((int)pointer.getInt(1));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return IntList.of();
    }

    @Override
    public Map<JsonPointer, List<PostAction>> getActionGroups() {
        return Map.of(POST, this.actions);
    }

    public abstract LycheeRecipeType<?, ?> getType();

    public abstract Serializer<?> getSerializer();

    public static abstract class Serializer<R extends LycheeRecipe<?>>
    implements RecipeSerializer<R> {
        public static final Ingredient AIR_INGREDIENT = Ingredient.m_43938_(Stream.of(new Ingredient.ItemValue(Items.f_41852_.m_7968_())));
        protected final Function<ResourceLocation, R> factory;

        public Serializer(Function<ResourceLocation, R> factory) {
            this.factory = factory;
        }

        public static Ingredient parseIngredientOrAir(JsonElement element) {
            JsonObject object;
            if (element instanceof JsonObject && !(object = (JsonObject)element).has("type") && object.has("item") && "minecraft:air".equals(Objects.toString(ResourceLocation.m_135820_((String)object.get("item").getAsString())))) {
                return AIR_INGREDIENT;
            }
            return Ingredient.m_43917_((JsonElement)element);
        }

        public static void actionsToNetwork(FriendlyByteBuf buf, List<PostAction> actions) {
            actions = actions.stream().filter(Predicate.not(PostAction::preventSync)).toList();
            buf.m_130130_(actions.size());
            for (PostAction action : actions) {
                PostActionType<?> type = action.getType();
                CommonProxy.writeRegistryId(LycheeRegistries.POST_ACTION, type, buf);
                type.toNetwork(action, buf);
                action.conditionsToNetwork(buf);
            }
        }

        public static void actionsFromNetwork(FriendlyByteBuf buf, Consumer<PostAction> consumer) {
            int size = buf.m_130242_();
            for (int i = 0; i < size; ++i) {
                PostActionType<?> type = CommonProxy.readRegistryId(LycheeRegistries.POST_ACTION, buf);
                Object action = type.fromNetwork(buf);
                ((ContextualHolder)action).conditionsFromNetwork(buf);
                consumer.accept((PostAction)action);
            }
        }

        public final R fromJson(ResourceLocation pRecipeId, JsonObject jsonObject) {
            Fragments.INSTANCE.process((JsonElement)jsonObject);
            LycheeRecipe recipe = (LycheeRecipe)this.factory.apply(pRecipeId);
            recipe.hideInRecipeViewer = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"hide_in_viewer", (boolean)false);
            recipe.ghost = GsonHelper.m_13855_((JsonObject)jsonObject, (String)"ghost", (boolean)false);
            recipe.comment = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"comment", null);
            recipe.group = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)recipe.group);
            Preconditions.checkArgument((boolean)ResourceLocation.m_135830_((String)recipe.group), (String)"%s is not a valid ResourceLocation", (Object)recipe.group);
            recipe.parseConditions(jsonObject.get("contextual"));
            PostAction.parseActions(jsonObject.get("post"), recipe::addPostAction);
            this.fromJson(recipe, jsonObject);
            ILycheeRecipe.processActions(recipe, jsonObject);
            if (jsonObject.has("max_repeats")) {
                recipe.maxRepeats = MinMaxBounds.Ints.m_55373_((JsonElement)jsonObject.get("max_repeats"));
                Integer min = (Integer)recipe.maxRepeats.m_55305_();
                Preconditions.checkArgument((min != null && min > 0 ? 1 : 0) != 0, (Object)"Min value of max_repeats should be greater than 0");
            }
            return (R)recipe;
        }

        public abstract void fromJson(R var1, JsonObject var2);

        public final R fromNetwork(ResourceLocation id, FriendlyByteBuf buf) {
            try {
                LycheeRecipe recipe = (LycheeRecipe)this.factory.apply(id);
                if (LycheeConfig.debug) {
                    Lychee.LOGGER.debug("Read recipe: {}", (Object)id);
                }
                recipe.hideInRecipeViewer = buf.readBoolean();
                if (recipe.hideInRecipeViewer && !recipe.getType().requiresClient) {
                    return (R)recipe;
                }
                recipe.conditionsFromNetwork(buf);
                Serializer.actionsFromNetwork(buf, recipe::addPostAction);
                recipe.comment = buf.m_130277_();
                recipe.group = buf.m_130277_();
                this.fromNetwork(recipe, buf);
                return (R)recipe;
            }
            catch (Exception e) {
                Lychee.LOGGER.error("Exception while reading Lychee recipe: " + String.valueOf(id), (Throwable)e);
                return null;
            }
        }

        public abstract void fromNetwork(R var1, FriendlyByteBuf var2);

        public final void toNetwork(FriendlyByteBuf buf, R recipe) {
            if (LycheeConfig.debug) {
                Lychee.LOGGER.debug("Write recipe: {}", (Object)((LycheeRecipe)recipe).m_6423_());
            }
            buf.writeBoolean(((LycheeRecipe)recipe).hideInRecipeViewer);
            if (((LycheeRecipe)recipe).hideInRecipeViewer && !((LycheeRecipe)recipe).getType().requiresClient) {
                return;
            }
            ((ContextualHolder)recipe).conditionsToNetwork(buf);
            Serializer.actionsToNetwork(buf, ((LycheeRecipe)recipe).actions);
            buf.m_130070_(Strings.nullToEmpty((String)((LycheeRecipe)recipe).comment));
            buf.m_130070_(((LycheeRecipe)recipe).group);
            this.toNetwork0(buf, recipe);
        }

        public abstract void toNetwork0(FriendlyByteBuf var1, R var2);

        public ResourceLocation getRegistryName() {
            return BuiltInRegistries.f_256769_.m_7981_((Object)this);
        }
    }
}

