/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post;

import com.google.gson.JsonObject;
import com.mojang.brigadier.ParseResults;
import net.minecraft.commands.CommandSource;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import snownee.lychee.PostActionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;

public class Execute
extends PostAction {
    public static final Execute DUMMY = new Execute("", false, false);
    public static final Component DEFAULT_NAME = Component.m_237113_((String)"lychee");
    private final String command;
    private final boolean hide;
    private final boolean repeat;

    public Execute(String command, boolean hide, boolean repeat) {
        this.command = command;
        this.hide = hide;
        this.repeat = repeat;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.EXECUTE;
    }

    @Override
    public void doApply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        this.apply(recipe, ctx, times);
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        Vec3 pos;
        if (this.command.isEmpty()) {
            return;
        }
        if (!this.repeat) {
            times = 1;
        }
        if ((pos = (Vec3)ctx.getParamOrNull(LootContextParams.f_81460_)) == null) {
            pos = Vec3.f_82478_;
        }
        Entity entity = (Entity)ctx.getParamOrNull(LootContextParams.f_81455_);
        Vec2 rotation = Vec2.f_82462_;
        Component displayName = DEFAULT_NAME;
        String name = "lychee";
        if (entity != null) {
            rotation = entity.m_20155_();
            displayName = entity.m_5446_();
            name = entity.m_7755_().getString();
        }
        CommandSourceStack sourceStack = new CommandSourceStack(CommandSource.f_80164_, pos, rotation, ctx.getServerLevel(), 2, name, displayName, ctx.getServerLevel().m_7654_(), entity);
        for (int i = 0; i < times; ++i) {
            Commands cmds = ctx.getServerLevel().m_7654_().m_129892_();
            ParseResults results = cmds.m_82094_().parse(this.command, (Object)sourceStack);
            cmds.m_242674_(results, this.command);
        }
    }

    @Override
    public boolean preventSync() {
        return this.hide;
    }

    public static class Type
    extends PostActionType<Execute> {
        @Override
        public Execute fromJson(JsonObject o) {
            return new Execute(GsonHelper.m_13906_((JsonObject)o, (String)"command"), GsonHelper.m_13855_((JsonObject)o, (String)"hide", (boolean)false), GsonHelper.m_13855_((JsonObject)o, (String)"repeat", (boolean)true));
        }

        @Override
        public void toJson(Execute action, JsonObject o) {
            o.addProperty("command", action.command);
            if (action.hide) {
                o.addProperty("hide", Boolean.valueOf(true));
            }
            if (!action.repeat) {
                o.addProperty("repeat", Boolean.valueOf(false));
            }
        }

        @Override
        public Execute fromNetwork(FriendlyByteBuf buf) {
            if (buf.readBoolean()) {
                return new Execute("", false, false);
            }
            return DUMMY;
        }

        @Override
        public void toNetwork(Execute action, FriendlyByteBuf buf) {
            buf.writeBoolean(!action.getConditions().isEmpty());
        }
    }
}

