/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.post;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.List;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.Vec3;
import snownee.lychee.LycheeLootContextParams;
import snownee.lychee.LycheeTags;
import snownee.lychee.PostActionTypes;
import snownee.lychee.block_crushing.BlockCrushingRecipe;
import snownee.lychee.block_exploding.BlockExplodingContext;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.post.PostActionType;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.mixin.ItemEntityAccess;
import snownee.lychee.util.CommonProxy;
import snownee.lychee.util.json.JsonPointer;

public class DropItem
extends PostAction {
    public final ItemStack stack;

    public DropItem(ItemStack stack) {
        this.stack = stack;
    }

    @Override
    public PostActionType<?> getType() {
        return PostActionTypes.DROP_ITEM;
    }

    @Override
    public void doApply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        this.apply(recipe, ctx, times);
    }

    @Override
    protected void apply(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        BlockState landingBlock;
        Vec3 pos = (Vec3)ctx.getParam(LootContextParams.f_81460_);
        if (recipe instanceof BlockCrushingRecipe && (landingBlock = (BlockState)ctx.getParam(LootContextParams.f_81461_)).m_204336_(LycheeTags.EXTEND_BOX)) {
            pos = Vec3.m_82512_((Vec3i)((Vec3i)ctx.getParam(LycheeLootContextParams.BLOCK_POS)));
        }
        ItemStack stack = this.path == null ? this.stack.m_41777_() : ItemStack.m_41712_((CompoundTag)CommonProxy.jsonToTag(new JsonPointer(this.path).find((JsonElement)ctx.json)));
        stack.m_41764_(stack.m_41613_() * times);
        if (ctx.getClass() == BlockExplodingContext.class) {
            ctx.itemHolders.tempList.add(stack);
        } else {
            CommonProxy.dropItemStack(ctx.getLevel(), pos.f_82479_, pos.f_82480_, pos.f_82481_, stack, $ -> ((ItemEntityAccess)$).setHealth(80));
        }
    }

    @Override
    public Component getDisplayName() {
        return this.stack.m_41786_();
    }

    @Override
    public List<ItemStack> getItemOutputs() {
        return List.of(this.stack);
    }

    @Override
    public JsonElement provideJsonInfo(ILycheeRecipe<?> recipe, JsonPointer pointer, JsonObject recipeObject) {
        this.path = pointer.toString();
        return CommonProxy.tagToJson(this.stack.m_41739_(new CompoundTag()));
    }

    public static class Type
    extends PostActionType<DropItem> {
        @Override
        public DropItem fromJson(JsonObject o) {
            return new DropItem(ShapedRecipe.m_151274_((JsonObject)o));
        }

        @Override
        public void toJson(DropItem action, JsonObject o) {
            CommonProxy.itemstackToJson(action.stack, o);
        }

        @Override
        public DropItem fromNetwork(FriendlyByteBuf buf) {
            return new DropItem(buf.m_130267_());
        }

        @Override
        public void toNetwork(DropItem action, FriendlyByteBuf buf) {
            buf.m_130055_(action.stack);
        }
    }
}

