/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core.contextual;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntImmutableList;
import it.unimi.dsi.fastutil.ints.IntList;
import java.util.List;
import java.util.stream.IntStream;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.Difficulty;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;
import snownee.lychee.ContextualConditionTypes;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.contextual.ContextualCondition;
import snownee.lychee.core.contextual.ContextualConditionType;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.CommonProxy;

public record IsDifficulty(IntImmutableList difficulties) implements ContextualCondition
{
    @Override
    public ContextualConditionType<? extends ContextualCondition> getType() {
        return ContextualConditionTypes.DIFFICULTY;
    }

    @Override
    public int test(ILycheeRecipe<?> recipe, LycheeContext ctx, int times) {
        return this.difficulties.contains(ctx.getLevel().m_46791_().m_19028_()) ? times : 0;
    }

    @Override
    public InteractionResult testInTooltips(Level level, @Nullable Player player) {
        return this.difficulties.contains(level.m_46791_().m_19028_()) ? InteractionResult.SUCCESS : InteractionResult.FAIL;
    }

    @Override
    public MutableComponent getDescription(boolean inverted) {
        Object key = this.makeDescriptionId(inverted);
        List<String> names = this.difficulties.intParallelStream().mapToObj(Difficulty::m_19029_).map(Difficulty::m_19033_).map(Component::getString).toList();
        int size = names.size();
        if (size == 1) {
            return Component.m_237110_((String)key, (Object[])new Object[]{CommonProxy.white(names.get(0))});
        }
        StringBuilder sb = new StringBuilder();
        key = (String)key + ".more";
        for (int i = 0; i < size - 1; ++i) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(names.get(i));
        }
        return Component.m_237110_((String)key, (Object[])new Object[]{CommonProxy.white(sb), CommonProxy.white(names.get(size - 1))});
    }

    public static class Type
    extends ContextualConditionType<IsDifficulty> {
        @Override
        public IsDifficulty fromJson(JsonObject o) {
            JsonElement e = o.get("difficulty");
            if (e.isJsonPrimitive()) {
                return new IsDifficulty(IntImmutableList.of((int[])new int[]{Type.parseDifficulty(e.getAsJsonPrimitive())}));
            }
            IntArrayList list = IntArrayList.of();
            e.getAsJsonArray().forEach($ -> list.add(Type.parseDifficulty($.getAsJsonPrimitive())));
            return new IsDifficulty(new IntImmutableList((IntList)list));
        }

        @Override
        public void toJson(IsDifficulty condition, JsonObject o) {
            if (condition.difficulties().size() == 1) {
                o.addProperty("difficulty", (Number)condition.difficulties().getInt(0));
            } else {
                JsonArray array = new JsonArray();
                condition.difficulties().forEach(i -> array.add((Number)i));
                o.add("difficulty", (JsonElement)array);
            }
        }

        private static int parseDifficulty(JsonPrimitive e) {
            if (e.isNumber()) {
                return e.getAsInt();
            }
            return Difficulty.m_19031_((String)e.getAsString()).m_19028_();
        }

        @Override
        public IsDifficulty fromNetwork(FriendlyByteBuf buf) {
            int size = buf.m_130242_();
            return new IsDifficulty(IntImmutableList.toList((IntStream)IntStream.range(0, size).map($ -> buf.m_130242_())));
        }

        @Override
        public void toNetwork(IsDifficulty condition, FriendlyByteBuf buf) {
            buf.m_130130_(condition.difficulties().size());
            condition.difficulties().forEach(arg_0 -> ((FriendlyByteBuf)buf).m_130130_(arg_0));
        }
    }
}

