/*
 * Decompiled with CFR 0.152.
 */
package snownee.lychee.core;

import com.google.common.collect.Lists;
import com.google.gson.JsonElement;
import java.util.LinkedList;
import java.util.stream.Stream;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import snownee.lychee.Lychee;
import snownee.lychee.core.Job;
import snownee.lychee.core.LycheeContext;
import snownee.lychee.core.post.Delay;
import snownee.lychee.core.post.PostAction;
import snownee.lychee.core.recipe.ILycheeRecipe;
import snownee.lychee.util.CommonProxy;

public class ActionRuntime {
    public boolean doDefault = true;
    public State state = State.RUNNING;
    public final LinkedList<Job> jobs = Lists.newLinkedList();
    public Delay.LycheeMarker marker;

    void enqueue(Stream<PostAction> actions, int times) {
        this.jobs.addAll(0, actions.map($ -> new Job((PostAction)$, times)).toList());
    }

    public void run(ILycheeRecipe<?> recipe, LycheeContext ctx) {
        ILycheeRecipe.NBTPatchContext patchContext = ILycheeRecipe.patchContexts.get(recipe.lychee$getId());
        if (patchContext != null && ctx.json == null) {
            ctx.json = patchContext.template().deepCopy();
            for (Integer index : patchContext.usedIndexes()) {
                ItemStack item = ctx.m_8020_(index);
                ctx.json.add(index.toString(), (JsonElement)CommonProxy.tagToJson(item.m_41739_(new CompoundTag())));
            }
            this.jobs.forEach($ -> $.action.preApply(recipe, ctx, patchContext));
            for (Integer index : patchContext.usedIndexes()) {
                try {
                    CompoundTag tag = CommonProxy.jsonToTag(ctx.json.get(Integer.toString(index)));
                    ctx.m_6836_(index, ItemStack.m_41712_((CompoundTag)tag));
                }
                catch (Throwable e) {
                    Lychee.LOGGER.error("Error parsing json result into item " + String.valueOf(ctx.json), e);
                    ctx.runtime.state = State.STOPPED;
                }
            }
        }
        try {
            while (!this.jobs.isEmpty()) {
                this.jobs.pop().apply(recipe, ctx);
                if (ctx.runtime.state == State.RUNNING) continue;
            }
            if (ctx.runtime.state == State.RUNNING || this.jobs.isEmpty()) {
                ctx.runtime.state = State.STOPPED;
            }
        }
        catch (Throwable e) {
            Lychee.LOGGER.error("Error running actions", e);
            ctx.runtime.state = State.STOPPED;
        }
    }

    public static enum State {
        RUNNING,
        PAUSED,
        STOPPED;

    }
}

